/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.SideEffectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.LabelNameRefreshingVisitor;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u001a\u0016\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"aliasArgumentsIfNeeded", "", "context", "Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "arguments", "", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "parameters", "Lcom/google/dart/compiler/backend/js/ast/JsParameter;", "refreshLabelNames", "function", "Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "renameLocalNames", "kotlin-compiler"})
public final class NamingUtilsKt {
    public static final void aliasArgumentsIfNeeded(@NotNull NamingContext context, @NotNull List<? extends JsExpression> arguments2, @NotNull List<JsParameter> parameters2) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        boolean value$iv2 = arguments2.size() <= parameters2.size();
        if (!value$iv2) {
            String message$iv = "arguments.size (" + arguments2.size() + ") should be less or equal to parameters.size (" + parameters2.size() + ")";
            throw (Throwable)new IllegalArgumentException(message$iv.toString());
        }
        for (Pair value$iv2 : CollectionsKt.zip((Iterable)arguments2, (Iterable)parameters2)) {
            JsExpression jsExpression;
            JsExpression arg = (JsExpression)value$iv2.component1();
            JsParameter param = (JsParameter)value$iv2.component2();
            JsName paramName = param.getName();
            if (SideEffectUtilsKt.needToAlias(arg)) {
                JsName jsName = paramName;
                Intrinsics.checkExpressionValueIsNotNull(jsName, "paramName");
                JsName freshName = context.getFreshName(jsName);
                context.newVar(freshName, arg);
                JsExpression jsExpression2 = freshName.makeRef();
                jsExpression = jsExpression2;
                Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "freshName.makeRef()");
            } else {
                jsExpression = arg;
            }
            JsExpression replacement = jsExpression;
            JsName jsName = paramName;
            Intrinsics.checkExpressionValueIsNotNull(jsName, "paramName");
            context.replaceName(jsName, replacement);
        }
        List<JsParameter> defaultParams = parameters2.subList(arguments2.size(), parameters2.size());
        for (JsParameter defaultParam : defaultParams) {
            JsName paramName;
            JsName jsName = paramName = defaultParam.getName();
            Intrinsics.checkExpressionValueIsNotNull(jsName, "paramName");
            JsName freshName = context.getFreshName(jsName);
            NamingContext.newVar$default(context, freshName, null, 2, null);
            JsName jsName2 = paramName;
            Intrinsics.checkExpressionValueIsNotNull(jsName2, "paramName");
            JsExpression jsExpression = freshName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "freshName.makeRef()");
            context.replaceName(jsName2, jsExpression);
        }
    }

    public static final void renameLocalNames(@NotNull NamingContext context, @NotNull JsFunction function) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(function, "function");
        for (JsName name : CollectUtilsKt.collectLocalNames(function)) {
            JsName freshName = context.getFreshName(name);
            JsExpression jsExpression = freshName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "freshName.makeRef()");
            context.replaceName(name, jsExpression);
        }
    }

    public static final void refreshLabelNames(@NotNull NamingContext context, @NotNull JsFunction function) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(function, "function");
        JsFunctionScope scope2 = function.getScope();
        if (!(scope2 instanceof JsFunctionScope)) {
            throw (Throwable)((Object)new AssertionError((Object)"JsFunction is expected to have JsFunctionScope"));
        }
        JsFunctionScope jsFunctionScope = scope2;
        Intrinsics.checkExpressionValueIsNotNull(jsFunctionScope, "scope");
        LabelNameRefreshingVisitor visitor2 = new LabelNameRefreshingVisitor(context, jsFunctionScope);
        visitor2.accept((JsNode)function.getBody());
        context.applyRenameTo(function);
    }
}

