/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.ColorAndFontDescriptionPanel;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorOptionsTree;
import com.intellij.application.options.colors.EditorSchemeAttributeDescriptor;
import com.intellij.application.options.colors.OptionsPanel;
import com.intellij.application.options.colors.SchemesPanel;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;

public class OptionsPanelImpl
extends JPanel
implements OptionsPanel {
    public static final String SELECTED_COLOR_OPTION_PROPERTY = "selected.color.option.type";
    private final ColorOptionsTree myOptionsTree;
    private final ColorAndFontDescriptionPanel myOptionsPanel;
    private final ColorAndFontOptions myOptions;
    private final SchemesPanel mySchemesProvider;
    private final String myCategoryName;
    private final PropertiesComponent myProperties;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);

    public OptionsPanelImpl(ColorAndFontOptions options, SchemesPanel schemesProvider, String categoryName) {
        super(new BorderLayout());
        this.myOptions = options;
        this.mySchemesProvider = schemesProvider;
        this.myCategoryName = categoryName;
        this.myProperties = PropertiesComponent.getInstance();
        this.myOptionsPanel = new ColorAndFontDescriptionPanel(){

            @Override
            protected void onSettingsChanged(ActionEvent e) {
                super.onSettingsChanged(e);
                ((ColorAndFontSettingsListener)OptionsPanelImpl.this.myDispatcher.getMulticaster()).settingsChanged();
            }

            @Override
            protected void onHyperLinkClicked(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String pageName;
                    Settings settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)OptionsPanelImpl.this));
                    String attrName = e.getDescription();
                    Element element = e.getSourceElement();
                    try {
                        pageName = element.getDocument().getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                    }
                    catch (BadLocationException e1) {
                        return;
                    }
                    SearchableConfigurable page = OptionsPanelImpl.this.myOptions.findSubConfigurable(pageName);
                    if (page != null && settings != null) {
                        Runnable runnable2 = page.enableSearch(attrName);
                        ActionCallback callback = settings.select((Configurable)page);
                        if (runnable2 != null) {
                            callback.doWhenDone(runnable2);
                        }
                    }
                }
            }
        };
        this.myOptionsTree = new ColorOptionsTree(this.myCategoryName);
        this.myOptionsTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (!OptionsPanelImpl.this.mySchemesProvider.areSchemesLoaded()) {
                    return;
                }
                OptionsPanelImpl.this.processListValueChanged();
            }
        });
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myOptionsTree));
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)230, (int)60));
        JPanel north = new JPanel(new BorderLayout());
        north.add((Component)scrollPane, "Center");
        north.add((Component)this.myOptionsPanel, "East");
        this.add((Component)north, "North");
    }

    @Override
    public void addListener(ColorAndFontSettingsListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    private void processListValueChanged() {
        String preselectedType;
        ColorAndFontDescription description;
        Object selectedValue = this.myOptionsTree.getSelectedValue();
        ColorAndFontDescription colorAndFontDescription = description = selectedValue instanceof ColorAndFontDescription ? (ColorAndFontDescription)selectedValue : null;
        if (description == null && selectedValue == null && (preselectedType = this.myProperties.getValue(SELECTED_COLOR_OPTION_PROPERTY)) != null) {
            this.myOptionsTree.selectOptionByType(preselectedType);
            description = this.myOptionsTree.getSelectedDescriptor();
        }
        if (description != null) {
            this.myProperties.setValue(SELECTED_COLOR_OPTION_PROPERTY, description.getType());
            this.myOptionsPanel.reset(description);
            ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).selectedOptionChanged(description);
        } else {
            this.myOptionsPanel.resetDefault();
        }
    }

    private void fillOptionsList() {
        this.myOptionsTree.fillOptions(this.myOptions);
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void updateOptionsList() {
        this.fillOptionsList();
        this.processListValueChanged();
    }

    @Override
    public Runnable showOption(final String attributeDisplayName) {
        return new Runnable(){

            @Override
            public void run() {
                OptionsPanelImpl.this.myOptionsTree.selectOptionByName(attributeDisplayName);
            }
        };
    }

    @Override
    public void applyChangesToScheme() {
        ColorAndFontDescription descriptor = this.myOptionsTree.getSelectedDescriptor();
        if (descriptor != null) {
            this.myOptionsPanel.apply(descriptor, this.myOptions.getSelectedScheme());
        }
    }

    @Override
    public void selectOption(String attributeType) {
        this.myOptionsTree.selectOptionByType(attributeType);
    }

    @Override
    public Set<String> processListOptions() {
        EditorSchemeAttributeDescriptor[] descriptions;
        HashSet<String> result = new HashSet<String>();
        for (EditorSchemeAttributeDescriptor description : descriptions = this.myOptions.getCurrentDescriptions()) {
            if (!description.getGroup().equals(this.myCategoryName)) continue;
            result.add(description.toString());
        }
        return result;
    }
}

