/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DeclarationSearcher {
    private final PsiMethod myMethod;
    private final PsiType myTargetType;
    private final Map<PsiElement, PsiVariable> cache;

    DeclarationSearcher(@NotNull PsiMethod method, @NotNull PsiType targetType) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/quickfix/DeclarationSearcher", "<init>"));
        }
        if (targetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetType", "com/intellij/codeInsight/daemon/impl/quickfix/DeclarationSearcher", "<init>"));
        }
        this.cache = new HashMap<PsiElement, PsiVariable>();
        this.myMethod = method;
        this.myTargetType = targetType;
    }

    @Nullable
    public PsiVariable getDeclaration(@NotNull PsiElement endPositionElement) {
        if (endPositionElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endPositionElement", "com/intellij/codeInsight/daemon/impl/quickfix/DeclarationSearcher", "getDeclaration"));
        }
        PsiVariable localVariable = this.getLocalDeclaration(endPositionElement);
        if (localVariable != null) {
            return localVariable;
        }
        return this.getParameterDeclaration();
    }

    @Nullable
    private PsiVariable getParameterDeclaration() {
        for (PsiParameter parameter : this.myMethod.getParameterList().getParameters()) {
            if (!this.myTargetType.equals(parameter.getType())) continue;
            return this.goThroughCache((PsiElement)this.myMethod, (PsiVariable)parameter);
        }
        return null;
    }

    @Nullable
    private PsiVariable getLocalDeclaration(@NotNull PsiElement endPositionElement) {
        PsiVariable parentResult;
        if (endPositionElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endPositionElement", "com/intellij/codeInsight/daemon/impl/quickfix/DeclarationSearcher", "getLocalDeclaration"));
        }
        PsiElement parent = endPositionElement.getParent();
        if (parent == null) {
            return null;
        }
        PsiVariable cachedCandidate = this.cache.get(parent);
        if (cachedCandidate != null) {
            return cachedCandidate;
        }
        if (parent != this.myMethod && (parentResult = this.getLocalDeclaration(parent)) != null) {
            return parentResult;
        }
        for (PsiElement element : parent.getChildren()) {
            if (element == endPositionElement) break;
            if (element instanceof PsiDeclarationStatement) {
                PsiElement[] declared;
                for (PsiElement declaredElement : declared = ((PsiDeclarationStatement)element).getDeclaredElements()) {
                    if (!(declaredElement instanceof PsiLocalVariable) || !this.myTargetType.equals(((PsiLocalVariable)declaredElement).getType())) continue;
                    return this.goThroughCache(parent, (PsiVariable)declaredElement);
                }
                continue;
            }
            if (!(element instanceof PsiParameter) || !this.myTargetType.equals(((PsiParameter)element).getType())) continue;
            return this.goThroughCache(parent, (PsiVariable)element);
        }
        return null;
    }

    private PsiVariable goThroughCache(PsiElement parent, PsiVariable variable) {
        this.cache.put(parent, variable);
        return variable;
    }
}

