/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.openapi.editor.actions.FlipCommaIntention;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;

public class JavaFlipper
implements FlipCommaIntention.Flipper {
    @Override
    public boolean flip(PsiElement left, PsiElement right) {
        if (left instanceof PsiVariable && right instanceof PsiVariable) {
            PsiElement first = left.getFirstChild();
            if (!(first instanceof PsiModifierList)) {
                return false;
            }
            PsiElement child = PsiTreeUtil.skipSiblingsForward((PsiElement)first, (Class[])new Class[]{PsiWhiteSpace.class});
            if (!(child instanceof PsiTypeElement)) {
                return false;
            }
            PsiElement last = child.getNextSibling();
            if (!(last instanceof PsiWhiteSpace)) {
                return false;
            }
            PsiElement anchor = right.getFirstChild();
            if (!(anchor instanceof PsiIdentifier)) {
                return false;
            }
            PsiElement semiColon = right.getLastChild();
            if (!(semiColon instanceof PsiJavaToken)) {
                return false;
            }
            right.addRangeBefore(first, last, anchor);
            left.deleteChildRange(first, last);
            left.add(semiColon);
            semiColon.delete();
            PsiElement copy = left.copy();
            left.replace(right);
            right.replace(copy);
            return true;
        }
        return false;
    }
}

