/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.ui.impl.InspectPanel;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectDialog
extends DialogWrapper
implements DebuggerContextListener {
    private InspectPanel myInspectView;
    private final DebuggerContextImpl myDebuggerContext;

    public InspectDialog(Project project2, DebuggerStateManager stateManager, String title, NodeDescriptorImpl inspectDescriptor) {
        super(project2, true);
        this.setTitle(title);
        this.setModal(false);
        this.myDebuggerContext = stateManager.getContext();
        DebuggerSession session = this.myDebuggerContext.getDebuggerSession();
        assert (session != null);
        this.myInspectView = new InspectPanel(project2, session.getContextManager(), inspectDescriptor);
        this.myInspectView.setBorder(BorderFactory.createEtchedBorder());
        this.init();
        session.getContextManager().addListener(this);
        this.getInspectView().rebuildIfVisible(DebuggerSession.Event.CONTEXT);
    }

    protected JComponent createCenterPanel() {
        return this.myInspectView;
    }

    protected JComponent createSouthPanel() {
        return null;
    }

    public void dispose() {
        DebuggerSession session = this.myDebuggerContext.getDebuggerSession();
        if (session != null) {
            session.getContextManager().removeListener(this);
        }
        if (this.myInspectView != null) {
            this.myInspectView.dispose();
            this.myInspectView = null;
        }
        super.dispose();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.debugger.ui.impl.InspectDialog";
    }

    public InspectPanel getInspectView() {
        return this.myInspectView;
    }

    @Override
    public void changeEvent(@NotNull DebuggerContextImpl newContext, DebuggerSession.Event event) {
        if (newContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "com/intellij/debugger/ui/impl/InspectDialog", "changeEvent"));
        }
        if (event == DebuggerSession.Event.DETACHED) {
            this.close(1);
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myInspectView.getInspectTree();
    }
}

