/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GotoBookmarkActionBase
extends EditorAction {
    protected GotoBookmarkActionBase(final boolean next) {
        super(new EditorActionHandler(){

            public void execute(Editor editor, DataContext dataContext) {
                this.navigateToBookmark(dataContext, editor);
            }

            public boolean isEnabled(Editor editor, DataContext dataContext) {
                return this.getBookmarkToGo(dataContext, editor) != null;
            }

            private void navigateToBookmark(DataContext dataContext, @NotNull Editor editor) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ide/bookmarks/actions/GotoBookmarkActionBase$1", "navigateToBookmark"));
                }
                Bookmark bookmark = this.getBookmarkToGo(dataContext, editor);
                if (bookmark == null) {
                    return;
                }
                int line = bookmark.getLine();
                if (line >= editor.getDocument().getLineCount()) {
                    return;
                }
                if (line < 0) {
                    line = 0;
                }
                LogicalPosition pos = new LogicalPosition(line, 0);
                editor.getSelectionModel().removeSelection();
                editor.getCaretModel().removeSecondaryCarets();
                editor.getCaretModel().moveToLogicalPosition(pos);
                editor.getScrollingModel().scrollTo(new LogicalPosition(line, 0), ScrollType.CENTER);
            }

            @Nullable
            private Bookmark getBookmarkToGo(DataContext dataContext, Editor editor) {
                Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                if (project2 == null) {
                    return null;
                }
                BookmarkManager manager = BookmarkManager.getInstance(project2);
                return next ? manager.getNextBookmark(editor, true) : manager.getPreviousBookmark(editor, true);
            }
        });
    }
}

