/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.ide.projectView.impl.Retriever;
import com.intellij.ide.projectView.impl.nodes.DropTargetNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.copy.CopyHandler;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.util.ArrayUtilRt;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProjectViewDropTarget
implements DnDNativeTarget {
    private final JTree myTree;
    private final Retriever myRetriever;
    private final Project myProject;

    ProjectViewDropTarget(JTree tree, Retriever retriever, Project project2) {
        this.myTree = tree;
        this.myRetriever = retriever;
        this.myProject = project2;
    }

    public boolean update(DnDEvent event) {
        Rectangle pathBounds;
        event.setDropPossible(false, "");
        Object attached = event.getAttachedObject();
        int dropAction = event.getAction().getActionId();
        DropHandler dropHandler = this.getDropHandler(dropAction);
        Object[] sourceNodes = ProjectViewDropTarget.getSourceNodes(attached);
        Point point = event.getPoint();
        TreeNode targetNode = this.getTargetNode(point);
        if (targetNode == null || (dropAction & 3) == 0 || sourceNodes == null && !FileCopyPasteUtil.isFileListFlavorAvailable(event) || sourceNodes != null && ArrayUtilRt.find((Object[])sourceNodes, (Object)targetNode) != -1 || sourceNodes != null && !dropHandler.isValidSource((TreeNode[])sourceNodes, targetNode)) {
            return false;
        }
        if (sourceNodes != null) {
            boolean redundant = true;
            for (Object sourceNode : sourceNodes) {
                if (dropHandler.isDropRedundant((TreeNode)sourceNode, targetNode)) continue;
                redundant = false;
                break;
            }
            if (redundant) {
                return false;
            }
        } else if (!SystemInfo.isMac) {
            PsiFileSystemItem[] psiFiles = this.getPsiFiles(FileCopyPasteUtil.getFileListFromAttachedObject(attached));
            if (psiFiles == null || psiFiles.length == 0) {
                return false;
            }
            if (!MoveHandler.isValidTarget(this.getPsiElement(targetNode), (PsiElement[])psiFiles)) {
                return false;
            }
        }
        if ((pathBounds = this.myTree.getPathBounds(this.myTree.getClosestPathForLocation(point.x, point.y))) != null && pathBounds.y + pathBounds.height < point.y) {
            return false;
        }
        event.setHighlighting(new RelativeRectangle((Component)this.myTree, pathBounds), 1);
        event.setDropPossible(true);
        return false;
    }

    public void drop(DnDEvent event) {
        Object attached = event.getAttachedObject();
        TreeNode[] sourceNodes = ProjectViewDropTarget.getSourceNodes(attached);
        TreeNode targetNode = this.getTargetNode(event.getPoint());
        assert (targetNode != null);
        int dropAction = event.getAction().getActionId();
        if (sourceNodes == null) {
            List<File> fileList;
            if (FileCopyPasteUtil.isFileListFlavorAvailable(event) && !(fileList = FileCopyPasteUtil.getFileListFromAttachedObject(attached)).isEmpty()) {
                this.getDropHandler(dropAction).doDropFiles(fileList, targetNode);
            }
        } else {
            this.doDrop(sourceNodes, targetNode, dropAction);
        }
    }

    public void cleanUpOnLeave() {
    }

    public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
    }

    @Nullable
    private static TreeNode[] getSourceNodes(Object transferData) {
        if (transferData instanceof TransferableWrapper) {
            return ((TransferableWrapper)transferData).getTreeNodes();
        }
        return null;
    }

    @Nullable
    private TreeNode getTargetNode(Point location) {
        TreePath path = this.myTree.getClosestPathForLocation(location.x, location.y);
        return path == null ? null : (TreeNode)path.getLastPathComponent();
    }

    private boolean doDrop(@NotNull TreeNode[] sourceNodes, @NotNull TreeNode targetNode, int dropAction) {
        TreeNode[] filteredSourceNodes;
        if (sourceNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNodes", "com/intellij/ide/projectView/impl/ProjectViewDropTarget", "doDrop"));
        }
        if (targetNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNode", "com/intellij/ide/projectView/impl/ProjectViewDropTarget", "doDrop"));
        }
        TreeNode validTargetNode = this.getValidTargetNode(sourceNodes, targetNode, dropAction);
        if (validTargetNode != null && (filteredSourceNodes = this.removeRedundantSourceNodes(sourceNodes, validTargetNode, dropAction)).length != 0) {
            this.getDropHandler(dropAction).doDrop(filteredSourceNodes, validTargetNode);
            return true;
        }
        return false;
    }

    @Nullable
    private TreeNode getValidTargetNode(@NotNull TreeNode[] sourceNodes, @NotNull TreeNode targetNode, int dropAction) {
        if (sourceNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNodes", "com/intellij/ide/projectView/impl/ProjectViewDropTarget", "getValidTargetNode"));
        }
        if (targetNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNode", "com/intellij/ide/projectView/impl/ProjectViewDropTarget", "getValidTargetNode"));
        }
        DropHandler dropHandler = this.getDropHandler(dropAction);
        TreeNode currentNode = targetNode;
        do {
            if (dropHandler.isValidTarget(sourceNodes, currentNode)) {
                return currentNode;
            }
            if (dropHandler.shouldDelegateToParent(sourceNodes, currentNode)) continue;
            return null;
        } while ((currentNode = currentNode.getParent()) != null);
        return null;
    }

    private TreeNode[] removeRedundantSourceNodes(@NotNull TreeNode[] sourceNodes, @NotNull TreeNode targetNode, int dropAction) {
        if (sourceNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNodes", "com/intellij/ide/projectView/impl/ProjectViewDropTarget", "removeRedundantSourceNodes"));
        }
        if (targetNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNode", "com/intellij/ide/projectView/impl/ProjectViewDropTarget", "removeRedundantSourceNodes"));
        }
        DropHandler dropHandler = this.getDropHandler(dropAction);
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(sourceNodes.length);
        for (TreeNode sourceNode : sourceNodes) {
            if (dropHandler.isDropRedundant(sourceNode, targetNode)) continue;
            result.add(sourceNode);
        }
        return result.toArray(new TreeNode[result.size()]);
    }

    public DropHandler getDropHandler(int dropAction) {
        return dropAction == 1 ? new CopyDropHandler() : new MoveDropHandler();
    }

    @Nullable
    protected PsiElement getPsiElement(@Nullable TreeNode treeNode) {
        return this.myRetriever.getPsiElement(treeNode);
    }

    protected Module getModule(@Nullable TreeNode treeNode) {
        return this.myRetriever.getModule(treeNode);
    }

    @Nullable
    protected PsiFileSystemItem[] getPsiFiles(@Nullable List<File> fileList) {
        if (fileList == null) {
            return null;
        }
        ArrayList<PsiDirectory> sourceFiles = new ArrayList<PsiDirectory>();
        for (File file2 : fileList) {
            PsiDirectory psiFile;
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
            if (vFile == null || (psiFile = vFile.isDirectory() ? PsiManager.getInstance((Project)this.myProject).findDirectory(vFile) : PsiManager.getInstance((Project)this.myProject).findFile(vFile)) == null) continue;
            sourceFiles.add(psiFile);
        }
        return sourceFiles.toArray(new PsiFileSystemItem[sourceFiles.size()]);
    }

    private class CopyDropHandler
    extends MoveCopyDropHandler {
        private CopyDropHandler() {
        }

        @Override
        protected boolean canDrop(@NotNull TreeNode[] sourceNodes, @Nullable TreeNode targetNode) {
            if (sourceNodes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNodes", "com/intellij/ide/projectView/impl/ProjectViewDropTarget$CopyDropHandler", "canDrop"));
            }
            PsiElement[] sourceElements = this.getPsiElements(sourceNodes);
            PsiElement targetElement = ProjectViewDropTarget.this.getPsiElement(targetNode);
            if (targetElement == null) {
                return false;
            }
            PsiFile containingFile = targetElement.getContainingFile();
            boolean isTargetAcceptable = targetElement instanceof PsiDirectoryContainer || targetElement instanceof PsiDirectory || containingFile != null && containingFile.getContainingDirectory() != null;
            return isTargetAcceptable && CopyHandler.canCopy(sourceElements);
        }

        @Override
        public void doDrop(@NotNull TreeNode[] sourceNodes, @NotNull TreeNode targetNode) {
            if (sourceNodes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNodes", "com/intellij/ide/projectView/impl/ProjectViewDropTarget$CopyDropHandler", "doDrop"));
            }
            if (targetNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNode", "com/intellij/ide/projectView/impl/ProjectViewDropTarget$CopyDropHandler", "doDrop"));
            }
            PsiElement[] sourceElements = this.getPsiElements(sourceNodes);
            this.doDrop(targetNode, sourceElements);
        }

        private void doDrop(TreeNode targetNode, PsiElement[] sourceElements) {
            PsiDirectory psiDirectory;
            PsiElement targetElement = ProjectViewDropTarget.this.getPsiElement(targetNode);
            if (targetElement == null) {
                return;
            }
            if (targetElement instanceof PsiDirectoryContainer) {
                PsiDirectoryContainer directoryContainer = (PsiDirectoryContainer)targetElement;
                PsiDirectory[] psiDirectories = directoryContainer.getDirectories();
                psiDirectory = psiDirectories.length != 0 ? psiDirectories[0] : null;
            } else if (targetElement instanceof PsiDirectory) {
                psiDirectory = (PsiDirectory)targetElement;
            } else {
                PsiFile containingFile = targetElement.getContainingFile();
                DnDNativeTarget.LOG.assertTrue(containingFile != null);
                psiDirectory = containingFile.getContainingDirectory();
            }
            CopyHandler.doCopy(sourceElements, psiDirectory);
        }

        @Override
        public boolean isDropRedundant(@NotNull TreeNode sourceNode, @NotNull TreeNode targetNode) {
            if (sourceNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNode", "com/intellij/ide/projectView/impl/ProjectViewDropTarget$CopyDropHandler", "isDropRedundant"));
            }
            if (targetNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNode", "com/intellij/ide/projectView/impl/ProjectViewDropTarget$CopyDropHandler", "isDropRedundant"));
            }
            return false;
        }

        @Override
        public boolean shouldDelegateToParent(TreeNode[] sourceNodes, @NotNull TreeNode targetNode) {
            if (targetNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNode", "com/intellij/ide/projectView/impl/ProjectViewDropTarget$CopyDropHandler", "shouldDelegateToParent"));
            }
            PsiElement psiElement = ProjectViewDropTarget.this.getPsiElement(targetNode);
            return psiElement == null || !(psiElement instanceof PsiDirectoryContainer) && !(psiElement instanceof PsiDirectory);
        }

        @Override
        public void doDropFiles(List<File> fileList, TreeNode targetNode) {
            PsiFileSystemItem[] sourceFileArray = ProjectViewDropTarget.this.getPsiFiles(fileList);
            this.doDrop(targetNode, (PsiElement[])sourceFileArray);
        }
    }

    private class MoveDropHandler
    extends MoveCopyDropHandler {
        private MoveDropHandler() {
        }

        @Override
        protected boolean canDrop(@NotNull TreeNode[] sourceNodes, @Nullable TreeNode targetNode) {
            Object userObject;
            if (sourceNodes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNodes", "com/intellij/ide/projectView/impl/ProjectViewDropTarget$MoveDropHandler", "canDrop"));
            }
            if (targetNode instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)targetNode).getUserObject()) instanceof DropTargetNode && ((DropTargetNode)userObject).canDrop(sourceNodes)) {
                return true;
            }
            PsiElement[] sourceElements = this.getPsiElements(sourceNodes);
            PsiElement targetElement = ProjectViewDropTarget.this.getPsiElement(targetNode);
            return sourceElements.length == 0 || (targetNode == null || targetElement != null) && MoveHandler.canMove(sourceElements, targetElement);
        }

        @Override
        public void doDrop(@NotNull TreeNode[] sourceNodes, @NotNull TreeNode targetNode) {
            Object userObject;
            if (sourceNodes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNodes", "com/intellij/ide/projectView/impl/ProjectViewDropTarget$MoveDropHandler", "doDrop"));
            }
            if (targetNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNode", "com/intellij/ide/projectView/impl/ProjectViewDropTarget$MoveDropHandler", "doDrop"));
            }
            if (targetNode instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)targetNode).getUserObject()) instanceof DropTargetNode && ((DropTargetNode)userObject).canDrop(sourceNodes)) {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)ProjectViewDropTarget.this.myTree);
                ((DropTargetNode)userObject).drop(sourceNodes, dataContext);
            }
            PsiElement[] sourceElements = this.getPsiElements(sourceNodes);
            this.doDrop(targetNode, sourceElements, false);
        }

        private void doDrop(TreeNode targetNode, PsiElement[] sourceElements, final boolean externalDrop) {
            final PsiElement targetElement = ProjectViewDropTarget.this.getPsiElement(targetNode);
            if (targetElement == null) {
                return;
            }
            if (DumbService.isDumb((Project)ProjectViewDropTarget.this.myProject)) {
                Messages.showMessageDialog((Project)ProjectViewDropTarget.this.myProject, (String)"Move refactoring is not available while indexing is in progress", (String)"Indexing", null);
                return;
            }
            final Module module2 = ProjectViewDropTarget.this.getModule(targetNode);
            final DataContext dataContext = DataManager.getInstance().getDataContext((Component)ProjectViewDropTarget.this.myTree);
            PsiDocumentManager.getInstance((Project)ProjectViewDropTarget.this.myProject).commitAllDocuments();
            if (!targetElement.isValid()) {
                return;
            }
            for (PsiElement sourceElement : sourceElements) {
                if (sourceElement.isValid()) continue;
                return;
            }
            this.getActionHandler().invoke(ProjectViewDropTarget.this.myProject, sourceElements, new DataContext(){

                @Nullable
                public Object getData(@NonNls String dataId) {
                    if (LangDataKeys.TARGET_MODULE.is(dataId) && module2 != null) {
                        return module2;
                    }
                    if (LangDataKeys.TARGET_PSI_ELEMENT.is(dataId)) {
                        return targetElement;
                    }
                    return externalDrop ? null : dataContext.getData(dataId);
                }
            });
        }

        private RefactoringActionHandler getActionHandler() {
            return RefactoringActionHandlerFactory.getInstance().createMoveHandler();
        }

        @Override
        public boolean isDropRedundant(@NotNull TreeNode sourceNode, @NotNull TreeNode targetNode) {
            if (sourceNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNode", "com/intellij/ide/projectView/impl/ProjectViewDropTarget$MoveDropHandler", "isDropRedundant"));
            }
            if (targetNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNode", "com/intellij/ide/projectView/impl/ProjectViewDropTarget$MoveDropHandler", "isDropRedundant"));
            }
            return sourceNode.getParent() == targetNode || MoveHandler.isMoveRedundant(ProjectViewDropTarget.this.getPsiElement(sourceNode), ProjectViewDropTarget.this.getPsiElement(targetNode));
        }

        @Override
        public boolean shouldDelegateToParent(TreeNode[] sourceNodes, @NotNull TreeNode targetNode) {
            if (targetNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNode", "com/intellij/ide/projectView/impl/ProjectViewDropTarget$MoveDropHandler", "shouldDelegateToParent"));
            }
            PsiElement psiElement = ProjectViewDropTarget.this.getPsiElement(targetNode);
            return !MoveHandler.isValidTarget(psiElement, this.getPsiElements(sourceNodes));
        }

        @Override
        public void doDropFiles(List<File> fileList, TreeNode targetNode) {
            Object userObject;
            PsiFileSystemItem[] sourceFileArray = ProjectViewDropTarget.this.getPsiFiles(fileList);
            if (targetNode instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)targetNode).getUserObject()) instanceof DropTargetNode) {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)ProjectViewDropTarget.this.myTree);
                ((DropTargetNode)userObject).dropExternalFiles(sourceFileArray, dataContext);
                return;
            }
            this.doDrop(targetNode, (PsiElement[])sourceFileArray, true);
        }
    }

    public abstract class MoveCopyDropHandler
    implements DropHandler {
        @Override
        public boolean isValidSource(@NotNull TreeNode[] sourceNodes, TreeNode targetNode) {
            if (sourceNodes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNodes", "com/intellij/ide/projectView/impl/ProjectViewDropTarget$MoveCopyDropHandler", "isValidSource"));
            }
            return this.canDrop(sourceNodes, targetNode);
        }

        @Override
        public boolean isValidTarget(@NotNull TreeNode[] sourceNodes, @NotNull TreeNode targetNode) {
            if (sourceNodes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNodes", "com/intellij/ide/projectView/impl/ProjectViewDropTarget$MoveCopyDropHandler", "isValidTarget"));
            }
            if (targetNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNode", "com/intellij/ide/projectView/impl/ProjectViewDropTarget$MoveCopyDropHandler", "isValidTarget"));
            }
            return this.canDrop(sourceNodes, targetNode);
        }

        protected abstract boolean canDrop(@NotNull TreeNode[] var1, @Nullable TreeNode var2);

        @NotNull
        protected PsiElement[] getPsiElements(@NotNull TreeNode[] nodes) {
            if (nodes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/ide/projectView/impl/ProjectViewDropTarget$MoveCopyDropHandler", "getPsiElements"));
            }
            ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>(nodes.length);
            for (TreeNode node : nodes) {
                PsiElement psiElement = ProjectViewDropTarget.this.getPsiElement(node);
                if (psiElement == null) continue;
                psiElements.add(psiElement);
            }
            if (psiElements.size() != 0) {
                PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(psiElements);
                if (psiElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/ProjectViewDropTarget$MoveCopyDropHandler", "getPsiElements"));
                }
                return psiElementArray;
            }
            PsiElement[] psiElementArray = BaseRefactoringAction.getPsiElementArray(DataManager.getInstance().getDataContext((Component)ProjectViewDropTarget.this.myTree));
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/ProjectViewDropTarget$MoveCopyDropHandler", "getPsiElements"));
            }
            return psiElementArray;
        }
    }

    private static interface DropHandler {
        public boolean isValidSource(@NotNull TreeNode[] var1, TreeNode var2);

        public boolean isValidTarget(@NotNull TreeNode[] var1, @NotNull TreeNode var2);

        public boolean shouldDelegateToParent(TreeNode[] var1, @NotNull TreeNode var2);

        public boolean isDropRedundant(@NotNull TreeNode var1, @NotNull TreeNode var2);

        public void doDrop(@NotNull TreeNode[] var1, @NotNull TreeNode var2);

        public void doDropFiles(List<File> var1, TreeNode var2);
    }
}

