/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.util.TimeoutUtil;
import org.jetbrains.annotations.NotNull;

public class ToggleDumbModeAction
extends AnAction
implements DumbAware {
    private volatile boolean myDumb = false;

    public void actionPerformed(AnActionEvent e) {
        if (this.myDumb) {
            this.myDumb = false;
        } else {
            this.myDumb = true;
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
            if (project2 == null) {
                return;
            }
            DumbServiceImpl.getInstance(project2).queueTask(new DumbModeTask(){

                public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/internal/ToggleDumbModeAction$1", "performInDumbMode"));
                    }
                    while (ToggleDumbModeAction.this.myDumb) {
                        indicator.checkCanceled();
                        TimeoutUtil.sleep((long)100L);
                    }
                }
            });
        }
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        presentation.setEnabled(project2 != null && this.myDumb == DumbServiceImpl.getInstance(project2).isDumb());
        if (this.myDumb) {
            presentation.setText("Exit Dumb Mode");
        } else {
            presentation.setText("Enter Dumb Mode");
        }
    }
}

