/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.CurrentRevisionProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCurrentRevisionProxy
implements ContentRevision {
    private final DiffProvider myDiffProvider;
    private final VirtualFile myFile;
    private final Project myProject;
    private final VcsKey myVcsKey;

    @Nullable
    public static VcsCurrentRevisionProxy create(VirtualFile file2, Project project2, VcsKey vcsKey) {
        DiffProvider diffProvider;
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project2).findVcsByName(vcsKey.getName());
        if (vcs != null && (diffProvider = vcs.getDiffProvider()) != null) {
            return new VcsCurrentRevisionProxy(diffProvider, file2, project2, vcsKey);
        }
        return null;
    }

    private VcsCurrentRevisionProxy(DiffProvider diffProvider, VirtualFile file2, Project project2, VcsKey vcsKey) {
        this.myDiffProvider = diffProvider;
        this.myFile = file2;
        this.myProject = project2;
        this.myVcsKey = vcsKey;
    }

    @Nullable
    public String getContent() throws VcsException {
        return this.getVcsRevision().getContent();
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)this.myFile);
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy", "getFile"));
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber;
        try {
            vcsRevisionNumber = this.getVcsRevision().getRevisionNumber();
        }
        catch (VcsException ex) {
            VcsRevisionNumber vcsRevisionNumber2 = VcsRevisionNumber.NULL;
            if (vcsRevisionNumber2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy", "getRevisionNumber"));
            }
            return vcsRevisionNumber2;
        }
        if (vcsRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy", "getRevisionNumber"));
        }
        return vcsRevisionNumber;
    }

    private ContentRevision getVcsRevision() throws VcsException {
        Pair pair;
        final FilePath file2 = this.getFile();
        try {
            pair = ContentRevisionCache.getOrLoadCurrentAsBytes((Project)this.myProject, (FilePath)file2, (VcsKey)this.myVcsKey, (CurrentRevisionProvider)new CurrentRevisionProvider(){

                public VcsRevisionNumber getCurrentRevision() throws VcsException {
                    return VcsCurrentRevisionProxy.this.getCurrentRevisionNumber();
                }

                public Pair<VcsRevisionNumber, byte[]> get() throws VcsException, IOException {
                    return VcsCurrentRevisionProxy.this.loadContent();
                }
            });
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
        return new ByteBackedContentRevision(){

            public String getContent() throws VcsException {
                byte[] byteContent = this.getContentAsBytes();
                return ContentRevisionCache.getAsString((byte[])byteContent, (FilePath)file2, null);
            }

            @Nullable
            public byte[] getContentAsBytes() throws VcsException {
                return (byte[])pair.getSecond();
            }

            @NotNull
            public FilePath getFile() {
                FilePath filePath = file2;
                if (filePath == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy$2", "getFile"));
                }
                return filePath;
            }

            @NotNull
            public VcsRevisionNumber getRevisionNumber() {
                VcsRevisionNumber vcsRevisionNumber = (VcsRevisionNumber)pair.getFirst();
                if (vcsRevisionNumber == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy$2", "getRevisionNumber"));
                }
                return vcsRevisionNumber;
            }
        };
    }

    private VcsRevisionNumber getCurrentRevisionNumber() throws VcsException {
        VcsRevisionNumber currentRevision = this.myDiffProvider.getCurrentRevision(this.myFile);
        if (currentRevision == null) {
            throw new VcsException("Failed to fetch current revision");
        }
        return currentRevision;
    }

    private Pair<VcsRevisionNumber, byte[]> loadContent() throws VcsException {
        VcsRevisionNumber currentRevision = this.getCurrentRevisionNumber();
        ContentRevision contentRevision = this.myDiffProvider.createFileContent(currentRevision, this.myFile);
        if (contentRevision == null) {
            throw new VcsException("Failed to create content for current revision");
        }
        Charset charset = this.myFile.getCharset();
        return Pair.create((Object)currentRevision, (Object)contentRevision.getContent().getBytes(charset));
    }
}

