/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.Nullable;

public class FunctionalInterfaceParameterizationUtil {
    private static final Logger LOG = Logger.getInstance((String)("#" + FunctionalInterfaceParameterizationUtil.class.getName()));

    public static boolean isWildcardParameterized(@Nullable PsiType classType) {
        if (classType == null) {
            return false;
        }
        if (classType instanceof PsiIntersectionType) {
            for (PsiType type : ((PsiIntersectionType)classType).getConjuncts()) {
                if (FunctionalInterfaceParameterizationUtil.isWildcardParameterized(type)) continue;
                return false;
            }
        }
        if (classType instanceof PsiClassType) {
            PsiClassType.ClassResolveResult result = ((PsiClassType)classType).resolveGenerics();
            PsiClass aClass = result.getElement();
            if (aClass != null) {
                PsiSubstitutor substitutor = result.getSubstitutor();
                for (PsiTypeParameter parameter : aClass.getTypeParameters()) {
                    if (!(substitutor.substitute(parameter) instanceof PsiWildcardType)) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Nullable
    public static PsiType getGroundTargetType(@Nullable PsiType psiClassType) {
        return FunctionalInterfaceParameterizationUtil.getGroundTargetType(psiClassType, null);
    }

    @Nullable
    public static PsiType getGroundTargetType(@Nullable PsiType psiClassType, @Nullable PsiLambdaExpression expr) {
        return FunctionalInterfaceParameterizationUtil.getGroundTargetType(psiClassType, expr, true);
    }

    @Nullable
    public static PsiType getGroundTargetType(@Nullable PsiType psiClassType, @Nullable PsiLambdaExpression expr, boolean performFinalCheck) {
        if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(psiClassType)) {
            return psiClassType;
        }
        if (expr != null && expr.hasFormalParameterTypes()) {
            return FunctionalInterfaceParameterizationUtil.getFunctionalTypeExplicit(psiClassType, expr, performFinalCheck);
        }
        return psiClassType instanceof PsiClassType ? FunctionalInterfaceParameterizationUtil.getNonWildcardParameterization((PsiClassType)psiClassType) : null;
    }

    private static PsiType getFunctionalTypeExplicit(PsiType psiClassType, PsiLambdaExpression expr, boolean performFinalCheck) {
        PsiParameter[] lambdaParams = expr.getParameterList().getParameters();
        if (psiClassType instanceof PsiIntersectionType) {
            for (PsiType psiType : ((PsiIntersectionType)psiClassType).getConjuncts()) {
                PsiType functionalType = FunctionalInterfaceParameterizationUtil.getFunctionalTypeExplicit(psiType, expr, performFinalCheck);
                if (functionalType == null) continue;
                return functionalType;
            }
            return null;
        }
        LOG.assertTrue(psiClassType instanceof PsiClassType, (Object)("Unexpected type: " + psiClassType));
        PsiType[] parameters = ((PsiClassType)psiClassType).getParameters();
        PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)psiClassType).resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass != null) {
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult);
            if (interfaceMethod == null) {
                return null;
            }
            PsiTypeParameter[] typeParameters = psiClass.getTypeParameters();
            if (typeParameters.length != parameters.length) {
                return null;
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
            PsiParameter[] targetMethodParams = interfaceMethod.getParameterList().getParameters();
            if (targetMethodParams.length != lambdaParams.length) {
                return null;
            }
            InferenceSession session = new InferenceSession(typeParameters, PsiSubstitutor.EMPTY, expr.getManager(), (PsiElement)expr);
            for (int i = 0; i < targetMethodParams.length; ++i) {
                session.addConstraint(new TypeEqualityConstraint(lambdaParams[i].getType(), session.substituteWithInferenceVariables(targetMethodParams[i].getType())));
            }
            if (!session.repeatInferencePhases()) {
                return null;
            }
            PsiSubstitutor substitutor = session.getInstantiations(session.getInferenceVariables());
            PsiType[] newTypeParameters = new PsiType[parameters.length];
            for (int i = 0; i < typeParameters.length; ++i) {
                PsiTypeParameter typeParameter = typeParameters[i];
                newTypeParameters[i] = substitutor.getSubstitutionMap().containsKey(typeParameter) ? substitutor.substitute(typeParameter) : parameters[i];
            }
            PsiClassType parameterization = elementFactory.createType(psiClass, newTypeParameters);
            if (!FunctionalInterfaceParameterizationUtil.isWellFormed(psiClass, typeParameters, newTypeParameters) || performFinalCheck && !psiClassType.isAssignableFrom((PsiType)parameterization)) {
                return null;
            }
            if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized((PsiType)parameterization)) {
                return parameterization;
            }
            return FunctionalInterfaceParameterizationUtil.getNonWildcardParameterization(parameterization);
        }
        return null;
    }

    private static boolean isWellFormed(PsiClass psiClass, PsiTypeParameter[] typeParameters, PsiType[] newTypeParameters) {
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY.putAll(psiClass, newTypeParameters);
        for (int i = 0; i < typeParameters.length; ++i) {
            for (PsiClassType bound : typeParameters[i].getExtendsListTypes()) {
                if (!GenericsUtil.checkNotInBounds((PsiType)newTypeParameters[i], (PsiType)substitutor.substitute((PsiType)bound), (boolean)false)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static PsiType getNonWildcardParameterization(PsiClassType psiClassType) {
        PsiClassType.ClassResolveResult result = psiClassType.resolveGenerics();
        PsiClass psiClass = result.getElement();
        if (psiClass != null) {
            Object[] typeParameters = psiClass.getTypeParameters();
            PsiType[] newParameters = new PsiType[typeParameters.length];
            PsiSubstitutor substitutor = result.getSubstitutor();
            HashSet typeParametersSet = ContainerUtil.newHashSet((Object[])typeParameters);
            for (int i = 0; i < typeParameters.length; ++i) {
                PsiType paramType = substitutor.substitute((PsiTypeParameter)typeParameters[i]);
                if (paramType instanceof PsiWildcardType) {
                    for (PsiClassType paramBound : typeParameters[i].getExtendsListTypes()) {
                        if (!PsiPolyExpressionUtil.mentionsTypeParameters((PsiType)paramBound, typeParametersSet).booleanValue()) continue;
                        return null;
                    }
                    PsiType bound = ((PsiWildcardType)paramType).getBound();
                    if (((PsiWildcardType)paramType).isSuper()) {
                        newParameters[i] = bound;
                        continue;
                    }
                    newParameters[i] = bound != null ? bound : PsiType.getJavaLangObject((PsiManager)psiClass.getManager(), (GlobalSearchScope)psiClassType.getResolveScope());
                    for (PsiClassType paramBound : typeParameters[i].getExtendsListTypes()) {
                        newParameters[i] = GenericsUtil.getGreatestLowerBound((PsiType)newParameters[i], (PsiType)paramBound);
                    }
                    continue;
                }
                newParameters[i] = paramType;
            }
            if (!FunctionalInterfaceParameterizationUtil.isWellFormed(psiClass, (PsiTypeParameter[])typeParameters, newParameters)) {
                return null;
            }
            PsiClassType parameterization = JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(psiClass, newParameters);
            if (!psiClassType.isAssignableFrom((PsiType)parameterization)) {
                return null;
            }
            return parameterization;
        }
        return null;
    }
}

