/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.testIntegration.SuiteInfo;
import com.intellij.testIntegration.TestInfo;
import com.intellij.testIntegration.TestLocator;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class RecentTestsData {
    private static Comparator<TestInfo> BY_PATH_COMPARATOR = new Comparator<TestInfo>(){

        @Override
        public int compare(TestInfo o1, TestInfo o2) {
            String path1 = VirtualFileManager.extractPath((String)o1.getUrl());
            String path2 = VirtualFileManager.extractPath((String)o2.getUrl());
            return path1.compareTo(path2);
        }
    };
    private static Comparator<SuiteInfo> SUITE_BY_RECENT_COMPARATOR = new Comparator<SuiteInfo>(){

        @Override
        public int compare(SuiteInfo o1, SuiteInfo o2) {
            return -o1.getMostRecentRunDate().compareTo(o2.getMostRecentRunDate());
        }
    };
    private static Comparator<TestInfo> TEST_BY_RECENT_COMPARATOR = new Comparator<TestInfo>(){

        @Override
        public int compare(TestInfo o1, TestInfo o2) {
            return -o1.getRunDate().compareTo(o2.getRunDate());
        }
    };
    private final Map<String, SuiteInfo> mySuites = ContainerUtil.newHashMap();
    private List<TestInfo> myTestsWithoutSuites = ContainerUtil.newArrayList();

    RecentTestsData() {
    }

    public void addTest(String url, TestStateInfo.Magnitude magnitude, Date runDate) {
        if (TestLocator.isSuite(url)) {
            this.mySuites.put(url, new SuiteInfo(url, magnitude, runDate));
            return;
        }
        TestInfo testInfo = new TestInfo(url, magnitude, runDate);
        SuiteInfo suite = this.getSuite(url);
        if (suite != null) {
            suite.addTest(testInfo);
            return;
        }
        this.myTestsWithoutSuites.add(testInfo);
    }

    @Nullable
    private SuiteInfo getSuite(String url) {
        String testName = VirtualFileManager.extractPath((String)url);
        for (SuiteInfo info : this.mySuites.values()) {
            String suiteName = info.getSuiteName();
            if (!testName.startsWith(suiteName)) continue;
            return info;
        }
        return null;
    }

    public List<String> getSortedTestsList() {
        this.distributeUnmatchedTests();
        ArrayList result = ContainerUtil.newArrayList();
        this.fillWithTests(result, TestStateInfo.Magnitude.ERROR_INDEX, TestStateInfo.Magnitude.FAILED_INDEX);
        this.fillWithTests(result, TestStateInfo.Magnitude.COMPLETE_INDEX, TestStateInfo.Magnitude.PASSED_INDEX, TestStateInfo.Magnitude.IGNORED_INDEX);
        return result;
    }

    private void fillWithTests(List<String> result, TestStateInfo.Magnitude ... magnitudes) {
        ArrayList suites = ContainerUtil.newArrayList(this.mySuites.values());
        List<SuiteInfo> failedSuites = TestInfo.select(suites, magnitudes);
        List<TestInfo> failedTests = TestInfo.select(this.myTestsWithoutSuites, magnitudes);
        RecentTestsData.sortByPath(failedSuites);
        RecentTestsData.sortByPath(failedTests);
        RecentTestsData.sortSuitesByRecent(failedSuites);
        RecentTestsData.sortTestsByRecent(failedTests);
        RecentTestsData.fillWithSuites(result, failedSuites);
        RecentTestsData.fillWithTests(result, failedTests);
    }

    private static void sortSuitesByRecent(List<SuiteInfo> suites) {
        Collections.sort(suites, SUITE_BY_RECENT_COMPARATOR);
    }

    private static void sortTestsByRecent(List<TestInfo> tests) {
        Collections.sort(tests, TEST_BY_RECENT_COMPARATOR);
    }

    private static void sortByPath(List<? extends TestInfo> list) {
        Collections.sort(list, BY_PATH_COMPARATOR);
    }

    private static void fillWithTests(List<String> result, List<TestInfo> tests) {
        for (TestInfo info : tests) {
            result.add(info.getUrl());
        }
    }

    private static void fillWithSuites(List<String> result, List<SuiteInfo> suites) {
        for (SuiteInfo suite : suites) {
            result.addAll(RecentTestsData.suiteToTestList(suite));
        }
    }

    private static List<String> suiteToTestList(SuiteInfo suite) {
        ArrayList result = ContainerUtil.newArrayList();
        if (suite.canTrustSuiteMagnitude() && suite.isPassed()) {
            result.add(suite.getUrl());
            return result;
        }
        List<TestInfo> failedTests = suite.getFailedTests();
        RecentTestsData.sortTestsByRecent(failedTests);
        if (failedTests.size() == suite.getTotalTestsCount()) {
            result.add(suite.getUrl());
        } else if (failedTests.size() < 3) {
            result.addAll(ContainerUtil.map(failedTests, (Function)new Function<TestInfo, String>(){

                public String fun(TestInfo testInfo) {
                    return testInfo.getUrl();
                }
            }));
            result.add(suite.getUrl());
        } else {
            result.add(suite.getUrl());
            result.addAll(ContainerUtil.map(failedTests, (Function)new Function<TestInfo, String>(){

                public String fun(TestInfo testInfo) {
                    return testInfo.getUrl();
                }
            }));
        }
        return result;
    }

    private void distributeUnmatchedTests() {
        List noSuites = ContainerUtil.newSmartList();
        for (TestInfo test : this.myTestsWithoutSuites) {
            String url = test.getUrl();
            SuiteInfo suite = this.getSuite(url);
            if (suite != null) {
                suite.addTest(test);
                continue;
            }
            noSuites.add(test);
        }
        this.myTestsWithoutSuites = noSuites;
    }
}

