/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.VcsUserImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogUserFilterImpl
implements VcsLogUserFilter {
    @NotNull
    public static final String ME = "me";
    @NotNull
    private final Collection<String> myUsers;
    @NotNull
    private final Map<VirtualFile, VcsUser> myData;
    @NotNull
    private final Collection<String> myAllUserNames;

    public VcsLogUserFilterImpl(@NotNull Collection<String> users, @NotNull Map<VirtualFile, VcsUser> meData, @NotNull Set<VcsUser> allUsers) {
        if (users == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "users", "com/intellij/vcs/log/ui/filter/VcsLogUserFilterImpl", "<init>"));
        }
        if (meData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meData", "com/intellij/vcs/log/ui/filter/VcsLogUserFilterImpl", "<init>"));
        }
        if (allUsers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allUsers", "com/intellij/vcs/log/ui/filter/VcsLogUserFilterImpl", "<init>"));
        }
        this.myUsers = users;
        this.myData = meData;
        this.myAllUserNames = ContainerUtil.mapNotNull(allUsers, (Function)new Function<VcsUser, String>(){

            public String fun(VcsUser vcsUser) {
                String name = vcsUser.getName();
                if (!name.isEmpty()) {
                    return name.toLowerCase();
                }
                String email = vcsUser.getEmail();
                int at = email.indexOf(64);
                if (at > 0) {
                    return email.substring(0, at).toLowerCase();
                }
                return null;
            }
        });
    }

    @NotNull
    public Collection<String> getUserNames(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/filter/VcsLogUserFilterImpl", "getUserNames"));
        }
        HashSet result = ContainerUtil.newHashSet();
        for (String user : this.myUsers) {
            if (ME.equals(user)) {
                VcsUser vcsUser = this.myData.get(root);
                if (vcsUser == null) continue;
                result.addAll(this.getVariants(vcsUser.getName()));
                continue;
            }
            result.addAll(this.getVariants(user));
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogUserFilterImpl", "getUserNames"));
        }
        return hashSet;
    }

    @NotNull
    public Collection<String> getUserNamesForPresentation() {
        Collection<String> collection = this.myUsers;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogUserFilterImpl", "getUserNamesForPresentation"));
        }
        return collection;
    }

    public boolean matches(final @NotNull VcsCommitMetadata commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/ui/filter/VcsLogUserFilterImpl", "matches"));
        }
        return ContainerUtil.exists(this.getUserNames(commit.getRoot()), (Condition)new Condition<String>(){

            public boolean value(String user) {
                String lowerUser = user.toLowerCase();
                return commit.getAuthor().getName().toLowerCase().equals(lowerUser) || commit.getAuthor().getEmail().toLowerCase().startsWith(lowerUser + "@");
            }
        });
    }

    @NotNull
    public Set<String> getVariants(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/ui/filter/VcsLogUserFilterImpl", "getVariants"));
        }
        HashSet result = ContainerUtil.newHashSet((Object[])new String[]{name});
        Pair<String, String> firstAndLastName = VcsUserImpl.getFirstAndLastName(name);
        if (firstAndLastName != null) {
            result.addAll(ContainerUtil.filter(Arrays.asList((String)firstAndLastName.first + " " + (String)firstAndLastName.second, (String)firstAndLastName.first + "." + (String)firstAndLastName.second, (String)firstAndLastName.first + (String)firstAndLastName.second), (Condition)new Condition<String>(){

                public boolean value(String s) {
                    return VcsLogUserFilterImpl.this.myAllUserNames.contains(s.toLowerCase());
                }
            }));
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogUserFilterImpl", "getVariants"));
        }
        return hashSet;
    }
}

