/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.ManageRepoDialog;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.intellij.webcore.packaging.RepoPackage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManagePackagesDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(ManagePackagesDialog.class);
    @NotNull
    private final Project myProject;
    private final PackageManagementService myController;
    private JPanel myFilter;
    private JPanel myMainPanel;
    private JEditorPane myDescriptionTextArea;
    private JBList myPackages;
    private JButton myInstallButton;
    private JCheckBox myOptionsCheckBox;
    private JTextField myOptionsField;
    private JCheckBox myInstallToUser;
    private JComboBox myVersionComboBox;
    private JCheckBox myVersionCheckBox;
    private JButton myManageButton;
    private final PackagesNotificationPanel myNotificationArea;
    private JSplitPane mySplitPane;
    private JPanel myNotificationsAreaPlaceholder;
    private PackagesModel myPackagesModel;
    private String mySelectedPackageName;
    private final Set<String> myInstalledPackages;
    @Nullable
    private final PackageManagementService.Listener myPackageListener;
    private Set<String> myCurrentlyInstalling;
    protected final ListSpeedSearch myListSpeedSearch;

    public ManagePackagesDialog(@NotNull Project project2, PackageManagementService packageManagementService, @Nullable PackageManagementService.Listener packageListener) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/packaging/ManagePackagesDialog", "<init>"));
        }
        super(project2, true);
        this.$$$setupUI$$$();
        this.myCurrentlyInstalling = new HashSet<String>();
        this.myProject = project2;
        this.myController = packageManagementService;
        this.myPackageListener = packageListener;
        this.init();
        this.setTitle("Available Packages");
        this.myPackages = new JBList();
        this.myNotificationArea = new PackagesNotificationPanel();
        this.myNotificationsAreaPlaceholder.add((Component)this.myNotificationArea.getComponent(), "Center");
        AnActionButton reloadButton = new AnActionButton("Reload List of Packages", AllIcons.Actions.Refresh){

            public void actionPerformed(AnActionEvent e) {
                ManagePackagesDialog.this.myPackages.setPaintBusy(true);
                final Application application = ApplicationManager.getApplication();
                application.executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ManagePackagesDialog.this.myController.reloadAllPackages();
                            ManagePackagesDialog.this.initModel();
                            ManagePackagesDialog.this.myPackages.setPaintBusy(false);
                        }
                        catch (IOException e) {
                            application.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Messages.showErrorDialog((Component)ManagePackagesDialog.this.myMainPanel, (String)("Error updating package list: " + e.getMessage()), (String)"Reload List of Packages");
                                    ManagePackagesDialog.this.myPackages.setPaintBusy(false);
                                }
                            }, ModalityState.any());
                        }
                    }
                });
            }
        };
        this.myListSpeedSearch = new ListSpeedSearch((JList)this.myPackages, new Function<Object, String>(){

            public String fun(Object o) {
                if (o instanceof RepoPackage) {
                    return ((RepoPackage)o).getName();
                }
                return "";
            }
        });
        JPanel packagesPanel = ToolbarDecorator.createDecorator((JList)this.myPackages).disableAddAction().disableUpDownActions().disableRemoveAction().addExtraAction(reloadButton).createPanel();
        packagesPanel.setPreferredSize(new Dimension(JBUI.scale((int)400), -1));
        packagesPanel.setMinimumSize(new Dimension(JBUI.scale((int)100), -1));
        this.myPackages.setFixedCellWidth(0);
        this.myPackages.setFixedCellHeight(JBUI.scale((int)22));
        this.myPackages.setSelectionMode(0);
        this.mySplitPane.setLeftComponent(packagesPanel);
        this.myPackages.addListSelectionListener((ListSelectionListener)new MyPackageSelectionListener());
        this.myInstallToUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ManagePackagesDialog.this.myController.installToUserChanged(ManagePackagesDialog.this.myInstallToUser.isSelected());
            }
        });
        this.myOptionsCheckBox.setEnabled(false);
        this.myVersionCheckBox.setEnabled(false);
        this.myVersionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ManagePackagesDialog.this.myVersionComboBox.setEnabled(ManagePackagesDialog.this.myVersionCheckBox.isSelected());
            }
        });
        UiNotifyConnector.doWhenFirstShown((JComponent)this.myPackages, (Runnable)new Runnable(){

            @Override
            public void run() {
                ManagePackagesDialog.this.initModel();
            }
        });
        this.myOptionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ManagePackagesDialog.this.myOptionsField.setEnabled(ManagePackagesDialog.this.myOptionsCheckBox.isSelected());
            }
        });
        this.myInstallButton.setEnabled(false);
        this.myDescriptionTextArea.addHyperlinkListener(new PluginManagerMain.MyHyperlinkListener());
        this.addInstallAction();
        this.myInstalledPackages = new HashSet<String>();
        this.updateInstalledPackages();
        this.addManageAction();
        this.myPackages.setCellRenderer((ListCellRenderer)new MyTableRenderer());
        if (this.myController.canInstallToUser()) {
            this.myInstallToUser.setVisible(true);
            this.myInstallToUser.setSelected(this.myController.isInstallToUserSelected());
            this.myInstallToUser.setText(this.myController.getInstallToUserText());
        } else {
            this.myInstallToUser.setVisible(false);
        }
        this.myMainPanel.setPreferredSize(new Dimension(JBUI.scale((int)900), JBUI.scale((int)700)));
    }

    public void selectPackage(@NotNull InstalledPackage pkg) {
        if (pkg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg", "com/intellij/webcore/packaging/ManagePackagesDialog", "selectPackage"));
        }
        this.mySelectedPackageName = pkg.getName();
        this.doSelectPackage(this.mySelectedPackageName);
    }

    private void addManageAction() {
        if (this.myController.getAllRepositories() != null) {
            this.myManageButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ManageRepoDialog dialog = new ManageRepoDialog(ManagePackagesDialog.this.myProject, ManagePackagesDialog.this.myController);
                    dialog.show();
                }
            });
        } else {
            this.myManageButton.setVisible(false);
        }
    }

    private void addInstallAction() {
        this.myInstallButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Object pyPackage = ManagePackagesDialog.this.myPackages.getSelectedValue();
                if (pyPackage instanceof RepoPackage) {
                    RepoPackage repoPackage = (RepoPackage)pyPackage;
                    String extraOptions = null;
                    if (ManagePackagesDialog.this.myOptionsCheckBox.isEnabled() && ManagePackagesDialog.this.myOptionsCheckBox.isSelected()) {
                        extraOptions = ManagePackagesDialog.this.myOptionsField.getText();
                    }
                    String version = null;
                    if (ManagePackagesDialog.this.myVersionCheckBox.isEnabled() && ManagePackagesDialog.this.myVersionCheckBox.isSelected()) {
                        version = (String)ManagePackagesDialog.this.myVersionComboBox.getSelectedItem();
                    }
                    PackageManagementService.Listener listener2 = new PackageManagementService.Listener(){

                        @Override
                        public void operationStarted(final String packageName) {
                            if (!ApplicationManager.getApplication().isDispatchThread()) {
                                ApplicationManager.getApplication().invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ManagePackagesDialog.this.handleInstallationStarted(packageName);
                                    }
                                }, ModalityState.stateForComponent((Component)ManagePackagesDialog.this.myMainPanel));
                            } else {
                                ManagePackagesDialog.this.handleInstallationStarted(packageName);
                            }
                        }

                        @Override
                        public void operationFinished(final String packageName, final @Nullable PackageManagementService.ErrorDescription errorDescription) {
                            if (!ApplicationManager.getApplication().isDispatchThread()) {
                                ApplicationManager.getApplication().invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ManagePackagesDialog.this.handleInstallationFinished(packageName, errorDescription);
                                    }
                                }, ModalityState.stateForComponent((Component)ManagePackagesDialog.this.myMainPanel));
                            } else {
                                ManagePackagesDialog.this.handleInstallationFinished(packageName, errorDescription);
                            }
                        }
                    };
                    ManagePackagesDialog.this.myController.installPackage(repoPackage, version, false, extraOptions, listener2, ManagePackagesDialog.this.myInstallToUser.isSelected());
                    ManagePackagesDialog.this.myInstallButton.setEnabled(false);
                }
            }
        });
    }

    private void handleInstallationStarted(String packageName) {
        this.setDownloadStatus(true);
        this.myCurrentlyInstalling.add(packageName);
        if (this.myPackageListener != null) {
            this.myPackageListener.operationStarted(packageName);
        }
        this.myPackages.repaint();
    }

    private void handleInstallationFinished(String packageName, PackageManagementService.ErrorDescription errorDescription) {
        if (this.myPackageListener != null) {
            this.myPackageListener.operationFinished(packageName, errorDescription);
        }
        this.setDownloadStatus(false);
        this.myNotificationArea.showResult(packageName, errorDescription);
        this.updateInstalledPackages();
        this.myCurrentlyInstalling.remove(packageName);
        this.myPackages.repaint();
    }

    private void updateInstalledPackages() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    final Collection<InstalledPackage> installedPackages = ManagePackagesDialog.this.myController.getInstalledPackages();
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ManagePackagesDialog.this.myInstalledPackages.clear();
                            for (InstalledPackage pkg : installedPackages) {
                                ManagePackagesDialog.this.myInstalledPackages.add(pkg.getName());
                            }
                        }
                    });
                }
                catch (IOException e) {
                    LOG.info("Error updating list of installed packages:" + e);
                }
            }
        });
    }

    public void initModel() {
        this.setDownloadStatus(true);
        final Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ManagePackagesDialog.this.myPackagesModel = new PackagesModel(ManagePackagesDialog.this.myController.getAllPackages());
                    application.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ManagePackagesDialog.this.myPackages.setModel((ListModel)((Object)ManagePackagesDialog.this.myPackagesModel));
                            ((MyPackageFilter)((Object)ManagePackagesDialog.this.myFilter)).filter();
                            ManagePackagesDialog.this.doSelectPackage(ManagePackagesDialog.this.mySelectedPackageName);
                            ManagePackagesDialog.this.setDownloadStatus(false);
                        }
                    }, ModalityState.any());
                }
                catch (IOException e) {
                    application.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (ManagePackagesDialog.this.myMainPanel.isShowing()) {
                                Messages.showErrorDialog((Component)ManagePackagesDialog.this.myMainPanel, (String)("Error loading package list:" + e.getMessage()), (String)"Packages");
                            }
                            ManagePackagesDialog.this.setDownloadStatus(false);
                        }
                    }, ModalityState.any());
                }
            }
        });
    }

    private void doSelectPackage(@Nullable String packageName) {
        PackagesModel packagesModel = (PackagesModel)((Object)ObjectUtils.tryCast((Object)this.myPackages.getModel(), PackagesModel.class));
        if (packageName == null || packagesModel == null) {
            return;
        }
        for (int i = 0; i < packagesModel.getSize(); ++i) {
            RepoPackage repoPackage = packagesModel.getElementAt(i);
            if (!packageName.equals(repoPackage.getName())) continue;
            this.myPackages.setSelectedIndex(i);
            this.myPackages.ensureIndexIsVisible(i);
            break;
        }
    }

    protected void setDownloadStatus(boolean status) {
        this.myPackages.setPaintBusy(status);
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private void createUIComponents() {
        this.myFilter = new MyPackageFilter();
    }

    public void setOptionsText(@NotNull String optionsText) {
        if (optionsText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsText", "com/intellij/webcore/packaging/ManagePackagesDialog", "setOptionsText"));
        }
        this.myOptionsField.setText(optionsText);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myFilter;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/packaging/ManagePackagesDialog", "createActions"));
        }
        return actionArray;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JButton jButton;
        JButton jButton2;
        JComboBox jComboBox;
        JTextField jTextField;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JEditorPane jEditorPane;
        JSplitPane jSplitPane;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = this.myFilter;
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 2, 0, null, new Dimension(-1, 30), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.mySplitPane = jSplitPane = new JSplitPane();
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setOneTouchExpandable(false);
        jPanel4.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndentWithoutInsets");
        jSplitPane.setRightComponent(jPanel5);
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithoutIndentWithoutInsets.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/IdeBundle").getString("editbox.plugin.description"), (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setVerticalScrollBarPolicy(22);
        jPanel5.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 5, 0, 3, 3, 3, null, new Dimension(300, -1), null));
        this.myDescriptionTextArea = jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.setMaximumSize(new Dimension(-1, -1));
        jEditorPane.setContentType("text/html");
        jBScrollPane.setViewportView(jEditorPane);
        this.myVersionCheckBox = jCheckBox3 = new JCheckBox();
        ((Component)jCheckBox3).setEnabled(true);
        jCheckBox3.setText("Specify version");
        jCheckBox3.setSelected(false);
        jPanel5.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOptionsCheckBox = jCheckBox2 = new JCheckBox();
        ((Component)jCheckBox2).setEnabled(true);
        jCheckBox2.setText("Options");
        jCheckBox2.setSelected(false);
        jPanel5.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOptionsField = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jPanel5.add((Component)jTextField, new GridConstraints(2, 1, 1, 4, 8, 1, 2, 0, null, new Dimension(150, -1), null));
        this.myVersionComboBox = jComboBox = new JComboBox();
        ((Component)jComboBox).setEnabled(false);
        jPanel5.add(jComboBox, new GridConstraints(1, 1, 1, 4, 8, 1, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myInstallButton = jButton2 = new JButton();
        jButton2.setText("Install Package");
        jButton2.setMnemonic('I');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myManageButton = jButton = new JButton();
        jButton.setText("Manage Repositories");
        jButton.setMnemonic('M');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myInstallToUser = jCheckBox = new JCheckBox();
        ((Component)jCheckBox).setEnabled(true);
        jCheckBox.setText("");
        jCheckBox.setSelected(false);
        jPanel7.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNotificationsAreaPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class MyTableRenderer
    extends DefaultListCellRenderer {
        private JLabel myNameLabel = new JLabel();
        private JLabel myRepositoryLabel = new JLabel();
        private JPanel myPanel = new JPanel(new BorderLayout());

        private MyTableRenderer() {
            this.myPanel.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 1));
            this.myNameLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            this.myRepositoryLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            this.myPanel.add((Component)this.myNameLabel, "West");
            this.myPanel.add((Component)this.myRepositoryLabel, "East");
            this.myNameLabel.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof RepoPackage) {
                RepoPackage repoPackage = (RepoPackage)value;
                String name = repoPackage.getName();
                if (ManagePackagesDialog.this.myCurrentlyInstalling.contains(name)) {
                    String colorCode = UIUtil.isUnderDarcula() ? "589df6" : "0000FF";
                    name = "<html><body>" + repoPackage.getName() + " <font color=\"#" + colorCode + "\">(installing)</font></body></html>";
                }
                this.myNameLabel.setText(name);
                this.myRepositoryLabel.setText(repoPackage.getRepoUrl());
                Component orig = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Color fg = orig.getForeground();
                this.myNameLabel.setForeground(ManagePackagesDialog.this.myInstalledPackages.contains(name) ? PlatformColors.BLUE : fg);
            }
            this.myRepositoryLabel.setForeground((Color)JBColor.GRAY);
            Color bg = isSelected ? UIUtil.getListSelectionBackground() : (index % 2 == 1 ? UIUtil.getListBackground() : UIUtil.getDecoratedRowColor());
            this.myPanel.setBackground(bg);
            this.myNameLabel.setBackground(bg);
            this.myRepositoryLabel.setBackground(bg);
            return this.myPanel;
        }
    }

    private class MyPackageSelectionListener
    implements ListSelectionListener {
        private MyPackageSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            ManagePackagesDialog.this.myOptionsCheckBox.setEnabled(ManagePackagesDialog.this.myPackages.getSelectedIndex() >= 0);
            ManagePackagesDialog.this.myVersionCheckBox.setEnabled(ManagePackagesDialog.this.myPackages.getSelectedIndex() >= 0);
            ManagePackagesDialog.this.myOptionsCheckBox.setSelected(false);
            ManagePackagesDialog.this.myVersionCheckBox.setSelected(false);
            ManagePackagesDialog.this.myVersionComboBox.setEnabled(false);
            ManagePackagesDialog.this.myOptionsField.setEnabled(false);
            ManagePackagesDialog.this.myDescriptionTextArea.setText("<html><body style='text-align: center;padding-top:20px;'>Loading...</body></html>");
            final Object pyPackage = ManagePackagesDialog.this.myPackages.getSelectedValue();
            if (pyPackage instanceof RepoPackage) {
                String packageName = ((RepoPackage)pyPackage).getName();
                ManagePackagesDialog.this.mySelectedPackageName = packageName;
                ManagePackagesDialog.this.myVersionComboBox.removeAllItems();
                if (ManagePackagesDialog.this.myVersionCheckBox.isEnabled()) {
                    ManagePackagesDialog.this.myController.fetchPackageVersions(packageName, new CatchingConsumer<List<String>, Exception>(){

                        public void consume(final List<String> releases) {
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (ManagePackagesDialog.this.myPackages.getSelectedValue() == pyPackage) {
                                        ManagePackagesDialog.this.myVersionComboBox.removeAllItems();
                                        for (String release : releases) {
                                            ManagePackagesDialog.this.myVersionComboBox.addItem(release);
                                        }
                                    }
                                }
                            }, ModalityState.any());
                        }

                        public void consume(Exception e) {
                            LOG.info("Error retrieving releases", (Throwable)e);
                        }
                    });
                }
                ManagePackagesDialog.this.myInstallButton.setEnabled(!ManagePackagesDialog.this.myCurrentlyInstalling.contains(packageName));
                ManagePackagesDialog.this.myController.fetchPackageDetails(packageName, new CatchingConsumer<String, Exception>(){

                    public void consume(final String details) {
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (ManagePackagesDialog.this.myPackages.getSelectedValue() == pyPackage) {
                                    ManagePackagesDialog.this.myDescriptionTextArea.setText(details);
                                    ManagePackagesDialog.this.myDescriptionTextArea.setCaretPosition(0);
                                }
                            }
                        });
                    }

                    public void consume(Exception exception) {
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ManagePackagesDialog.this.myDescriptionTextArea.setText("No information available");
                            }
                        });
                        LOG.info("Error retrieving package details", (Throwable)exception);
                    }
                });
            } else {
                ManagePackagesDialog.this.myInstallButton.setEnabled(false);
                ManagePackagesDialog.this.myDescriptionTextArea.setText("");
            }
        }
    }

    private class PackagesModel
    extends CollectionListModel<RepoPackage> {
        protected final List<RepoPackage> myFilteredOut;
        protected List<RepoPackage> myView;

        public PackagesModel(List<RepoPackage> packages) {
            super(packages);
            this.myFilteredOut = new ArrayList<RepoPackage>();
            this.myView = new ArrayList<RepoPackage>();
            this.myView = packages;
        }

        public void add(String urlResource, String element) {
            super.add((Object)new RepoPackage(element, urlResource));
        }

        protected void filter(String filter) {
            ArrayList<RepoPackage> toProcess = this.toProcess();
            toProcess.addAll(this.myFilteredOut);
            this.myFilteredOut.clear();
            ArrayList<RepoPackage> filtered = new ArrayList<RepoPackage>();
            RepoPackage toSelect = null;
            for (RepoPackage repoPackage : toProcess) {
                String packageName = repoPackage.getName();
                if (StringUtil.containsIgnoreCase((String)packageName, (String)filter)) {
                    filtered.add(repoPackage);
                } else {
                    this.myFilteredOut.add(repoPackage);
                }
                if (!StringUtil.equalsIgnoreCase((CharSequence)packageName, (CharSequence)filter)) continue;
                toSelect = repoPackage;
            }
            this.filter(filtered, toSelect);
        }

        public void filter(List<RepoPackage> filtered, @Nullable RepoPackage toSelect) {
            this.myView.clear();
            ManagePackagesDialog.this.myPackages.clearSelection();
            for (RepoPackage repoPackage : filtered) {
                this.myView.add(repoPackage);
            }
            if (toSelect != null) {
                ManagePackagesDialog.this.myPackages.setSelectedValue((Object)toSelect, true);
            }
            Collections.sort(this.myView);
            this.fireContentsChanged((Object)this, 0, this.myView.size());
        }

        public RepoPackage getElementAt(int index) {
            return this.myView.get(index);
        }

        protected ArrayList<RepoPackage> toProcess() {
            return new ArrayList<RepoPackage>(this.myView);
        }

        public int getSize() {
            return this.myView.size();
        }
    }

    private class MyPackageFilter
    extends FilterComponent {
        public MyPackageFilter() {
            super("PACKAGE_FILTER", 5);
            this.getTextEditor().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        e.consume();
                        MyPackageFilter.this.filter();
                        ManagePackagesDialog.this.myPackages.requestFocus();
                    } else if (e.getKeyCode() == 27) {
                        MyPackageFilter.this.onEscape(e);
                    }
                }
            });
        }

        public void filter() {
            if (ManagePackagesDialog.this.myPackagesModel != null) {
                ManagePackagesDialog.this.myPackagesModel.filter(this.getFilter());
            }
        }
    }
}

