/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.Processor;
import com.intellij.xml.util.HtmlUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlLinkUtil {
    @NonNls
    public static final String LINK = "link";

    public static void processLinks(@NotNull XmlFile xhtmlFile, @NotNull Processor<XmlTag> tagProcessor) {
        if (xhtmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xhtmlFile", "com/intellij/xml/util/HtmlLinkUtil", "processLinks"));
        }
        if (tagProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagProcessor", "com/intellij/xml/util/HtmlLinkUtil", "processLinks"));
        }
        XmlDocument doc = HtmlUtil.getRealXmlDocument(xhtmlFile.getDocument());
        if (doc == null) {
            return;
        }
        XmlTag rootTag = doc.getRootTag();
        if (rootTag == null) {
            return;
        }
        if (LINK.equalsIgnoreCase(rootTag.getName())) {
            tagProcessor.process((Object)rootTag);
        } else {
            HtmlLinkUtil.findLinkStylesheets(rootTag, tagProcessor);
        }
    }

    public static void findLinkStylesheets(@NotNull XmlTag tag, @NotNull Processor<XmlTag> tagProcessor) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/util/HtmlLinkUtil", "findLinkStylesheets"));
        }
        if (tagProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagProcessor", "com/intellij/xml/util/HtmlLinkUtil", "findLinkStylesheets"));
        }
        HtmlLinkUtil.processInjectedContent(tag, tagProcessor);
        for (XmlTag subTag : tag.getSubTags()) {
            HtmlLinkUtil.findLinkStylesheets(subTag, tagProcessor);
        }
        if (LINK.equalsIgnoreCase(tag.getName())) {
            tagProcessor.process((Object)tag);
        }
    }

    public static void processInjectedContent(XmlTag element, final @NotNull Processor<XmlTag> tagProcessor) {
        XmlComment[] comments;
        if (tagProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagProcessor", "com/intellij/xml/util/HtmlLinkUtil", "processInjectedContent"));
        }
        PsiLanguageInjectionHost.InjectedPsiVisitor injectedPsiVisitor = new PsiLanguageInjectionHost.InjectedPsiVisitor(){

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                XmlTag rootTag;
                XmlDocument injectedDocument;
                if (injectedPsi == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/xml/util/HtmlLinkUtil$1", "visit"));
                }
                if (places == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/xml/util/HtmlLinkUtil$1", "visit"));
                }
                if (injectedPsi instanceof XmlFile && (injectedDocument = ((XmlFile)injectedPsi).getDocument()) != null && (rootTag = injectedDocument.getRootTag()) != null) {
                    for (XmlTag element = rootTag; element != null; element = element.getNextSibling()) {
                        if (!(element instanceof XmlTag)) continue;
                        XmlTag tag = element;
                        String tagName = tag.getLocalName();
                        if (element instanceof HtmlTag || tag.getNamespacePrefix().length() > 0) {
                            tagName = tagName.toLowerCase();
                        }
                        if (!HtmlLinkUtil.LINK.equalsIgnoreCase(tagName)) continue;
                        tagProcessor.process((Object)element);
                    }
                }
            }
        };
        XmlText[] texts = (XmlText[])PsiTreeUtil.getChildrenOfType((PsiElement)element, XmlText.class);
        if (texts != null && texts.length > 0) {
            for (XmlText text : texts) {
                for (PsiElement _element : text.getChildren()) {
                    if (!(_element instanceof PsiLanguageInjectionHost)) continue;
                    InjectedLanguageUtil.enumerate(_element, injectedPsiVisitor);
                }
            }
        }
        if ((comments = (XmlComment[])PsiTreeUtil.getChildrenOfType((PsiElement)element, XmlComment.class)) != null && comments.length > 0) {
            for (XmlComment comment : comments) {
                if (!(comment instanceof PsiLanguageInjectionHost)) continue;
                InjectedLanguageUtil.enumerate((PsiElement)comment, injectedPsiVisitor);
            }
        }
    }
}

