/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspectionBase;
import org.jetbrains.annotations.NotNull;

public class BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspection
extends BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspectionBase {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos.length != 1) {
            return null;
        }
        Object name = infos[0];
        if (!(name instanceof String)) {
            return null;
        }
        return new MakePublicStaticVoidFix((String)name);
    }

    private static class MakePublicStaticVoidFix
    extends InspectionGadgetsFix {
        private final String myName;

        public MakePublicStaticVoidFix(String name) {
            this.myName = name;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class);
            if (method != null) {
                PsiModifierList modifierList = method.getModifierList();
                if (!modifierList.hasModifierProperty("public")) {
                    modifierList.setModifierProperty("public", true);
                }
                if (!modifierList.hasModifierProperty("static")) {
                    modifierList.setModifierProperty("static", true);
                }
                if (!PsiType.VOID.equals((Object)method.getReturnType())) {
                    ChangeSignatureProcessor csp = new ChangeSignatureProcessor(project2, method, false, "public", method.getName(), (PsiType)PsiType.VOID, new ParameterInfoImpl[0]);
                    csp.run();
                }
            }
        }

        @NotNull
        public String getFamilyName() {
            if ("Fix modifiers" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspection$MakePublicStaticVoidFix", "getFamilyName"));
            }
            return "Fix modifiers";
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspection$MakePublicStaticVoidFix", "getName"));
            }
            return string;
        }
    }
}

