/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryTemporaryOnConversionFromStringInspection
extends BaseInspection {
    @NonNls
    private static final Map<String, String> s_conversionMap = new HashMap<String, String>(7);

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.temporary.on.conversion.from.string.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionFromStringInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String replacementString = UnnecessaryTemporaryOnConversionFromStringInspection.calculateReplacementExpression((PsiMethodCallExpression)infos[0]);
        String string = InspectionGadgetsBundle.message("unnecessary.temporary.on.conversion.from.string.problem.descriptor", replacementString);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionFromStringInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    @NonNls
    static String calculateReplacementExpression(PsiMethodCallExpression expression) {
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
        if (!(qualifierExpression instanceof PsiNewExpression)) {
            return null;
        }
        PsiNewExpression qualifier = (PsiNewExpression)qualifierExpression;
        PsiExpressionList argumentList = qualifier.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        PsiExpression arg = argumentList.getExpressions()[0];
        PsiType type = qualifier.getType();
        if (type == null) {
            return null;
        }
        String qualifierType = type.getPresentableText();
        String canonicalType = type.getCanonicalText();
        String conversionName = s_conversionMap.get(canonicalType);
        if (TypeUtils.typeEquals("java.lang.Boolean", type)) {
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression)) {
                return qualifierType + '.' + conversionName + '(' + arg.getText() + ").booleanValue()";
            }
            return qualifierType + ".parseBoolean(" + arg.getText() + ')';
        }
        return qualifierType + '.' + conversionName + '(' + arg.getText() + ')';
    }

    @Override
    @Nullable
    public InspectionGadgetsFix buildFix(Object ... infos) {
        String replacementExpression = UnnecessaryTemporaryOnConversionFromStringInspection.calculateReplacementExpression((PsiMethodCallExpression)infos[0]);
        if (replacementExpression == null) {
            return null;
        }
        String name = InspectionGadgetsBundle.message("unnecessary.temporary.on.conversion.from.string.fix.name", replacementExpression);
        return new UnnecessaryTemporaryObjectFix(name);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryTemporaryObjectVisitor();
    }

    static {
        s_conversionMap.put("java.lang.Boolean", "valueOf");
        s_conversionMap.put("java.lang.Byte", "parseByte");
        s_conversionMap.put("java.lang.Double", "parseDouble");
        s_conversionMap.put("java.lang.Float", "parseFloat");
        s_conversionMap.put("java.lang.Integer", "parseInt");
        s_conversionMap.put("java.lang.Long", "parseLong");
        s_conversionMap.put("java.lang.Short", "parseShort");
    }

    private static class UnnecessaryTemporaryObjectVisitor
    extends BaseInspectionVisitor {
        @NonNls
        private static final Map<String, String> s_basicTypeMap = new HashMap<String, String>(7);

        private UnnecessaryTemporaryObjectVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionFromStringInspection$UnnecessaryTemporaryObjectVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            Map<String, String> basicTypeMap = s_basicTypeMap;
            if (!basicTypeMap.containsValue(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)qualifier;
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiType argumentType = arguments[0].getType();
            if (!TypeUtils.isJavaLangString(argumentType)) {
                return;
            }
            PsiType type = qualifier.getType();
            if (type == null) {
                return;
            }
            String typeText = type.getCanonicalText();
            if (!basicTypeMap.containsKey(typeText)) {
                return;
            }
            String mappingMethod = basicTypeMap.get(typeText);
            if (!mappingMethod.equals(methodName)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        static {
            s_basicTypeMap.put("java.lang.Boolean", "booleanValue");
            s_basicTypeMap.put("java.lang.Byte", "byteValue");
            s_basicTypeMap.put("java.lang.Double", "doubleValue");
            s_basicTypeMap.put("java.lang.Float", "floatValue");
            s_basicTypeMap.put("java.lang.Integer", "intValue");
            s_basicTypeMap.put("java.lang.Long", "longValue");
            s_basicTypeMap.put("java.lang.Short", "shortValue");
        }
    }

    private static class UnnecessaryTemporaryObjectFix
    extends InspectionGadgetsFix {
        private final String m_name;

        private UnnecessaryTemporaryObjectFix(String name) {
            this.m_name = name;
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionFromStringInspection$UnnecessaryTemporaryObjectFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionFromStringInspection$UnnecessaryTemporaryObjectFix", "getFamilyName"));
            }
            return "Simplify";
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiMethodCallExpression expression = (PsiMethodCallExpression)descriptor.getPsiElement();
            String newExpression = UnnecessaryTemporaryOnConversionFromStringInspection.calculateReplacementExpression(expression);
            if (newExpression == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, newExpression);
        }
    }
}

