/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathKt;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.StaticFileHandlerKt;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a \u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"chromeVersionFromUserAgent", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "canBeAccessedDirectly", "", "path", "", "checkAccess", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "channel", "Lio/netty/channel/Channel;", "request", "Lio/netty/handler/codec/http/HttpRequest;", "built-in-server"})
public final class DefaultWebServerPathHandlerKt {
    private static final Pattern chromeVersionFromUserAgent = Pattern.compile(" Chrome/([\\d.]+) ");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkAccess(PathInfo pathInfo, Channel channel, HttpRequest request) {
        block9: {
            Comparable<File> comparable;
            Comparable<File> comparable2;
            block8: {
                if (pathInfo.getIoFile() != null) break block8;
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                if (!virtualFile.isInLocalFileSystem()) break block9;
            }
            if ((comparable2 = pathInfo.getIoFile()) == null || (comparable2 = comparable2.toPath()) == null) {
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                comparable2 = comparable = Paths.get(virtualFile.getPath(), new String[0]);
            }
            if (PathKt.isDirectory((Path)comparable)) {
                Responses.sendStatus(HttpResponseStatus.NOT_FOUND, channel, request);
                return false;
            }
            Comparable<File> comparable3 = comparable;
            Intrinsics.checkExpressionValueIsNotNull((Object)comparable3, (String)"file");
            if (StaticFileHandlerKt.hasAccess((Path)comparable3)) return true;
            return false;
        }
        VirtualFile virtualFile = pathInfo.getFile();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        if (!virtualFile.is(VFileProperty.HIDDEN)) return true;
        Responses.sendStatus(HttpResponseStatus.NOT_FOUND, channel, request);
        return false;
    }

    private static final boolean canBeAccessedDirectly(String path) {
        WebServerFileHandler[] webServerFileHandlerArray = (WebServerFileHandler[])WebServerFileHandler.Companion.getEP_NAME$built_in_server().getExtensions();
        for (int i = 0; i < webServerFileHandlerArray.length; ++i) {
            WebServerFileHandler fileHandler = webServerFileHandlerArray[i];
            String[] stringArray = fileHandler.getPageFileExtensions();
            for (int j = 0; j < stringArray.length; ++j) {
                String ext = stringArray[j];
                if (!FileUtilRt.extensionEquals((String)path, (String)ext)) continue;
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ Pattern access$getChromeVersionFromUserAgent$p() {
        return chromeVersionFromUserAgent;
    }

    public static final /* synthetic */ boolean access$canBeAccessedDirectly(@NotNull String path) {
        return DefaultWebServerPathHandlerKt.canBeAccessedDirectly(path);
    }

    public static final /* synthetic */ boolean access$checkAccess(@NotNull PathInfo pathInfo, @NotNull Channel channel, @NotNull HttpRequest request) {
        return DefaultWebServerPathHandlerKt.checkAccess(pathInfo, channel, request);
    }
}

