/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Script;

public abstract class BreakpointTarget {
    public abstract <R> R accept(Visitor<R> var1);

    public abstract String toString();

    public static final class ScriptName
    extends BreakpointTarget {
        private final String name;

        public ScriptName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/debugger/BreakpointTarget$ScriptName", "<init>"));
            }
            this.name = name;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/BreakpointTarget$ScriptName", "getName"));
            }
            return string;
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public <R> R accept(@NotNull Visitor<R> visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/debugger/BreakpointTarget$ScriptName", "accept"));
            }
            return visitor.visitScriptName(this.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.name.equals(((ScriptName)o).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static final class ScriptId
    extends BreakpointTarget {
        public final Script script;

        public ScriptId(@NotNull Script script) {
            if (script == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/debugger/BreakpointTarget$ScriptId", "<init>"));
            }
            this.script = script;
        }

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visitScript(this.script);
        }

        @Override
        public String toString() {
            return this.script.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.script.equals(((ScriptId)o).script);
        }

        public int hashCode() {
            return this.script.hashCode();
        }
    }

    public static interface Visitor<R> {
        public R visitScriptName(String var1);

        public R visitScript(Script var1);

        public R visitUnknown(BreakpointTarget var1);
    }
}

