/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.ByteBufUtilEx;
import java.io.IOException;
import java.nio.CharBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.CharSequenceBackedByChars;

public final class ChannelBufferToString {
    @NotNull
    public static CharSequence readChars(@NotNull ByteBuf buffer) throws IOException {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/io/ChannelBufferToString", "readChars"));
        }
        CharSequenceBackedByChars charSequenceBackedByChars = new CharSequenceBackedByChars(ChannelBufferToString.readIntoCharBuffer(buffer, buffer.readableBytes(), null));
        if (charSequenceBackedByChars == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/ChannelBufferToString", "readChars"));
        }
        return charSequenceBackedByChars;
    }

    @NotNull
    public static CharSequence readChars(@NotNull ByteBuf buffer, int byteCount) throws IOException {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/io/ChannelBufferToString", "readChars"));
        }
        CharSequenceBackedByChars charSequenceBackedByChars = new CharSequenceBackedByChars(ChannelBufferToString.readIntoCharBuffer(buffer, byteCount, null));
        if (charSequenceBackedByChars == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/ChannelBufferToString", "readChars"));
        }
        return charSequenceBackedByChars;
    }

    @NotNull
    public static CharBuffer readIntoCharBuffer(@NotNull ByteBuf buffer, int byteCount, @Nullable CharBuffer charBuffer) throws IOException {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/io/ChannelBufferToString", "readIntoCharBuffer"));
        }
        if (charBuffer == null) {
            charBuffer = CharBuffer.allocate(byteCount);
        }
        ByteBufUtilEx.readUtf8(buffer, byteCount, charBuffer);
        CharBuffer charBuffer2 = charBuffer;
        if (charBuffer2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/ChannelBufferToString", "readIntoCharBuffer"));
        }
        return charBuffer2;
    }

    public static void writeIntAsAscii(int value, @NotNull ByteBuf buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/io/ChannelBufferToString", "writeIntAsAscii"));
        }
        ByteBufUtil.writeAscii((ByteBuf)buffer, (CharSequence)new StringBuilder().append(value));
    }
}

