/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.intellij.facet.FacetType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.indexing.FileContent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.importDependencies.ImportDependenciesUtil;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFrameworkDetector
extends FacetBasedFrameworkDetector<AndroidFacet, AndroidFacetConfiguration> {
    private static final NotificationGroup ANDROID_MODULE_IMPORTING_NOTIFICATION = NotificationGroup.balloonGroup((String)"Android Module Importing");

    public AndroidFrameworkDetector() {
        super("android");
    }

    public List<? extends DetectedFrameworkDescription> detect(@NotNull Collection<VirtualFile> newFiles, @NotNull FrameworkDetectionContext context) {
        if (newFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFiles", "org/jetbrains/android/facet/AndroidFrameworkDetector", "detect"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/facet/AndroidFrameworkDetector", "detect"));
        }
        Project project = context.getProject();
        if (project != null && Projects.requiresAndroidModel(project)) {
            return Collections.emptyList();
        }
        return super.detect(newFiles, context);
    }

    public void setupFacet(final @NotNull AndroidFacet facet, final ModifiableRootModel model) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidFrameworkDetector", "setupFacet"));
        }
        Module module = facet.getModule();
        final Project project = module.getProject();
        VirtualFile[] contentRoots = model.getContentRoots();
        if (contentRoots.length == 1) {
            ((AndroidFacetConfiguration)facet.getConfiguration()).init(module, contentRoots[0]);
        }
        ImportDependenciesUtil.importDependencies(module, true);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                DumbService.getInstance((Project)project).runWhenSmart(new Runnable(){

                    @Override
                    public void run() {
                        AndroidFrameworkDetector.doImportSdkAndFacetConfiguration(facet, model);
                        ApplicationManager.getApplication().saveAll();
                    }
                });
            }
        });
    }

    public static void doImportSdkAndFacetConfiguration(@NotNull AndroidFacet facet, @Nullable ModifiableRootModel model) {
        Manifest manifest;
        Pair<String, VirtualFile> androidLibraryProp;
        Pair<String, VirtualFile> dexDisableMergerProp;
        Pair<String, VirtualFile> manifestMergerProp;
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/AndroidFrameworkDetector", "doImportSdkAndFacetConfiguration"));
        }
        Module module = facet.getModule();
        AndroidSdkUtils.setupAndroidPlatformIfNecessary(module, true);
        if (model != null && !model.isDisposed() && model.isWritable()) {
            model.setSdk(ModuleRootManager.getInstance((Module)module).getSdk());
        }
        if ((manifestMergerProp = AndroidRootUtil.getProjectPropertyValue(module, "manifestmerger.enabled")) != null) {
            facet.getProperties().ENABLE_MANIFEST_MERGING = Boolean.parseBoolean((String)manifestMergerProp.getFirst());
        }
        if ((dexDisableMergerProp = AndroidRootUtil.getProjectPropertyValue(module, "dex.disable.merger")) != null) {
            boolean bl = facet.getProperties().ENABLE_PRE_DEXING = !Boolean.parseBoolean((String)dexDisableMergerProp.getFirst());
        }
        if ((androidLibraryProp = AndroidRootUtil.getProjectPropertyValue(module, "android.library")) != null && Boolean.parseBoolean((String)androidLibraryProp.getFirst())) {
            facet.setLibraryProject(true);
            return;
        }
        Pair<String, VirtualFile> dexForceJumboProp = AndroidRootUtil.getProjectPropertyValue(module, "dex.force.jumbo");
        if (dexForceJumboProp != null) {
            AndroidFrameworkDetector.showDexOptionNotification(module, "dex.force.jumbo");
        }
        if ((manifest = facet.getManifest()) != null && DefaultActivityLocator.getDefaultLauncherActivityName(manifest) != null) {
            AndroidUtils.addRunConfiguration(facet, null, false, null, null);
        }
    }

    @NotNull
    public static Notification showDexOptionNotification(@NotNull Module module, @NotNull String propertyName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/facet/AndroidFrameworkDetector", "showDexOptionNotification"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/android/facet/AndroidFrameworkDetector", "showDexOptionNotification"));
        }
        final Project project = module.getProject();
        Notification notification = ANDROID_MODULE_IMPORTING_NOTIFICATION.createNotification(AndroidBundle.message("android.facet.importing.title", module.getName()), "'" + propertyName + "' property is detected in " + "project.properties" + " file.<br>You may enable related option in <a href='configure'>Settings | Compiler | Android DX</a>", NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "org/jetbrains/android/facet/AndroidFrameworkDetector$2", "hyperlinkActivated"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/android/facet/AndroidFrameworkDetector$2", "hyperlinkActivated"));
                }
                notification.expire();
                ShowSettingsUtil.getInstance().showSettingsDialog(project, AndroidBundle.message("android.dex.compiler.configurable.display.name", new Object[0]));
            }
        });
        notification.notify(project);
        Notification notification2 = notification;
        if (notification2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFrameworkDetector", "showDexOptionNotification"));
        }
        return notification2;
    }

    public FacetType<AndroidFacet, AndroidFacetConfiguration> getFacetType() {
        return AndroidFacet.getFacetType();
    }

    @NotNull
    public FileType getFileType() {
        LanguageFileType languageFileType = StdFileTypes.XML;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFrameworkDetector", "getFileType"));
        }
        return languageFileType;
    }

    @NotNull
    public ElementPattern<FileContent> createSuitableFilePattern() {
        FileContentPattern fileContentPattern = FileContentPattern.fileContent().withName("AndroidManifest.xml");
        if (fileContentPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFrameworkDetector", "createSuitableFilePattern"));
        }
        return fileContentPattern;
    }
}

