/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.lock;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.lock.LockClient;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdLockClient
extends BaseSvnClient
implements LockClient {
    @Override
    public void lock(@NotNull File file, boolean force, @NotNull String message, @Nullable ProgressTracker handler) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/lock/CmdLockClient", "lock"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/idea/svn/lock/CmdLockClient", "lock"));
        }
        List<String> parameters = CmdLockClient.prepareParameters(file, force);
        parameters.add("--message");
        parameters.add(message);
        CommandExecutor command = this.execute(this.myVcs, SvnTarget.fromFile((File)file), SvnCommandName.lock, parameters, null);
        CmdLockClient.handleCommandCompletion(command, file, EventAction.LOCKED, EventAction.LOCK_FAILED, handler);
    }

    @Override
    public void unlock(@NotNull File file, boolean force, @Nullable ProgressTracker handler) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/lock/CmdLockClient", "unlock"));
        }
        List<String> parameters = CmdLockClient.prepareParameters(file, force);
        CommandExecutor command = this.execute(this.myVcs, SvnTarget.fromFile((File)file), SvnCommandName.unlock, parameters, null);
        CmdLockClient.handleCommandCompletion(command, file, EventAction.UNLOCKED, EventAction.UNLOCK_FAILED, handler);
    }

    private static List<String> prepareParameters(@NotNull File file, boolean force) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/lock/CmdLockClient", "prepareParameters"));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, file);
        CommandUtil.put(parameters, force, "--force");
        return parameters;
    }

    private static void handleCommandCompletion(@NotNull CommandExecutor command, @NotNull File file, @NotNull EventAction success, @NotNull EventAction failure, @Nullable ProgressTracker handler) throws VcsException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/lock/CmdLockClient", "handleCommandCompletion"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/lock/CmdLockClient", "handleCommandCompletion"));
        }
        if (success == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "success", "org/jetbrains/idea/svn/lock/CmdLockClient", "handleCommandCompletion"));
        }
        if (failure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failure", "org/jetbrains/idea/svn/lock/CmdLockClient", "handleCommandCompletion"));
        }
        SVNErrorMessage error = SvnUtil.parseWarning(command.getErrorOutput());
        try {
            CmdLockClient.invokeHandler(file, error == null ? success : failure, handler, error);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private static void invokeHandler(@NotNull File file, @NotNull EventAction action, @Nullable ProgressTracker handler, @Nullable SVNErrorMessage error) throws SVNException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/lock/CmdLockClient", "invokeHandler"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/idea/svn/lock/CmdLockClient", "invokeHandler"));
        }
        if (handler != null) {
            handler.consume(CmdLockClient.createEvent(file, action, error));
        }
    }

    private static ProgressEvent createEvent(@NotNull File file, @NotNull EventAction action, @Nullable SVNErrorMessage error) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/lock/CmdLockClient", "createEvent"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/idea/svn/lock/CmdLockClient", "createEvent"));
        }
        return new ProgressEvent(file, -1L, null, null, action, error, null);
    }
}

