/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.watch;

import java.io.IOException;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IRequestProcessor;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.ICvsFiles;
import org.netbeans.lib.cvsclient.command.IOCommandException;
import org.netbeans.lib.cvsclient.command.Watch;
import org.netbeans.lib.cvsclient.command.watch.WatchMode;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.sending.FileStateRequestsProgressHandler;
import org.netbeans.lib.cvsclient.request.Requests;

public final class WatchCommand
extends AbstractCommand {
    private WatchMode watchMode;
    private Watch watch;

    @Override
    public boolean execute(IRequestProcessor requestProcessor, IEventSender eventManager, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment, IProgressViewer progressViewer) throws CommandException, AuthenticationException {
        ICvsFiles cvsFiles;
        this.checkState();
        try {
            cvsFiles = this.scanFileSystem(clientEnvironment);
        }
        catch (IOException ex) {
            throw new IOCommandException(ex);
        }
        Requests requests = new Requests(this.getWatchMode().getCommand(), clientEnvironment);
        this.addFileRequests(cvsFiles, requests, clientEnvironment);
        if (this.getWatchMode().isWatchOptionAllowed()) {
            String[] arguments = this.getWatchNotNull().getArguments();
            for (int i = 0; i < arguments.length; ++i) {
                requests.addArgumentRequest("-a");
                requests.addArgumentRequest(arguments[i]);
            }
        }
        requests.addLocalPathDirectoryRequest();
        this.addArgumentRequests(requests);
        return requestProcessor.processRequests(requests, FileStateRequestsProgressHandler.create(progressViewer, cvsFiles));
    }

    @Override
    public void resetCvsCommand() {
        super.resetCvsCommand();
        this.setRecursive(true);
        this.setWatch(null);
    }

    @Override
    public String getCvsCommandLine() {
        StringBuffer cvsCommand = new StringBuffer("watch ");
        cvsCommand.append(this.getCVSArguments());
        this.appendFileArguments(cvsCommand);
        return cvsCommand.toString();
    }

    private WatchMode getWatchMode() {
        return this.watchMode;
    }

    public void setWatchMode(WatchMode watchMode) {
        this.watchMode = watchMode;
    }

    public Watch getWatch() {
        return this.watch;
    }

    public void setWatch(Watch watch) {
        this.watch = watch;
    }

    private Watch getWatchNotNull() {
        if (this.watch == null) {
            return Watch.ALL;
        }
        return this.watch;
    }

    private String getCVSArguments() {
        this.checkState();
        StringBuilder cvsArguments = new StringBuilder();
        cvsArguments.append(this.getWatchMode().toString());
        cvsArguments.append(' ');
        if (!this.isRecursive()) {
            cvsArguments.append("-l ");
        }
        if (this.getWatchMode().isWatchOptionAllowed()) {
            cvsArguments.append("-a ");
            cvsArguments.append(this.getWatchNotNull().toString());
        }
        return cvsArguments.toString();
    }

    private void checkState() {
        if (this.getWatchMode() == null) {
            throw new IllegalStateException("Watch mode expected!");
        }
    }
}

