/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.rename;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.hash.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.PropertyResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class RenameAliasedUsagesUtil {
    private static final String EMPTY_ALIAS = "____00_______EMPTY_ALIAS_______00____";

    private RenameAliasedUsagesUtil() {
    }

    public static Collection<PsiReference> filterAliasedRefs(Collection<PsiReference> refs, PsiElement element) {
        HashMap aliases = new HashMap();
        ArrayList<PsiReference> result = new ArrayList<PsiReference>();
        for (PsiReference ref : refs) {
            PsiElement e = ref.getElement();
            if (e == null || RenameAliasedUsagesUtil.skipReference(element, (Map<GroovyFile, String>)aliases, e)) continue;
            result.add(ref);
        }
        return result;
    }

    public static boolean skipReference(PsiElement member, Map<GroovyFile, String> aliases, PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (containingFile instanceof GroovyFile && RenameAliasedUsagesUtil.findAliasedName(aliases, (GroovyFile)element.getContainingFile(), member) != EMPTY_ALIAS) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, GrImportStatement.class, (boolean)true) == null;
        }
        return false;
    }

    private static String findAliasedName(Map<GroovyFile, String> map, GroovyFile containingFile, PsiElement elementToResolve) {
        String s = map.get(containingFile);
        if (s != null) {
            return s;
        }
        GrImportStatement[] imports = containingFile.getImportStatements();
        PsiManager manager = elementToResolve.getManager();
        for (GrImportStatement anImport : imports) {
            GroovyResolveResult[] results;
            if (!anImport.isAliasedImport()) continue;
            ResolverProcessor processor = RenameAliasedUsagesUtil.getProcessor(elementToResolve, containingFile);
            anImport.processDeclarations(processor, ResolveState.initial(), null, containingFile);
            for (GroovyResolveResult result : results = processor.getCandidates()) {
                String importedName;
                if (!manager.areElementsEquivalent(elementToResolve, result.getElement()) || (importedName = anImport.getImportedName()) == null) continue;
                map.put(containingFile, importedName);
                return importedName;
            }
        }
        map.put(containingFile, EMPTY_ALIAS);
        return EMPTY_ALIAS;
    }

    public static ResolverProcessor getProcessor(PsiElement element, GroovyPsiElement place) {
        if (element instanceof PsiMethod) {
            return new MethodResolverProcessor(null, place, false, null, null, PsiType.EMPTY_ARRAY);
        }
        if (element instanceof PsiField) {
            return new PropertyResolverProcessor(null, place);
        }
        if (element instanceof PsiClass) {
            return new ClassResolverProcessor(null, place);
        }
        throw new IllegalArgumentException("element must be method or field or class: " + element.getClass() + ", text=" + element.getText());
    }
}

