/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.NewPropertyAction;
import com.intellij.lang.properties.editor.PropertiesAnchorizer;
import com.intellij.lang.properties.editor.PropertiesGroupingStructureViewComponent;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.editor.ResourceBundlePropertiesUpdateManager;
import com.intellij.lang.properties.editor.ResourceBundleStructureViewModel;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorRenderer;
import com.intellij.lang.properties.projectView.ResourceBundleDeleteProvider;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.ui.PopupHandler;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.util.ArrayFactory;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleStructureViewComponent
extends PropertiesGroupingStructureViewComponent {
    private static final Logger LOG = Logger.getInstance(ResourceBundleStructureViewComponent.class);
    private final ResourceBundle myResourceBundle;

    public ResourceBundleStructureViewComponent(ResourceBundle resourceBundle, ResourceBundleEditor editor, PropertiesAnchorizer anchorizer) {
        super(resourceBundle.getProject(), (FileEditor)editor, new ResourceBundleStructureViewModel(resourceBundle, anchorizer));
        this.myResourceBundle = resourceBundle;
        this.tunePopupActionGroup();
        this.getTree().setCellRenderer((TreeCellRenderer)((Object)new ResourceBundleEditorRenderer()));
    }

    protected ActionGroup createActionGroup() {
        DefaultActionGroup result = (DefaultActionGroup)super.createActionGroup();
        result.add((AnAction)new ContextHelpAction(this.getHelpID()), Constraints.LAST);
        return result;
    }

    @Override
    protected void addGroupByActions(DefaultActionGroup result) {
        super.addGroupByActions(result);
        result.add((AnAction)new NewPropertyAction(true), Constraints.FIRST);
    }

    private void tunePopupActionGroup() {
        DefaultActionGroup propertiesPopupGroup = new DefaultActionGroup();
        propertiesPopupGroup.copyFromGroup((DefaultActionGroup)ActionManager.getInstance().getAction("StructureViewPopupMenu"));
        propertiesPopupGroup.add((AnAction)Separator.getInstance(), Constraints.FIRST);
        propertiesPopupGroup.add((AnAction)new NewPropertyAction(true), Constraints.FIRST);
        PopupHandler.installPopupHandler((JComponent)this.getTree(), (ActionGroup)propertiesPopupGroup, (String)"StructureViewPopupMenu", (ActionManager)ActionManager.getInstance());
    }

    @NotNull
    private PsiFile[] getSelectedPsiFiles() {
        for (ResourceBundleEditorViewElement element : ((ResourceBundleEditor)this.getFileEditor()).getSelectedElements()) {
            if (element.getFiles() == null) continue;
            PsiFile[] psiFileArray = element.getFiles();
            if (psiFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleStructureViewComponent", "getSelectedPsiFiles"));
            }
            return psiFileArray;
        }
        if (PsiFile.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleStructureViewComponent", "getSelectedPsiFiles"));
        }
        return PsiFile.EMPTY_ARRAY;
    }

    public Object getData(String dataId) {
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return new ResourceBundleAsVirtualFile(this.myResourceBundle);
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            return this.getFileEditor();
        }
        if (ResourceBundle.ARRAY_DATA_KEY.is(dataId)) {
            return new ResourceBundle[]{this.myResourceBundle};
        }
        if (IProperty.ARRAY_KEY.is(dataId)) {
            Collection<ResourceBundleEditorViewElement> selectedElements = ((ResourceBundleEditor)this.getFileEditor()).getSelectedElements();
            if (selectedElements.isEmpty()) {
                return null;
            }
            if (selectedElements.size() == 1) {
                return ((ResourceBundleEditorViewElement)ContainerUtil.getFirstItem(selectedElements)).getProperties();
            }
            return ContainerUtil.toArray((Collection)ContainerUtil.flatten((Iterable)ContainerUtil.mapNotNull(selectedElements, (Function)new NullableFunction<ResourceBundleEditorViewElement, List<IProperty>>(){

                @Nullable
                public List<IProperty> fun(ResourceBundleEditorViewElement element) {
                    Object[] properties = element.getProperties();
                    return properties == null ? null : ContainerUtil.newArrayList((Object[])properties);
                }
            })), (ArrayFactory)new ArrayFactory<IProperty>(){

                @NotNull
                public IProperty[] create(int count) {
                    IProperty[] iPropertyArray = new IProperty[count];
                    if (iPropertyArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleStructureViewComponent$1", "create"));
                    }
                    return iPropertyArray;
                }
            });
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
            Collections.addAll(elements, this.getSelectedPsiFiles());
            IProperty[] properties = (IProperty[])this.getData(IProperty.ARRAY_KEY.getName());
            if (properties != null) {
                for (IProperty property : properties) {
                    PsiElement element = property.getPsiElement();
                    if (!element.isValid()) continue;
                    elements.add(element);
                }
            }
            return elements.toArray(new PsiElement[elements.size()]);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            if (this.getSelectedPsiFiles().length != 0) {
                return new ResourceBundleDeleteProvider();
            }
            IProperty[] properties = (IProperty[])IProperty.ARRAY_KEY.getData((DataProvider)this);
            if (properties != null && properties.length != 0) {
                return new PropertiesDeleteProvider(((ResourceBundleEditor)this.getFileEditor()).getPropertiesInsertDeleteManager(), properties);
            }
        } else if (UsageView.USAGE_TARGETS_KEY.is(dataId)) {
            PsiElement[] chosenElements = (PsiElement[])this.getData(LangDataKeys.PSI_ELEMENT_ARRAY.getName());
            if (chosenElements != null) {
                UsageTarget[] usageTargets = new UsageTarget[chosenElements.length];
                for (int i = 0; i < chosenElements.length; ++i) {
                    usageTargets[i] = new PsiElement2UsageTargetAdapter(chosenElements[i]);
                }
                return usageTargets;
            }
        } else if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return new CopyProvider(){

                public void performCopy(@NotNull DataContext dataContext) {
                    if (dataContext == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/lang/properties/editor/ResourceBundleStructureViewComponent$3", "performCopy"));
                    }
                    PsiElement[] selectedPsiElements = (PsiElement[])ResourceBundleStructureViewComponent.this.getData(LangDataKeys.PSI_ELEMENT_ARRAY.getName());
                    if (selectedPsiElements != null) {
                        ArrayList<String> names = new ArrayList<String>(selectedPsiElements.length);
                        for (PsiElement element : selectedPsiElements) {
                            if (!(element instanceof PsiNamedElement)) continue;
                            names.add(((PsiNamedElement)element).getName());
                        }
                        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(StringUtil.join(names, (String)"\n")));
                    }
                }

                public boolean isCopyEnabled(@NotNull DataContext dataContext) {
                    if (dataContext == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/lang/properties/editor/ResourceBundleStructureViewComponent$3", "isCopyEnabled"));
                    }
                    return true;
                }

                public boolean isCopyVisible(@NotNull DataContext dataContext) {
                    if (dataContext == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/lang/properties/editor/ResourceBundleStructureViewComponent$3", "isCopyVisible"));
                    }
                    return true;
                }
            };
        }
        return super.getData(dataId);
    }

    protected boolean showScrollToFromSourceActions() {
        return false;
    }

    @NonNls
    public String getHelpID() {
        return "editing.propertyFile.bundleEditor";
    }

    private class PropertiesDeleteProvider
    implements DeleteProvider {
        private final ResourceBundlePropertiesUpdateManager myInsertDeleteManager;
        private final IProperty[] myProperties;

        private PropertiesDeleteProvider(ResourceBundlePropertiesUpdateManager insertDeleteManager, IProperty[] properties) {
            this.myInsertDeleteManager = insertDeleteManager;
            this.myProperties = properties;
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/lang/properties/editor/ResourceBundleStructureViewComponent$PropertiesDeleteProvider", "deleteElement"));
            }
            List<PropertiesFile> bundlePropertiesFiles = ResourceBundleStructureViewComponent.this.myResourceBundle.getPropertiesFiles();
            ArrayList<PsiElement> toDelete = new ArrayList<PsiElement>();
            for (IProperty property : this.myProperties) {
                String key = property.getKey();
                if (key == null) {
                    LOG.error("key must be not null " + property);
                    continue;
                }
                for (PropertiesFile propertiesFile : bundlePropertiesFiles) {
                    for (IProperty iProperty : propertiesFile.findPropertiesByKey(key)) {
                        toDelete.add(iProperty.getPsiElement());
                    }
                }
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            LOG.assertTrue(project != null);
            new SafeDeleteHandler().invoke(project, PsiUtilCore.toPsiElementArray(toDelete), dataContext);
            this.myInsertDeleteManager.reload();
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/lang/properties/editor/ResourceBundleStructureViewComponent$PropertiesDeleteProvider", "canDeleteElement"));
            }
            return true;
        }
    }
}

