/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.collections;

import com.android.tools.idea.ui.properties.AbstractObservable;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.ForwardingListIterator;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObservableList<E>
extends AbstractObservable
implements List<E> {
    @NotNull
    private List<E> myInnerList;
    private int myUpdateCount;
    private boolean myInvalidatedWhileUpdating;

    public ObservableList() {
        this.myInnerList = Lists.newArrayList();
    }

    public ObservableList(@NotNull Iterable<? extends E> otherCollection) {
        if (otherCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherCollection", "com/android/tools/idea/ui/properties/collections/ObservableList", "<init>"));
        }
        this.myInnerList = Lists.newArrayList(otherCollection);
    }

    public void beginUpdate() {
        ++this.myUpdateCount;
    }

    public void endUpdate() {
        if (this.myUpdateCount == 0) {
            throw new IllegalStateException("Can't call ObservableList.endUpdate without matching beginUpdate");
        }
        --this.myUpdateCount;
        if (this.myUpdateCount == 0 && this.myInvalidatedWhileUpdating) {
            this.myInvalidatedWhileUpdating = false;
            this.notifyInvalidated();
        }
    }

    private void notifyContentsChanged() {
        if (this.myUpdateCount > 0) {
            this.myInvalidatedWhileUpdating = true;
            return;
        }
        this.notifyInvalidated();
    }

    @Override
    public int size() {
        return this.myInnerList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myInnerList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.myInnerList.contains(o);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        ObservableIterator observableIterator = new ObservableIterator(this.myInnerList.iterator());
        if (observableIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/collections/ObservableList", "iterator"));
        }
        return observableIterator;
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] objectArray = this.myInnerList.toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/collections/ObservableList", "toArray"));
        }
        return objectArray;
    }

    @Override
    @NotNull
    public <T> T[] toArray(T[] a) {
        T[] TArray = this.myInnerList.toArray(a);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/collections/ObservableList", "toArray"));
        }
        return TArray;
    }

    @Override
    public boolean add(E e) {
        boolean added = this.myInnerList.add(e);
        if (added) {
            this.notifyContentsChanged();
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = this.myInnerList.remove(o);
        if (removed) {
            this.notifyContentsChanged();
        }
        return removed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.myInnerList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean added = this.myInnerList.addAll(c);
        if (added) {
            this.notifyContentsChanged();
        }
        return added;
    }

    public boolean setAll(@NotNull Collection<? extends E> c) {
        boolean changed;
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/idea/ui/properties/collections/ObservableList", "setAll"));
        }
        this.beginUpdate();
        boolean cleared = false;
        if (!this.myInnerList.isEmpty()) {
            this.myInnerList.clear();
            cleared = true;
        }
        boolean added = this.myInnerList.addAll(c);
        boolean bl = changed = cleared || added;
        if (changed) {
            this.notifyContentsChanged();
        }
        this.endUpdate();
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean added = this.myInnerList.addAll(index, c);
        if (added) {
            this.notifyContentsChanged();
        }
        return added;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = this.myInnerList.removeAll(c);
        if (removed) {
            this.notifyContentsChanged();
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean retained = this.myInnerList.retainAll(c);
        if (retained) {
            this.notifyContentsChanged();
        }
        return retained;
    }

    @Override
    public void clear() {
        if (this.myInnerList.isEmpty()) {
            return;
        }
        this.myInnerList.clear();
        this.notifyContentsChanged();
    }

    @Override
    @Nullable
    public E get(int index) {
        return this.myInnerList.get(index);
    }

    @Override
    @Nullable
    public E set(int index, E element) {
        E result = this.myInnerList.set(index, element);
        this.notifyContentsChanged();
        return result;
    }

    @Override
    public void add(int index, E element) {
        this.myInnerList.add(index, element);
        this.notifyContentsChanged();
    }

    @Override
    @Nullable
    public E remove(int index) {
        E result = this.myInnerList.remove(index);
        this.notifyContentsChanged();
        return result;
    }

    @Override
    public int indexOf(Object o) {
        return this.myInnerList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.myInnerList.lastIndexOf(o);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        ObservableListIterator observableListIterator = new ObservableListIterator(this.myInnerList.listIterator());
        if (observableListIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/collections/ObservableList", "listIterator"));
        }
        return observableListIterator;
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        ObservableListIterator observableListIterator = new ObservableListIterator(this.myInnerList.listIterator(index));
        if (observableListIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/collections/ObservableList", "listIterator"));
        }
        return observableListIterator;
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        List<E> list = this.myInnerList.subList(fromIndex, toIndex);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/collections/ObservableList", "subList"));
        }
        return list;
    }

    @Override
    public int hashCode() {
        return this.myInnerList.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.myInnerList.equals(o)) {
            return true;
        }
        if (o != null && o instanceof ObservableList) {
            return ((ObservableList)o).myInnerList.equals(this.myInnerList);
        }
        return false;
    }

    public String toString() {
        return this.myInnerList.toString();
    }

    private class ObservableListIterator
    extends ForwardingListIterator<E> {
        @NotNull
        private final ListIterator<E> myInner;

        public ObservableListIterator(ListIterator<E> inner) {
            if (inner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inner", "com/android/tools/idea/ui/properties/collections/ObservableList$ObservableListIterator", "<init>"));
            }
            this.myInner = inner;
        }

        protected ListIterator<E> delegate() {
            return this.myInner;
        }

        public void remove() {
            this.myInner.remove();
            ObservableList.this.notifyContentsChanged();
        }

        public void set(@NotNull E e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/ui/properties/collections/ObservableList$ObservableListIterator", "set"));
            }
            this.myInner.set(e);
            ObservableList.this.notifyContentsChanged();
        }

        public void add(@NotNull E e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/ui/properties/collections/ObservableList$ObservableListIterator", "add"));
            }
            this.myInner.add(e);
            ObservableList.this.notifyContentsChanged();
        }
    }

    private class ObservableIterator
    extends ForwardingIterator<E> {
        private final Iterator<E> myInner;

        public ObservableIterator(Iterator<E> inner) {
            if (inner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inner", "com/android/tools/idea/ui/properties/collections/ObservableList$ObservableIterator", "<init>"));
            }
            this.myInner = inner;
        }

        protected Iterator<E> delegate() {
            return this.myInner;
        }

        public void remove() {
            this.myInner.remove();
            ObservableList.this.notifyContentsChanged();
        }
    }
}

