/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.core;

import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.sf.cglib.core.ClassGenerator;
import net.sf.cglib.core.ClassNameReader;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.DefaultGeneratorStrategy;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.GeneratorStrategy;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.core.ReflectUtils;
import org.objectweb.asm.ClassReader;

public abstract class AbstractClassGenerator {
    private static final Object NAME_KEY = new Object();
    private static final ThreadLocal CURRENT = new ThreadLocal();
    private GeneratorStrategy strategy = DefaultGeneratorStrategy.INSTANCE;
    private NamingPolicy namingPolicy = DefaultNamingPolicy.INSTANCE;
    private final Source source;
    private ClassLoader classLoader;
    private String namePrefix;
    private Object key;
    private boolean useCache = true;
    private String className;
    private boolean attemptLoad;

    protected AbstractClassGenerator(Source source) {
        this.source = source;
    }

    protected final String getClassName() {
        if (this.className == null) {
            this.className = this.getClassName(this.getClassLoader());
        }
        return this.className;
    }

    private String getClassName(ClassLoader loader) {
        final Set nameCache = this.getClassNameCache(loader);
        return this.namingPolicy.getClassName(this.namePrefix, this.source.name, this.key, new Predicate(){});
    }

    private Set getClassNameCache(ClassLoader loader) {
        return (Set)((Map)this.source.cache.get(loader)).get(NAME_KEY);
    }

    public ClassLoader getClassLoader() {
        ClassLoader t = this.classLoader;
        if (t == null) {
            t = this.getDefaultClassLoader();
        }
        if (t == null) {
            t = this.getClass().getClassLoader();
        }
        if (t == null) {
            t = Thread.currentThread().getContextClassLoader();
        }
        if (t == null) {
            throw new IllegalStateException("Cannot determine classloader");
        }
        return t;
    }

    protected abstract ClassLoader getDefaultClassLoader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object create(Object key) {
        try {
            Class gen = null;
            Source source = this.source;
            synchronized (source) {
                ClassLoader loader = this.getClassLoader();
                HashMap<Object, Object> cache2 = null;
                cache2 = (HashMap<Object, Object>)this.source.cache.get(loader);
                if (cache2 == null) {
                    cache2 = new HashMap<Object, Object>();
                    cache2.put(NAME_KEY, new HashSet());
                    this.source.cache.put(loader, cache2);
                } else if (this.useCache) {
                    Reference ref = (Reference)cache2.get(key);
                    gen = (Class)SoftReference.dereference(ref);
                }
                if (gen != null) {
                    return this.firstInstance(gen);
                }
                Object save = CURRENT.get();
                CURRENT.set(this);
                try {
                    this.key = key;
                    if (this.attemptLoad) {
                        try {
                            gen = loader.loadClass(this.getClassName());
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (gen == null) {
                        byte[] b = this.strategy.generate((ClassGenerator)this);
                        String className = ClassNameReader.getClassName((ClassReader)new ClassReader(b));
                        this.getClassNameCache(loader).add(className);
                        gen = ReflectUtils.defineClass((String)className, (byte[])b, (ClassLoader)loader);
                    }
                    if (this.useCache) {
                        cache2.put(key, new WeakReference(gen));
                    }
                    Object object = this.firstInstance(gen);
                    return object;
                }
                finally {
                    CURRENT.set(save);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodeGenerationException((Throwable)e);
        }
    }

    protected abstract Object firstInstance(Class var1) throws Exception;

    protected static class Source {
        final String name;
        final Map cache = new WeakHashMap();

        public Source(String name) {
            this.name = name;
        }
    }
}

