/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import com.google.dart.compiler.backend.js.ast.JsName;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.UsageTrackerKt;
import org.jetbrains.kotlin.js.translate.utils.ManglingUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"9\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!\u0011R!\u0001C\u0003\u000b\u0005A\u0011!B\u0001\u0005\u00041\u0001\u0011$\u0001M\u0001C?IA\u0001C\u0001\u000e\u00051\u0005\u0001\u0004A\u0005\u0004\u0011\u0007i\u0011\u0001\u0007\u0002\n\u0007!\u0015Q\"\u0001\r\u0004#\u000e\t\u0001rA\u0013\n\t\u0005A\u0011\"D\u0001\u0019\u0014e!\u0001BC\u0007\u0003\u0019\u0003AR!J\u0004\t\u00165\t\u00014C\r\u0004\u0011)i\u0011\u0001G\u0003&\r\u0011\t\u0001bC\u0007\u00021\u0017)\u0012\u0001G\u0003*\u001b\u0011\t\u0005\u0002\u0003\u0003\u000e\u000f%\u0011\u0011\"\u0001\r\u0006\u0013\tI\u0011\u0001g\u0003\u0019\nE\u001b\u0011!\u0002\u0001*!\u0011\u0019\u0005\u0002\u0003\u0004\u000e\u000f%\u0011\u0011\"\u0001\r\u0006\u0013\tI\u0011\u0001g\u0003\u0019\u000eq\u0019\u0013kA\u0002\u000e\u0005\u00119\u0001rB\u0015\u000b\t\rC\u00012A\u0007\u00021\t\t6\u0001B\u0003\u0001\u001b\t!\u0001\u0002#\u0005*\u0011\u0011\t\u0005\u0002C\u0001\u000e\u00051\u0005\u0001\u0004A)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!\u0015Q\"\u0001\r\u0004#\u000e\tQ\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/js/translate/context/UsageTracker;", "", "parent", "containingDescriptor", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "scope", "Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope;", "(Lorg/jetbrains/kotlin/js/translate/context/UsageTracker;Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;Lcom/google/dart/compiler/backend/js/ast/JsFunctionScope;)V", "captured", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lcom/google/dart/compiler/backend/js/ast/JsName;", "capturedDescriptorToJsName", "", "getCapturedDescriptorToJsName", "()Ljava/util/Map;", "getContainingDescriptor", "()Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "captureIfNeed", "", "descriptor", "used", "getJsNameForCapturedDescriptor"}, moduleName="kotlin-compiler")
public final class UsageTracker {
    private final LinkedHashMap<DeclarationDescriptor, JsName> captured;
    private final UsageTracker parent;
    @NotNull
    private final MemberDescriptor containingDescriptor;
    private final JsFunctionScope scope;

    @NotNull
    public final Map<DeclarationDescriptor, JsName> getCapturedDescriptorToJsName() {
        return this.captured;
    }

    public final void used(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (UsageTrackerKt.isCaptured(this, descriptor2)) {
            return;
        }
        if (descriptor2 instanceof FunctionDescriptor && Intrinsics.areEqual(((FunctionDescriptor)descriptor2).getVisibility(), Visibilities.LOCAL)) {
            boolean value2 = !((FunctionDescriptor)descriptor2).getName().isSpecial();
            if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
                String message = "Function with special name can not be captured, descriptor: " + descriptor2;
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            this.captureIfNeed(descriptor2);
        } else if (descriptor2 instanceof VariableDescriptor && !(descriptor2 instanceof PropertyDescriptor)) {
            this.captureIfNeed(descriptor2);
        } else if (descriptor2 instanceof ReceiverParameterDescriptor) {
            this.captureIfNeed(descriptor2);
        } else if (descriptor2 instanceof TypeParameterDescriptor && ((TypeParameterDescriptor)descriptor2).isReified()) {
            this.captureIfNeed(descriptor2);
        }
    }

    private final void captureIfNeed(DeclarationDescriptor descriptor2) {
        Unit unit;
        if (descriptor2 == null || UsageTrackerKt.isCaptured(this, descriptor2) || DescriptorUtils.isAncestor(this.containingDescriptor, descriptor2, true)) {
            return;
        }
        UsageTracker usageTracker = this.parent;
        if (usageTracker != null) {
            usageTracker.captureIfNeed(descriptor2);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        MapsKt.set(this.captured, descriptor2, this.getJsNameForCapturedDescriptor(descriptor2));
    }

    private final JsName getJsNameForCapturedDescriptor(DeclarationDescriptor $receiver) {
        DeclarationDescriptor declarationDescriptor = $receiver;
        String suggestedName = declarationDescriptor instanceof ReceiverParameterDescriptor ? UsageTrackerKt.access$getNameForCapturedReceiver((ReceiverParameterDescriptor)$receiver) : (declarationDescriptor instanceof TypeParameterDescriptor ? Namer.isInstanceSuggestedName((TypeParameterDescriptor)$receiver) : ManglingUtils.getSuggestedName($receiver));
        JsName jsName = this.scope.declareFreshName(suggestedName);
        Intrinsics.checkExpressionValueIsNotNull(jsName, "scope.declareFreshName(suggestedName)");
        return jsName;
    }

    @NotNull
    public final MemberDescriptor getContainingDescriptor() {
        return this.containingDescriptor;
    }

    public UsageTracker(@Nullable UsageTracker parent2, @NotNull MemberDescriptor containingDescriptor, @NotNull JsFunctionScope scope2) {
        Intrinsics.checkParameterIsNotNull(containingDescriptor, "containingDescriptor");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        this.parent = parent2;
        this.containingDescriptor = containingDescriptor;
        this.scope = scope2;
        this.captured = MapsKt.linkedMapOf(new Pair[0]);
    }
}

