/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.renderer;

import java.util.List;
import kotlin.CharIterator;
import kotlin.CharsKt;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.name.FqNameBase;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.KeywordStringsGenerated;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"-\u0015\u0001Q!\u0001\u0005\b\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t!\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!-Q\u0012\u0003\u0005\u0001\u001b\u0005A\n!G\u0002\t\u00035\t\u00014\u0001+\u0004\u00055UA!\u0001E\u0003\u001b\ta\t\u0001'\u0001\u001a\u0007!\tQ\"\u0001\r\u0004)\u000e\u0011Qr\u0003E\u0004\u001b\u0005A\n!\u0007\u0004\t\t5!\u0011BA\u0005\u00021\u0015AJ\u0001V\u0002\u0003\u001b\u001bAY!D\u0001\u0019\u0002U\t\u0001D\u0002+\u0004\u000555\u00012B\u0007\u00021\u0003)\u0012\u0001G\u0003U\u0007\tiy\u0001B\u0001\t\u000e5\t\u0001dB\u000b\u00021\u0015!6A\u0001"}, strings={"qualifiedNameForSourceCode", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "RenderingUtilsKt", "qualifierName", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "renderFqName", "pathSegments", "", "Lorg/jetbrains/kotlin/name/Name;", "render", "Lorg/jetbrains/kotlin/name/FqNameBase;", "shouldBeEscaped", ""}, moduleName="kotlin-compiler")
public final class RenderingUtilsKt {
    @NotNull
    public static final String qualifiedNameForSourceCode(@NotNull ClassifierDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        String nameString = RenderingUtilsKt.render(descriptor2.getName());
        if (descriptor2 instanceof TypeParameterDescriptor) {
            return nameString;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "descriptor.getContainingDeclaration()");
        String qualifier2 = RenderingUtilsKt.qualifierName(declarationDescriptor);
        return qualifier2 != null && Intrinsics.areEqual(qualifier2, "") ^ true ? qualifier2 + "." + nameString : nameString;
    }

    private static final String qualifierName(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor = descriptor2;
        return declarationDescriptor instanceof ClassDescriptor ? RenderingUtilsKt.qualifiedNameForSourceCode((ClassifierDescriptor)descriptor2) : (declarationDescriptor instanceof PackageFragmentDescriptor ? RenderingUtilsKt.render(((PackageFragmentDescriptor)descriptor2).getFqName()) : (String)null);
    }

    @NotNull
    public static final String render(Name $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (RenderingUtilsKt.shouldBeEscaped($receiver)) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = $receiver.asString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "asString()");
            string = stringBuilder.append(CharsKt.plus('`', string2)).append('`').toString();
        } else {
            String string3 = $receiver.asString();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull(string3, "asString()");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldBeEscaped(Name $receiver) {
        boolean bl;
        if ($receiver.isSpecial()) {
            return false;
        }
        String string = $receiver.asString();
        if (KeywordStringsGenerated.KEYWORDS.contains(string)) return true;
        String $receiver2 = string;
        CharIterator charIterator = StringsKt.iterator($receiver2);
        do {
            if (!charIterator.hasNext()) return false;
            char element = charIterator.nextChar();
            char it = element;
            if (!Character.isLetterOrDigit(it) && it != '_') {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public static final String render(FqNameBase $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        List<Name> list = $receiver.pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list, "pathSegments()");
        return RenderingUtilsKt.renderFqName(list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String renderFqName(@NotNull List<? extends Name> pathSegments) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull(pathSegments, "pathSegments");
        StringBuilder $receiver = new StringBuilder();
        StringBuilder $receiver2 = $receiver;
        for (Name name : pathSegments) {
            if (CollectionsKt.length($receiver2) > 0) {
                $receiver2.append(".");
            }
            $receiver2.append(RenderingUtilsKt.render(name));
        }
        String string = ((StringBuilder)var1_1).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder {\n        \u2026       }\n    }.toString()");
        return string;
    }
}

