/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.callableReferences.CallableReferencesResolutionUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolver;
import org.jetbrains.kotlin.resolve.calls.ValueArgumentsToParametersMapper;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CandidateResolveMode;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.SubstitutionFilteringInternalResolveAnnotations;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatchStatus;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastManager;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FunctionPlaceholdersKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"O\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\b\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0017)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tAqA\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA1\u0002\u0007\u00013\u0005A\n!(A,CgI1\u0001C\u0001\u000e\u0003a\r\u0011b\u0001\u0005\u0003\u001b\u0005A*!C\u0002\t\u00075\t\u0001tA\u0005\u0007\u0011\u0011iA!\u0003\u0002\n\u0003a)\u0001\u0014B\u0005\u0004\u0011\u0017i\u0011\u0001\u0007\u0004R\u0007\u0005Ai!J\n\t\u00145\t\u0001DC\t\u0005\t\u0001A)\"F\u0001\u0019\u0010e1\u0001bC\u0007\u0005\u0013\tI\u0011\u0001*\u0006\u0019\u0011e\u0019\u0001rC\u0007\u000211)c\u0004B\u0001\t\u001a5\t\u0001$D\r\u0007\u00117iA!\u0003\u0002\n\u0003au\u0001DD\r\u0007\u0011=iA!\u0003\u0002\n\u0003a}\u0001DD\r\u0004\u0011Ai\u0011\u0001g\u0004\u001a\u0007!\u0005R\"\u0001\r\u00123\rA\u0019#D\u0001\u0019%\u0015RA!\u0001E\u0013\u001b\u0005A2#G\u0003\t\u00175\u0019\u0011\"\u0001C\u00021!)\u0003\u0003B\u0001\t(5\t\u0001\u0004F\t\u0005\t\u0001A)\"F\u0001\u0019\u0010e1\u0001bC\u0007\u0005\u0013\tI\u0011\u0001*\u0006\u0019\u0011\u0015\u001aC!\u0001E\u0015\u001b\u0005A\"\"\u0005\u0003\u0005\u0001!UQ#\u0001M\b#\u001d!\t\u0001C\u000b\u0016\t%\u0011\u0011\"\u0001\u0013\u00161WIb\u0001C\u0006\u000e\t%\u0011\u0011\"\u0001\u0013\u00161WIb\u0001\u0003\f\u000e\t%\u0011\u0011\"\u0001S\u000b1[I2\u0001c\u0006\u000e\u0003aaQ%\u0003\u0003\u0002\u0011]i!\u0001$\u0001\u00190e\u0019\u0001\u0002G\u0007\u00021\u001f)\u0013\u0002B\u0001\t25\u0011A\u0012\u0001\r\u001a3\rA\u0019$D\u0001\u00195\u0015r\u0002RG\u0007\u000215\tB\u0001\u0002\u0001\t\u0016U\t\u0001tB\t\u0005\t\u0003A1$F\u0001%\u0016e1\u0001bC\u0007\u0005\u0013\tI\u0011\u0001*\u0006\u0019\u0011eI\u0001rG\u0007\b\u0013\tI\u0011\u0001*\u0006\n\u0005%\tAe\u0007\r\u001dK]!\u0011\u0001#\u000f\u000e\u00051\u0005\u0001tD\r\u0004\u0011ui\u0011\u0001g\u000f\u001a\u0007!qR\"\u0001M\u00103\rAi$D\u0001\u0019 e)\u0001bC\u0007\u0004\u0013\u0005!\u0019\u0001G\u0010&@\u0011\t\u0005\u0003c\u0010\u000e\u0003ai\u0011\u0003\u0002\u0003\u0001\u0011+)\u0012\u0001g\u0004\u0016\t%\u0011\u0011\"\u0001S\u000b1!I\u0002\u0003\u0003\u0011\u000e\u001a%)\u0011\u0002B\u0005\u0003\u0013\u0005!+\u0002\u0007\u0005\n\u0005%\t\u0001$\u0004M!#\u000e\tA!\t)\u0004\u0002\u0015BA!\u0001E\"\u001b\u0005AR\"F\u0002\n\u0003\u0011\r\u0001\u0004CS \t\u0005\u0003\u0002BI\u0007\u000215\tB\u0001\u0002\u0001\t\u0016U\t\u0001tB\u000b\u0005\u0013\tI\u0011\u0001*\u0006\u0019\u0011e\u0001\u0002\u0002IG\r\u0013\u0015IA!\u0003\u0002\n\u0003\u0011V\u0001\u0004C\u0005\u0003\u0013\u0005AB\u0003'\u0011R\u0007\u0005!\u0011\u0005UB\u0001K!!\u0011\u0001#\u0012\u000e\u0003aiQcA\u0005\u0002\t\u0007A\u0002\"J\n\u0005\u0003!\u0019S\"\u0001\r\u000e#\u0011!\u0001\u0001#\u0006\u0016\u0003a=\u0011\u0003\u0002C\u0001\u0011m)\u0012\u0001*\u0006\u0016\t%\u0011\u0011\"\u0001S\u000b1!)\u0003\u0002B\u0001\tH5\t\u0001$D\u000b\u0004\u0013\u0005!\u0019\u0001\u0007\u0005&\u0011\u0011\t\u0001\u0002J\u0007\u000215)2!C\u0001\u0005\u0004aAQ5\f\u0003\u0002\u0011\u0013j\u0011\u0001\u0007\u000b\u0012\t\u0011\u0001\u0001RC\u000b\u00021\u001f)B!\u0003\u0002\n\u0003\u0011V\u0001\u0004CM\b\u0011YiA!\u0003\u0002\n\u0003\u0011V\u0001$\n)\u0004\u0002e-\u00012J\u0007\u0003\u0019\u0003Ab\u0005U\u0002\u00023\u0013Ai%D\u0001\u00195A\u001b\u0019!'\u0003\tO5\t\u0001d\u0005)\u0004\u0005e%\u0001rJ\u0007\u00021M\u00016QA\u0013\t\t\u0005A\u0001&D\u0001\u0019\u001bU\u0019\u0011\"\u0001C\u00021!)C\u0003B\u0001\tQ5\t\u0001$D\u000b\u0004\u0013\u0005!\u0019\u0001\u0007\u0005\u001a\f!ESB\u0001G\u00011\u0019\u00026\u0011AM\u0005\u0011\u001bj\u0011\u0001\u0007\u000eQ\u0007\u0005)\u0003\u0002B\u0001\tS5\t\u0001$D\u000b\u0004\u0013\u0005!\u0019\u0001\u0007\u0005&\u0011\u0011\t\u00012K\u0007\u000215)2!C\u0001\u0005\u0004aAQe\u0005\u0003\u0002\u0011)j\u0011\u0001G\u0007\u0012\t\u0011\u0001\u0001RC\u000b\u00021\u001f\tB\u0001\"\u0001\t7U\tAUC\u000b\u0005\u0013\tI\u0011\u0001*\u0006\u0019\u0011\u0015BA!\u0001E+\u001b\u0005AR\"F\u0002\n\u0003\u0011\r\u0001\u0004C\u0013\u000f\t\u0005A1&D\u0001\u0019'E!A\u0001\u0001E\u000b+\u0005Az!\u0006\u0003\n\u0005%\tAU\u0003\r\tS)!\u0011\t\u0003\u0005\u0005\u001b\u0011I!!C\u0001\u0019\u000ba%\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u00035\t\u00014A)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!\u0011Q\"\u0001M\u0003#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001bA\u0007\u00021\u000f\t6!A\u0003\u0001S\u001d!\u0011\t\u0003E\u0006\u001b\u0005Ab!U\u0002\u0002\u000b\u0001Ic\u0002B!\t\u0011\u001di\u0011\u0001g\u0004\u0016\u0007%\tA1\u0001\r\t9\u0005\n6aA\u0007\u0003\t#A\u0011\u0002"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;", "", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "genericCandidateResolver", "Lorg/jetbrains/kotlin/resolve/calls/GenericCandidateResolver;", "reflectionTypes", "Lorg/jetbrains/kotlin/builtins/ReflectionTypes;", "additionalTypeCheckers", "", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "smartCastManager", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager;", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/resolve/calls/GenericCandidateResolver;Lorg/jetbrains/kotlin/builtins/ReflectionTypes;Ljava/lang/Iterable;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager;)V", "candidateDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/context/CallCandidateResolutionContext;", "getCandidateDescriptor", "(Lorg/jetbrains/kotlin/resolve/calls/context/CallCandidateResolutionContext;)Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "checkAllValueArguments", "Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver$ValueArgumentsCheckingResult;", "D", "context", "resolveFunctionArgumentBodies", "Lorg/jetbrains/kotlin/resolve/calls/callResolverUtil/ResolveArgumentsMode;", "checkGenericBoundsInAFunctionCall", "", "jetTypeArguments", "", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "typeArguments", "Lorg/jetbrains/kotlin/types/KotlinType;", "functionDescriptor", "substitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkOuterClassMemberIsAccessible", "", "checkReceivers", "Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;", "checkValueArgumentTypes", "C", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "candidateCall", "Lorg/jetbrains/kotlin/resolve/calls/model/MutableResolvedCall;", "getDeclaringClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "candidate", "getReceiverSuper", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "performResolutionForCandidateCall", "F", "task", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ResolutionTask;", "smartCastValueArgumentTypeIfPossible", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expectedType", "actualType", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "check", "checker", "Lkotlin/Function1;", "Lkotlin/Extension;", "checkAbstractAndSuper", "checkAndReport", "checkDispatchReceiver", "checkExpectedCallableType", "checkExtensionReceiver", "checkNonExtensionCalledWithReceiver", "checkReceiver", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "receiverParameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "receiverArgument", "isExplicitReceiver", "implicitInvokeCheck", "checkReceiverTypeError", "receiverParameterDescriptor", "checkValueArguments", "checkVisibility", "mapArguments", "processTypeArguments", "shouldContinue", "ValueArgumentsCheckingResult"}, moduleName="kotlin-compiler")
public final class CandidateResolver {
    private final ArgumentTypeResolver argumentTypeResolver;
    private final GenericCandidateResolver genericCandidateResolver;
    private final ReflectionTypes reflectionTypes;
    private final Iterable<? extends AdditionalTypeChecker> additionalTypeCheckers;
    private final SmartCastManager smartCastManager;

    public final <D extends CallableDescriptor, F extends D> void performResolutionForCandidateCall(@NotNull CallCandidateResolutionContext<D> context, @NotNull ResolutionTask<D, F> task) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(task, "task");
        CallCandidateResolutionContext<D> $receiver = context;
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (ErrorUtils.isError(this.getCandidateDescriptor($receiver))) {
            $receiver.candidateCall.addStatus(ResolutionStatus.SUCCESS);
            return;
        }
        if (!this.checkOuterClassMemberIsAccessible($receiver)) {
            $receiver.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            return;
        }
        this.checkVisibility($receiver);
        switch (CandidateResolver$WhenMappings.$EnumSwitchMapping$0[task.checkArguments.ordinal()]) {
            case 1: {
                this.mapArguments($receiver);
                break;
            }
            case 2: {
                this.checkExpectedCallableType($receiver);
            }
        }
        this.checkReceiverTypeError($receiver);
        this.checkExtensionReceiver($receiver);
        this.checkDispatchReceiver($receiver);
        this.processTypeArguments($receiver);
        this.checkValueArguments($receiver);
        this.checkAbstractAndSuper($receiver);
        this.checkNonExtensionCalledWithReceiver($receiver);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkValueArguments(CallCandidateResolutionContext<?> $receiver) {
        void $receiver2;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (candidateResolver.shouldContinue($receiver2)) {
            void $receiver3;
            CallCandidateResolutionContext callCandidateResolutionContext2 = (CallCandidateResolutionContext)$receiver2;
            MutableResolvedCall mutableResolvedCall = $receiver2.candidateCall;
            ResolutionStatus resolutionStatus = $receiver3.call.getTypeArguments().isEmpty() && !this.getCandidateDescriptor($receiver3).getTypeParameters().isEmpty() && $receiver3.candidateCall.getKnownTypeParametersSubstitutor() == null ? this.genericCandidateResolver.inferTypeArguments($receiver3) : this.checkAllValueArguments((CallCandidateResolutionContext)$receiver3, ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS).getStatus();
            mutableResolvedCall.addStatus(resolutionStatus);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processTypeArguments(CallCandidateResolutionContext<?> $receiver) {
        block11: {
            CallCandidateResolutionContext $receiver2;
            block12: {
                TypeSubstitution substitution;
                int $i$f$size;
                void $receiver222;
                Collection $receiver3;
                void $receiver4;
                CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
                CandidateResolver candidateResolver = this;
                if (!candidateResolver.shouldContinue($receiver4)) break block11;
                $receiver2 = (CallCandidateResolutionContext)$receiver4;
                List<KtTypeProjection> jetTypeArguments = $receiver2.call.getTypeArguments();
                if (jetTypeArguments.isEmpty()) break block12;
                ArrayList<Object> typeArguments = new ArrayList<Object>();
                for (KtTypeProjection projection : jetTypeArguments) {
                    Object object;
                    block14: {
                        block13: {
                            object = projection.getTypeReference();
                            if (object == null) break block13;
                            KtTypeReference ktTypeReference = object;
                            KtTypeReference it = (KtTypeReference)((Object)$receiver3);
                            object = (KotlinType)$receiver2.trace.getBindingContext().get(BindingContext.TYPE, it);
                            if (object != null) break block14;
                        }
                        object = ErrorUtils.createErrorType("Star projection in a call");
                    }
                    Object type2 = object;
                    typeArguments.add(type2);
                }
                Collection collection = this.getCandidateDescriptor($receiver2).getTypeParameters();
                int expectedTypeArgumentCount = $receiver222.size();
                $receiver3 = jetTypeArguments;
                int $receiver222 = $receiver3.size();
                if ($receiver222 <= ($i$f$size = expectedTypeArgumentCount - 1)) {
                    while (true) {
                        void index2;
                        typeArguments.add(ErrorUtils.createErrorType("Explicit type argument expected for " + this.getCandidateDescriptor($receiver2).getTypeParameters().get((int)index2).getName()));
                        if (index2 == $i$f$size) break;
                        ++index2;
                    }
                }
                CallableDescriptor callableDescriptor = this.getCandidateDescriptor($receiver2);
                if (callableDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                }
                TypeSubstitution typeSubstitution = substitution = FunctionDescriptorUtil.createSubstitution((FunctionDescriptor)callableDescriptor, (List<KotlinType>)typeArguments);
                Intrinsics.checkExpressionValueIsNotNull(typeSubstitution, "substitution");
                TypeSubstitutor substitutor2 = TypeSubstitutor.create(new SubstitutionFilteringInternalResolveAnnotations(typeSubstitution));
                $receiver3 = jetTypeArguments;
                int n = expectedTypeArgumentCount;
                int n2 = $receiver3.size();
                if (n != n2) {
                    $receiver2.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
                    $receiver2.tracing.wrongNumberOfTypeArguments($receiver2.trace, expectedTypeArgumentCount);
                } else {
                    List<KtTypeProjection> list = jetTypeArguments;
                    Intrinsics.checkExpressionValueIsNotNull(list, "jetTypeArguments");
                    List list2 = typeArguments;
                    CallableDescriptor callableDescriptor2 = this.getCandidateDescriptor($receiver2);
                    TypeSubstitutor typeSubstitutor2 = substitutor2;
                    Intrinsics.checkExpressionValueIsNotNull(typeSubstitutor2, "substitutor");
                    BindingTrace bindingTrace = $receiver2.trace;
                    Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "trace");
                    this.checkGenericBoundsInAFunctionCall(list, list2, callableDescriptor2, typeSubstitutor2, bindingTrace);
                }
                $receiver2.candidateCall.setResultingSubstitutor(substitutor2);
                break block11;
            }
            if ($receiver2.candidateCall.getKnownTypeParametersSubstitutor() != null) {
                MutableResolvedCall mutableResolvedCall = $receiver2.candidateCall;
                TypeSubstitutor typeSubstitutor3 = $receiver2.candidateCall.getKnownTypeParametersSubstitutor();
                if (typeSubstitutor3 == null) {
                    Intrinsics.throwNpe();
                }
                mutableResolvedCall.setResultingSubstitutor(typeSubstitutor3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor, F extends D> void mapArguments(CallCandidateResolutionContext<D> $receiver) {
        void $receiver2;
        CallCandidateResolutionContext<D> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (candidateResolver.shouldContinue($receiver2)) {
            CallCandidateResolutionContext $receiver3 = (CallCandidateResolutionContext)$receiver2;
            ValueArgumentsToParametersMapper.Status argumentMappingStatus = ValueArgumentsToParametersMapper.mapValueArgumentsToParameters($receiver3.call, $receiver3.tracing, $receiver3.candidateCall, Sets.newLinkedHashSet());
            if (!argumentMappingStatus.isSuccess()) {
                $receiver3.candidateCall.addStatus(ResolutionStatus.ARGUMENTS_MAPPING_ERROR);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor, F extends D> void checkExpectedCallableType(CallCandidateResolutionContext<D> $receiver) {
        void $receiver2;
        CallCandidateResolutionContext<D> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (candidateResolver.shouldContinue($receiver2)) {
            CallCandidateResolutionContext $receiver3 = (CallCandidateResolutionContext)$receiver2;
            if (!TypeUtils.noExpectedType($receiver3.expectedType)) {
                Object candidate;
                Object d = candidate = $receiver3.candidateCall.getCandidateDescriptor();
                Intrinsics.checkExpressionValueIsNotNull(d, "candidate");
                KotlinType candidateReflectionType = CallableReferencesResolutionUtilsKt.getReflectionTypeForCandidateDescriptor(d, this.reflectionTypes);
                if (candidateReflectionType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(candidateReflectionType, $receiver3.expectedType)) {
                    $receiver3.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVisibility(CallCandidateResolutionContext<?> $receiver) {
        void $receiver2;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (candidateResolver.shouldContinue($receiver2)) {
            ResolutionStatus resolutionStatus;
            void $receiver3;
            CallCandidateResolutionContext callCandidateResolutionContext2 = (CallCandidateResolutionContext)$receiver2;
            MutableResolvedCall mutableResolvedCall = $receiver2.candidateCall;
            ReceiverValue receiverValue = ExpressionTypingUtils.normalizeReceiverValueForVisibility($receiver3.candidateCall.getDispatchReceiver(), $receiver3.trace.getBindingContext());
            DeclarationDescriptorWithVisibility invisibleMember = Visibilities.findInvisibleMember(receiverValue, this.getCandidateDescriptor($receiver3), $receiver3.scope.getOwnerDescriptor());
            if (invisibleMember != null) {
                $receiver3.tracing.invisibleMember($receiver3.trace, invisibleMember);
                resolutionStatus = ResolutionStatus.OTHER_ERROR;
            } else {
                resolutionStatus = ResolutionStatus.SUCCESS;
            }
            ResolutionStatus resolutionStatus2 = resolutionStatus;
            mutableResolvedCall.addStatus(resolutionStatus2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExtensionReceiver(CallCandidateResolutionContext<?> $receiver) {
        void $receiver2;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (candidateResolver.shouldContinue($receiver2)) {
            ResolutionStatus resolutionStatus;
            void $receiver3;
            CallCandidateResolutionContext callCandidateResolutionContext2 = (CallCandidateResolutionContext)$receiver2;
            MutableResolvedCall mutableResolvedCall = $receiver2.candidateCall;
            ReceiverParameterDescriptor receiverParameter = $receiver3.candidateCall.getCandidateDescriptor().getExtensionReceiverParameter();
            ReceiverValue receiverArgument = $receiver3.candidateCall.getExtensionReceiver();
            if (receiverParameter != null && !receiverArgument.exists()) {
                $receiver3.tracing.missingReceiver($receiver3.candidateCall.getTrace(), receiverParameter);
                resolutionStatus = ResolutionStatus.OTHER_ERROR;
            } else if (receiverParameter == null && receiverArgument.exists()) {
                $receiver3.tracing.noReceiverAllowed($receiver3.candidateCall.getTrace());
                resolutionStatus = $receiver3.call.getCalleeExpression() instanceof KtSimpleNameExpression ? ResolutionStatus.RECEIVER_PRESENCE_ERROR : ResolutionStatus.OTHER_ERROR;
            } else {
                resolutionStatus = ResolutionStatus.SUCCESS;
            }
            ResolutionStatus resolutionStatus2 = resolutionStatus;
            mutableResolvedCall.addStatus(resolutionStatus2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDispatchReceiver(CallCandidateResolutionContext<?> $receiver) {
        block6: {
            var3_2 = $receiver;
            var2_3 = this;
            if (!CandidateResolver.access$shouldContinue(var2_3, $receiver)) break block6;
            var4_4 = (CallCandidateResolutionContext)$receiver;
            var13_5 = $receiver.candidateCall;
            candidateDescriptor = CandidateResolver.access$getCandidateDescriptor$p(this, $receiver);
            dispatchReceiver = $receiver.candidateCall.getDispatchReceiver();
            if (!dispatchReceiver.exists()) ** GOTO lbl-1000
            nestedClass = null;
            if (candidateDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isStaticNestedClass(((ConstructorDescriptor)candidateDescriptor).getContainingDeclaration())) {
                nestedClass = ((ConstructorDescriptor)candidateDescriptor).getContainingDeclaration();
            } else if (candidateDescriptor instanceof FakeCallableDescriptorForObject) {
                nestedClass = ((FakeCallableDescriptorForObject)candidateDescriptor).getReferencedDescriptor();
            }
            if (nestedClass != null) {
                $receiver.tracing.nestedClassAccessViaInstanceReference($receiver.trace, nestedClass, $receiver.candidateCall.getExplicitReceiverKind());
                v0 = ResolutionStatus.OTHER_ERROR;
            } else lbl-1000:
            // 2 sources

            {
                nestedClass = dispatchReceiver.exists() == ($receiver.candidateCall.getResultingDescriptor().getDispatchReceiverParameter() != null);
                if (PreconditionsKt.getASSERTIONS_ENABLED() && value == false) {
                    message = "Shouldn't happen because of TaskPrioritizer: " + candidateDescriptor;
                    throw (Throwable)new AssertionError((Object)message);
                }
                v0 = ResolutionStatus.SUCCESS;
            }
            var14_11 = v0;
            var13_5.addStatus(var14_11);
        }
    }

    private final boolean checkOuterClassMemberIsAccessible(CallCandidateResolutionContext<?> context) {
        if (context.call.getExplicitReceiver().exists() || context.call.getDispatchReceiver().exists()) {
            return true;
        }
        Object d = context.candidateCall.getCandidateDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(d, "context.candidateCall.getCandidateDescriptor()");
        ClassDescriptor candidateThis = this.getDeclaringClass((CallableDescriptor)d);
        if (candidateThis == null || candidateThis.getKind().isSingleton()) {
            return true;
        }
        return DescriptorResolver.checkHasOuterClassInstance(context.scope, context.trace, context.call.getCallElement(), candidateThis);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAbstractAndSuper(CallCandidateResolutionContext<?> $receiver) {
        void $receiver2;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (candidateResolver.shouldContinue($receiver2)) {
            Modality modality;
            CallCandidateResolutionContext $receiver3 = (CallCandidateResolutionContext)$receiver2;
            CallableDescriptor descriptor2 = this.getCandidateDescriptor($receiver3);
            KtExpression expression = $receiver3.candidateCall.getCall().getCalleeExpression();
            if (expression instanceof KtSimpleNameExpression && descriptor2 instanceof ConstructorDescriptor && Intrinsics.areEqual((Object)(modality = ((ConstructorDescriptor)descriptor2).getContainingDeclaration().getModality()), (Object)Modality.ABSTRACT)) {
                $receiver3.tracing.instantiationOfAbstractClass($receiver3.trace);
            }
            ReceiverValue receiverValue = $receiver3.candidateCall.getDispatchReceiver();
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "candidateCall.getDispatchReceiver()");
            KtSuperExpression superDispatchReceiver = this.getReceiverSuper(receiverValue);
            if (superDispatchReceiver != null && descriptor2 instanceof MemberDescriptor && Intrinsics.areEqual((Object)((MemberDescriptor)((Object)descriptor2)).getModality(), (Object)Modality.ABSTRACT)) {
                $receiver3.tracing.abstractSuperCall($receiver3.trace);
                $receiver3.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            }
            ReceiverValue receiverValue2 = $receiver3.candidateCall.getExtensionReceiver();
            Intrinsics.checkExpressionValueIsNotNull(receiverValue2, "candidateCall.getExtensionReceiver()");
            KtSuperExpression superExtensionReceiver = this.getReceiverSuper(receiverValue2);
            if (superExtensionReceiver != null) {
                $receiver3.trace.report(Errors.SUPER_CANT_BE_EXTENSION_RECEIVER.on((KtSuperExpression)((PsiElement)superExtensionReceiver), superExtensionReceiver.getText()));
                $receiver3.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkNonExtensionCalledWithReceiver(CallCandidateResolutionContext<?> $receiver) {
        void $receiver2;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (candidateResolver.shouldContinue($receiver2)) {
            ResolutionStatus resolutionStatus;
            void $receiver3;
            CallCandidateResolutionContext callCandidateResolutionContext2 = (CallCandidateResolutionContext)$receiver2;
            MutableResolvedCall mutableResolvedCall = $receiver2.candidateCall;
            Call call = $receiver3.candidateCall.getCall();
            if (call instanceof CallTransformer.CallForImplicitInvoke && $receiver3.candidateCall.getExtensionReceiver().exists() && $receiver3.candidateCall.getDispatchReceiver().exists() && Intrinsics.areEqual(((CallTransformer.CallForImplicitInvoke)call).getDispatchReceiver(), $receiver3.candidateCall.getDispatchReceiver()) && !KotlinBuiltIns.isExactExtensionFunctionType(((CallTransformer.CallForImplicitInvoke)call).getDispatchReceiver().getType())) {
                $receiver3.tracing.nonExtensionFunctionCalledAsExtension($receiver3.trace);
                resolutionStatus = ResolutionStatus.OTHER_ERROR;
            } else {
                resolutionStatus = ResolutionStatus.SUCCESS;
            }
            ResolutionStatus resolutionStatus2 = resolutionStatus;
            mutableResolvedCall.addStatus(resolutionStatus2);
        }
    }

    private final KtSuperExpression getReceiverSuper(ReceiverValue receiver) {
        KtExpression expression;
        if (receiver instanceof ExpressionReceiver && (expression = ((ExpressionReceiver)receiver).getExpression()) instanceof KtSuperExpression) {
            return (KtSuperExpression)expression;
        }
        return null;
    }

    private final ClassDescriptor getDeclaringClass(CallableDescriptor candidate) {
        ReceiverParameterDescriptor receiverParameterDescriptor = candidate.getDispatchReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return null;
        }
        ReceiverParameterDescriptor expectedThis = receiverParameterDescriptor;
        DeclarationDescriptor descriptor2 = expectedThis.getContainingDeclaration();
        return descriptor2 instanceof ClassDescriptor ? (ClassDescriptor)descriptor2 : (ClassDescriptor)null;
    }

    @NotNull
    public final <D extends CallableDescriptor> ValueArgumentsCheckingResult checkAllValueArguments(@NotNull CallCandidateResolutionContext<D> context, @NotNull ResolveArgumentsMode resolveFunctionArgumentBodies) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull((Object)resolveFunctionArgumentBodies, "resolveFunctionArgumentBodies");
        CallResolutionContext callResolutionContext = context;
        MutableResolvedCall mutableResolvedCall = context.candidateCall;
        Intrinsics.checkExpressionValueIsNotNull(mutableResolvedCall, "context.candidateCall");
        ValueArgumentsCheckingResult checkingResult = this.checkValueArgumentTypes(callResolutionContext, mutableResolvedCall, resolveFunctionArgumentBodies);
        ResolutionStatus resultStatus = checkingResult.getStatus();
        ResolutionStatus resolutionStatus = resultStatus.combine(this.checkReceivers(context));
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionStatus, "resultStatus.combine(checkReceivers(context))");
        resultStatus = resolutionStatus;
        return new ValueArgumentsCheckingResult(resultStatus, checkingResult.getArgumentTypes());
    }

    private final <D extends CallableDescriptor, C extends CallResolutionContext<C>> ValueArgumentsCheckingResult checkValueArgumentTypes(CallResolutionContext<C> context, MutableResolvedCall<D> candidateCall, ResolveArgumentsMode resolveFunctionArgumentBodies) {
        ResolutionStatus resultStatus = ResolutionStatus.SUCCESS;
        ArrayList<KotlinType> argumentTypes = Lists.newArrayList();
        MutableDataFlowInfoForArguments infoForArguments = candidateCall.getDataFlowInfoForArguments();
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : CollectionsKt.mutableEntrySet(candidateCall.getValueArguments())) {
            ValueParameterDescriptor parameterDescriptor = CollectionsKt.getKey(entry);
            ResolvedValueArgument resolvedArgument = CollectionsKt.getValue(entry);
            for (ValueArgument argument : resolvedArgument.getArguments()) {
                KtExpression expression;
                if (argument.getArgumentExpression() == null) {
                    continue;
                }
                ValueParameterDescriptor valueParameterDescriptor = parameterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "parameterDescriptor");
                ValueArgument valueArgument = argument;
                Intrinsics.checkExpressionValueIsNotNull(valueArgument, "argument");
                KotlinType expectedType = CallResolverUtilKt.getEffectiveExpectedType(valueParameterDescriptor, valueArgument);
                CallResolutionContext newContext = (CallResolutionContext)((CallResolutionContext)context.replaceDataFlowInfo(infoForArguments.getInfo(argument))).replaceExpectedType(expectedType);
                JetTypeInfo typeInfoForCall = this.argumentTypeResolver.getArgumentTypeInfo(expression, newContext, resolveFunctionArgumentBodies);
                KotlinType type2 = typeInfoForCall.getType();
                infoForArguments.updateInfo(argument, typeInfoForCall.getDataFlowInfo());
                ArgumentMatchStatus matchStatus = ArgumentMatchStatus.SUCCESS;
                KotlinType resultingType = type2;
                if (type2 == null || type2.isError() && !FunctionPlaceholdersKt.isFunctionPlaceholder(type2)) {
                    matchStatus = ArgumentMatchStatus.ARGUMENT_HAS_NO_TYPE;
                } else if (!TypeUtils.noExpectedType(expectedType)) {
                    if (!ArgumentTypeResolver.isSubtypeOfForArgumentType(type2, expectedType)) {
                        KotlinType kotlinType = newContext.expectedType;
                        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "newContext.expectedType");
                        ResolutionContext resolutionContext = newContext;
                        Intrinsics.checkExpressionValueIsNotNull(resolutionContext, "newContext");
                        KotlinType smartCast = this.smartCastValueArgumentTypeIfPossible(expression, kotlinType, type2, resolutionContext);
                        if (smartCast == null) {
                            resultStatus = ResolutionStatus.OTHER_ERROR;
                            matchStatus = ArgumentMatchStatus.TYPE_MISMATCH;
                        } else {
                            resultingType = smartCast;
                        }
                    } else if (ErrorUtils.containsUninferredParameter(expectedType)) {
                        matchStatus = ArgumentMatchStatus.MATCH_MODULO_UNINFERRED_TYPES;
                    }
                }
                argumentTypes.add(resultingType);
                candidateCall.recordArgumentMatchStatus(argument, matchStatus);
            }
        }
        List list = argumentTypes;
        Intrinsics.checkExpressionValueIsNotNull(list, "argumentTypes");
        return new ValueArgumentsCheckingResult(resultStatus, list);
    }

    private final KotlinType smartCastValueArgumentTypeIfPossible(KtExpression expression, KotlinType expectedType, KotlinType actualType, ResolutionContext<?> context) {
        ExpressionReceiver receiverToCast = new ExpressionReceiver(KtPsiUtil.safeDeparenthesize(expression), actualType);
        Collection<KotlinType> variants = this.smartCastManager.getSmartCastVariantsExcludingReceiver(context, receiverToCast);
        for (KotlinType possibleType : variants) {
            if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(possibleType, expectedType)) continue;
            return possibleType;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkReceiverTypeError(CallCandidateResolutionContext<?> $receiver) {
        void $receiver2;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (candidateResolver.shouldContinue($receiver2)) {
            CallCandidateResolutionContext $receiver3 = (CallCandidateResolutionContext)$receiver2;
            ReceiverParameterDescriptor extensionReceiver2 = this.getCandidateDescriptor($receiver3).getExtensionReceiverParameter();
            ReceiverParameterDescriptor dispatchReceiver = this.getCandidateDescriptor($receiver3).getDispatchReceiverParameter();
            Call call = $receiver3.call;
            Intrinsics.checkExpressionValueIsNotNull(call, "call");
            if (!CallResolverUtilKt.isInvokeCallOnExpressionWithBothReceivers(call)) {
                ReceiverValue receiverValue = $receiver3.candidateCall.getExtensionReceiver();
                Intrinsics.checkExpressionValueIsNotNull(receiverValue, "candidateCall.getExtensionReceiver()");
                this.checkReceiverTypeError($receiver3, extensionReceiver2, receiverValue);
            }
            ReceiverValue receiverValue = $receiver3.candidateCall.getDispatchReceiver();
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "candidateCall.getDispatchReceiver()");
            this.checkReceiverTypeError($receiver3, dispatchReceiver, receiverValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkReceiverTypeError(CallCandidateResolutionContext<?> $receiver, ReceiverParameterDescriptor receiverParameterDescriptor, ReceiverValue receiverArgument) {
        void $receiver2;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver candidateResolver = this;
        if (candidateResolver.shouldContinue($receiver2)) {
            ResolutionStatus resolutionStatus;
            CallCandidateResolutionContext callCandidateResolutionContext2 = (CallCandidateResolutionContext)$receiver2;
            MutableResolvedCall mutableResolvedCall = $receiver2.candidateCall;
            if (receiverParameterDescriptor == null || !receiverArgument.exists()) {
                resolutionStatus = ResolutionStatus.SUCCESS;
            } else {
                void $receiver3;
                KotlinType erasedReceiverType = CallResolverUtilKt.getErasedReceiverType(receiverParameterDescriptor, this.getCandidateDescriptor($receiver3));
                resolutionStatus = !this.smartCastManager.isSubTypeBySmartCastIgnoringNullability(receiverArgument, erasedReceiverType, (ResolutionContext)$receiver3) ? ResolutionStatus.RECEIVER_TYPE_ERROR : ResolutionStatus.SUCCESS;
            }
            ResolutionStatus resolutionStatus2 = resolutionStatus;
            mutableResolvedCall.addStatus(resolutionStatus2);
        }
    }

    private final <D extends CallableDescriptor> ResolutionStatus checkReceivers(CallCandidateResolutionContext<D> context) {
        ResolutionStatus resultStatus = ResolutionStatus.SUCCESS;
        MutableResolvedCall candidateCall = context.candidateCall;
        ResolvedCall resolvedCall = candidateCall;
        Intrinsics.checkExpressionValueIsNotNull(resolvedCall, "candidateCall");
        ReceiverParameterDescriptor receiverParameterDescriptor = candidateCall.getResultingDescriptor().getExtensionReceiverParameter();
        ReceiverValue receiverValue = candidateCall.getExtensionReceiver();
        Intrinsics.checkExpressionValueIsNotNull(receiverValue, "candidateCall.getExtensionReceiver()");
        ResolutionStatus resolutionStatus = resultStatus.combine(this.checkReceiver(context, resolvedCall, receiverParameterDescriptor, receiverValue, candidateCall.getExplicitReceiverKind().isExtensionReceiver(), false));
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionStatus, "resultStatus.combine(con\u2026ensionReceiver(), false))");
        resultStatus = resolutionStatus;
        ResolvedCall resolvedCall2 = candidateCall;
        Intrinsics.checkExpressionValueIsNotNull(resolvedCall2, "candidateCall");
        ReceiverParameterDescriptor receiverParameterDescriptor2 = candidateCall.getResultingDescriptor().getDispatchReceiverParameter();
        ReceiverValue receiverValue2 = candidateCall.getDispatchReceiver();
        Intrinsics.checkExpressionValueIsNotNull(receiverValue2, "candidateCall.getDispatchReceiver()");
        ResolutionStatus resolutionStatus2 = resultStatus.combine(this.checkReceiver(context, resolvedCall2, receiverParameterDescriptor2, receiverValue2, candidateCall.getExplicitReceiverKind().isDispatchReceiver(), context.call instanceof CallTransformer.CallForImplicitInvoke));
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionStatus2, "resultStatus.combine(con\u2026s CallForImplicitInvoke))");
        resultStatus = resolutionStatus2;
        return resultStatus;
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor> ResolutionStatus checkReceiver(CallCandidateResolutionContext<D> $receiver, ResolvedCall<D> candidateCall, ReceiverParameterDescriptor receiverParameter, ReceiverValue receiverArgument, boolean isExplicitReceiver, boolean implicitInvokeCheck) {
        void $receiver2;
        if (receiverParameter == null || !receiverArgument.exists()) {
            return ResolutionStatus.SUCCESS;
        }
        D candidateDescriptor = candidateCall.getCandidateDescriptor();
        if (TypeUtils.dependsOnTypeParameters(receiverParameter.getType(), (Collection<TypeParameterDescriptor>)candidateDescriptor.getTypeParameters())) {
            return ResolutionStatus.SUCCESS;
        }
        boolean safeAccess = isExplicitReceiver && !implicitInvokeCheck && CallUtilKt.isExplicitSafeCall(candidateCall.getCall());
        boolean isSubtypeBySmartCastIgnoringNullability = this.smartCastManager.isSubTypeBySmartCastIgnoringNullability(receiverArgument, receiverParameter.getType(), $receiver);
        if (!isSubtypeBySmartCastIgnoringNullability) {
            $receiver.tracing.wrongReceiverType($receiver.trace, receiverParameter, receiverArgument);
            return ResolutionStatus.OTHER_ERROR;
        }
        KotlinType expectedReceiverParameterType = safeAccess ? TypeUtils.makeNullable(receiverParameter.getType()) : receiverParameter.getType();
        boolean smartCastNeeded = !ArgumentTypeResolver.isSubtypeOfForArgumentType(receiverArgument.getType(), expectedReceiverParameterType);
        boolean reportUnsafeCall = false;
        if (smartCastNeeded) {
            ReceiverValue receiverValue = receiverArgument;
            if (!(receiverValue instanceof ExpressionReceiver)) {
                receiverValue = null;
            }
            ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
            KtExpression expression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiverArgument, $receiver);
            SmartCastResult smartCastResult = this.smartCastManager.checkAndRecordPossibleCast(dataFlowValue, expectedReceiverParameterType, expression, $receiver, true);
            if (smartCastResult == null) {
                reportUnsafeCall = true;
            } else if (!smartCastResult.isCorrect()) {
                return ResolutionStatus.OTHER_ERROR;
            }
        }
        KotlinType receiverArgumentType = receiverArgument.getType();
        if (reportUnsafeCall) {
            $receiver.tracing.unsafeCall($receiver.trace, receiverArgumentType, implicitInvokeCheck);
            return ResolutionStatus.UNSAFE_CALL_ERROR;
        }
        BindingContext bindingContext2 = $receiver.trace.getBindingContext();
        DataFlowValue receiverValue = DataFlowValueFactory.createDataFlowValue(receiverArgument, bindingContext2, $receiver.scope.getOwnerDescriptor());
        if (safeAccess && !$receiver.dataFlowInfo.getNullability(receiverValue).canBeNull()) {
            $receiver.tracing.unnecessarySafeCall($receiver.trace, receiverArgument.getType());
        }
        Iterable<? extends AdditionalTypeChecker> iterable = this.additionalTypeCheckers;
        for (Object element : $receiver2) {
            AdditionalTypeChecker it = (AdditionalTypeChecker)element;
            it.checkReceiver(receiverParameter, receiverArgument, safeAccess, (CallResolutionContext)$receiver);
        }
        return ResolutionStatus.SUCCESS;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkGenericBoundsInAFunctionCall(List<? extends KtTypeProjection> jetTypeArguments, List<? extends KotlinType> typeArguments, CallableDescriptor functionDescriptor, TypeSubstitutor substitutor2, BindingTrace trace) {
        Collection $receiver;
        List<TypeParameterDescriptor> typeParameters = functionDescriptor.getTypeParameters();
        int n = 0;
        Collection collection = typeParameters;
        int n2 = $receiver.size();
        $receiver = jetTypeArguments;
        int n3 = n2;
        int n4 = $receiver.size();
        int n5 = Math.min(n3, n4) - 1;
        if (n <= n5) {
            while (true) {
                void i;
                TypeParameterDescriptor typeParameterDescriptor = typeParameters.get((int)i);
                KotlinType typeArgument = typeArguments.get((int)i);
                KtTypeReference typeReference = jetTypeArguments.get((int)i).getTypeReference();
                if (typeReference != null) {
                    DescriptorResolver.checkBounds(typeReference, typeArgument, typeParameterDescriptor, substitutor2, trace);
                }
                if (i == n5) break;
                ++i;
            }
        }
    }

    private final <D extends CallableDescriptor> boolean shouldContinue(CallCandidateResolutionContext<D> $receiver) {
        return Intrinsics.areEqual((Object)$receiver.candidateResolveMode, (Object)CandidateResolveMode.FULLY) || $receiver.candidateCall.getStatus().possibleTransformToSuccess();
    }

    private final CallableDescriptor getCandidateDescriptor(CallCandidateResolutionContext<?> $receiver) {
        Object d = $receiver.candidateCall.getCandidateDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(d, "candidateCall.getCandidateDescriptor()");
        return d;
    }

    public CandidateResolver(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull GenericCandidateResolver genericCandidateResolver, @NotNull ReflectionTypes reflectionTypes, @NotNull Iterable<? extends AdditionalTypeChecker> additionalTypeCheckers, @NotNull SmartCastManager smartCastManager) {
        Intrinsics.checkParameterIsNotNull(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkParameterIsNotNull(genericCandidateResolver, "genericCandidateResolver");
        Intrinsics.checkParameterIsNotNull(reflectionTypes, "reflectionTypes");
        Intrinsics.checkParameterIsNotNull(additionalTypeCheckers, "additionalTypeCheckers");
        Intrinsics.checkParameterIsNotNull(smartCastManager, "smartCastManager");
        this.argumentTypeResolver = argumentTypeResolver;
        this.genericCandidateResolver = genericCandidateResolver;
        this.reflectionTypes = reflectionTypes;
        this.additionalTypeCheckers = additionalTypeCheckers;
        this.smartCastManager = smartCastManager;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001d\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0011\u000b\u0005a\u0011!B\u0001\u0005\u0006\u0011\u0019%\u0001\u0004\u0001\u001a\u0003a\u0005\u0011\u0015EE\u0005\u0011\u0005i\u0011\u0001g\u0001Q\u0007\u0003Iy\u0001\u0003\u0002\u000e\t%\u0011\u0011\"\u0001\r\u00041\u000b\u00016!A)\u0004\u0003!\u001d\u0011&\u0004\u0003D\u0011!\u0011Q\u0002B\u0005\u0003\u0013\u0005A2\u0001'\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005\t!%\u0011F\u0003\u0003D\u0011!\tQ\"\u0001M\u0002#\u000e!Q\u0001A\u0007\u0003\t\u0015AY\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver$ValueArgumentsCheckingResult;", "", "status", "Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;", "argumentTypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;Ljava/util/List;)V", "getArgumentTypes", "()Ljava/util/List;", "getStatus", "()Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;"}, moduleName="kotlin-compiler")
    public final class ValueArgumentsCheckingResult {
        @NotNull
        private final ResolutionStatus status;
        @NotNull
        private final List<? extends KotlinType> argumentTypes;

        @NotNull
        public final ResolutionStatus getStatus() {
            return this.status;
        }

        @NotNull
        public final List<KotlinType> getArgumentTypes() {
            return this.argumentTypes;
        }

        public ValueArgumentsCheckingResult(@NotNull ResolutionStatus status, @NotNull List<? extends KotlinType> argumentTypes) {
            Intrinsics.checkParameterIsNotNull((Object)status, "status");
            Intrinsics.checkParameterIsNotNull(argumentTypes, "argumentTypes");
            this.status = status;
            this.argumentTypes = argumentTypes;
        }
    }
}

