/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestRunnerUtils;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class TestMethodGradleConfigurationProducer
extends GradleTestRunConfigurationProducer {
    private static final List<String> TASKS_TO_RUN = ContainerUtil.newArrayList((Object[])new String[]{"cleanTest", "test"});

    public TestMethodGradleConfigurationProducer() {
        super((ConfigurationType)GradleExternalTaskConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        Location<PsiMethod> methodLocation = TestRunnerUtils.getMethodLocation(contextLocation);
        if (methodLocation == null) {
            return false;
        }
        PsiMethod psiMethod = (PsiMethod)methodLocation.getPsiElement();
        sourceElement.set((Object)psiMethod);
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        if (context.getModule() == null) {
            return false;
        }
        if (!TestMethodGradleConfigurationProducer.applyTestMethodConfiguration(configuration, context, psiMethod, containingClass)) {
            return false;
        }
        JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, contextLocation);
        return true;
    }

    public boolean isConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context) {
        if (configuration == null) {
            return false;
        }
        if (!GradleConstants.SYSTEM_ID.equals((Object)configuration.getSettings().getExternalSystemId())) {
            return false;
        }
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        Location<PsiMethod> methodLocation = TestRunnerUtils.getMethodLocation(contextLocation);
        if (methodLocation == null) {
            return false;
        }
        PsiMethod psiMethod = (PsiMethod)methodLocation.getPsiElement();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        if (context.getModule() == null) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)context.getModule().getOptionValue("external.linked.project.path"), (CharSequence)configuration.getSettings().getExternalProjectPath())) {
            return false;
        }
        if (!configuration.getSettings().getTaskNames().containsAll(TASKS_TO_RUN)) {
            return false;
        }
        String scriptParameters = configuration.getSettings().getScriptParameters() + ' ';
        String testFilter = TestMethodGradleConfigurationProducer.creatTestFilter(containingClass, psiMethod);
        return scriptParameters.contains(testFilter);
    }

    public void onFirstRun(final ConfigurationFromContext fromContext, ConfigurationContext context, Runnable performRunnable) {
        PsiClass containingClass;
        final PsiMethod psiMethod = (PsiMethod)fromContext.getSourceElement();
        InheritorChooser inheritorChooser = new InheritorChooser(){

            protected void runForClasses(List<PsiClass> classes, PsiMethod method, ConfigurationContext context, Runnable performRunnable) {
                if (!StringUtil.equals((CharSequence)context.getModule().getOptionValue("external.system.id"), (CharSequence)GradleConstants.SYSTEM_ID.toString())) {
                    return;
                }
                ExternalSystemRunConfiguration configuration = (ExternalSystemRunConfiguration)fromContext.getConfiguration();
                if (!TestMethodGradleConfigurationProducer.applyTestMethodConfiguration(configuration, context, psiMethod, (PsiClass[])ArrayUtil.toObjectArray(classes, PsiClass.class))) {
                    return;
                }
                super.runForClasses(classes, method, context, performRunnable);
            }

            protected void runForClass(PsiClass aClass, PsiMethod psiMethod2, ConfigurationContext context, Runnable performRunnable) {
                if (!StringUtil.equals((CharSequence)context.getModule().getOptionValue("external.system.id"), (CharSequence)GradleConstants.SYSTEM_ID.toString())) {
                    return;
                }
                ExternalSystemRunConfiguration configuration = (ExternalSystemRunConfiguration)fromContext.getConfiguration();
                if (!TestMethodGradleConfigurationProducer.applyTestMethodConfiguration(configuration, context, psiMethod2, new PsiClass[]{aClass})) {
                    return;
                }
                super.runForClass(aClass, psiMethod2, context, performRunnable);
            }
        };
        if (inheritorChooser.runMethodInAbstractClass(context, performRunnable, psiMethod, containingClass = psiMethod.getContainingClass())) {
            return;
        }
        super.onFirstRun(fromContext, context, performRunnable);
    }

    private static boolean applyTestMethodConfiguration(@NotNull ExternalSystemRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull PsiMethod psiMethod, PsiClass ... containingClasses) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/plugins/gradle/execution/test/runner/TestMethodGradleConfigurationProducer", "applyTestMethodConfiguration"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/gradle/execution/test/runner/TestMethodGradleConfigurationProducer", "applyTestMethodConfiguration"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "org/jetbrains/plugins/gradle/execution/test/runner/TestMethodGradleConfigurationProducer", "applyTestMethodConfiguration"));
        }
        if (containingClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClasses", "org/jetbrains/plugins/gradle/execution/test/runner/TestMethodGradleConfigurationProducer", "applyTestMethodConfiguration"));
        }
        if (!StringUtil.equals((CharSequence)context.getModule().getOptionValue("external.system.id"), (CharSequence)GradleConstants.SYSTEM_ID.toString())) {
            return false;
        }
        configuration.getSettings().setExternalProjectPath(context.getModule().getOptionValue("external.linked.project.path"));
        configuration.getSettings().setTaskNames(TASKS_TO_RUN);
        StringBuilder buf = new StringBuilder();
        for (PsiClass aClass : containingClasses) {
            buf.append(TestMethodGradleConfigurationProducer.creatTestFilter(aClass, psiMethod));
        }
        configuration.getSettings().setScriptParameters(buf.toString().trim());
        configuration.setName(psiMethod.getName());
        return true;
    }

    private static String creatTestFilter(@NotNull PsiClass aClass, @NotNull PsiMethod psiMethod) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/gradle/execution/test/runner/TestMethodGradleConfigurationProducer", "creatTestFilter"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "org/jetbrains/plugins/gradle/execution/test/runner/TestMethodGradleConfigurationProducer", "creatTestFilter"));
        }
        String testFilterPattern = aClass.getQualifiedName() + '.' + psiMethod.getName();
        return String.format("--tests \"%s\" ", StringUtil.replaceChar((String)testFilterPattern, (char)'\"', (char)'*'));
    }
}

