/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBSplitter
extends Splitter {
    @Nullable
    private String mySplitterProportionKey;
    private final float myDefaultProportion;

    public JBSplitter() {
        this.mySplitterProportionKey = null;
        this.myDefaultProportion = 0.5f;
    }

    public JBSplitter(@NotNull String proportionKey, float defaultProportion) {
        if (proportionKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proportionKey", "com/intellij/ui/JBSplitter", "<init>"));
        }
        this(false, proportionKey, defaultProportion);
    }

    public JBSplitter(boolean vertical, @NotNull String proportionKey, float defaultProportion) {
        if (proportionKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proportionKey", "com/intellij/ui/JBSplitter", "<init>"));
        }
        super(vertical, defaultProportion);
        this.mySplitterProportionKey = null;
        this.mySplitterProportionKey = proportionKey;
        this.myDefaultProportion = defaultProportion;
    }

    public JBSplitter(boolean vertical) {
        super(vertical);
        this.mySplitterProportionKey = null;
        this.myDefaultProportion = 0.5f;
    }

    public JBSplitter(boolean vertical, float proportion) {
        super(vertical, proportion);
        this.mySplitterProportionKey = null;
        this.myDefaultProportion = proportion;
    }

    public JBSplitter(float proportion) {
        super(false, proportion);
        this.mySplitterProportionKey = null;
        this.myDefaultProportion = proportion;
    }

    public JBSplitter(boolean vertical, float proportion, float minProp, float maxProp) {
        super(vertical, proportion, minProp, maxProp);
        this.mySplitterProportionKey = null;
        this.myDefaultProportion = proportion;
    }

    @Nullable
    public final String getSplitterProportionKey() {
        return this.mySplitterProportionKey;
    }

    public final void setSplitterProportionKey(@Nullable String key) {
        this.mySplitterProportionKey = key;
    }

    public final void setAndLoadSplitterProportionKey(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/ui/JBSplitter", "setAndLoadSplitterProportionKey"));
        }
        this.setSplitterProportionKey(key);
        this.loadProportion();
    }

    public void addNotify() {
        super.addNotify();
        this.loadProportion();
    }

    public void setProportion(float proportion) {
        super.setProportion(proportion);
        this.saveProportion();
    }

    protected void loadProportion() {
        if (!StringUtil.isEmpty((String)this.mySplitterProportionKey)) {
            this.setProportion(PropertiesComponent.getInstance().getFloat(this.mySplitterProportionKey, this.myProportion));
        }
    }

    protected void saveProportion() {
        if (!StringUtil.isEmpty((String)this.mySplitterProportionKey)) {
            PropertiesComponent.getInstance().setValue(this.mySplitterProportionKey, this.myProportion, this.myDefaultProportion);
        }
    }
}

