/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GrScopeProcessorWithHints;

class DeclarationCacheKey {
    private static final CachedValueProvider<ConcurrentMap<DeclarationCacheKey, List<DeclarationHolder>>> VALUE_PROVIDER = new CachedValueProvider<ConcurrentMap<DeclarationCacheKey, List<DeclarationHolder>>>(){

        @Nullable
        public CachedValueProvider.Result<ConcurrentMap<DeclarationCacheKey, List<DeclarationHolder>>> compute() {
            ConcurrentMap map = ContainerUtil.newConcurrentMap();
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
    };
    @Nullable
    private final String name;
    @NotNull
    private final EnumSet<ClassHint.ResolveKind> kinds;
    private final boolean nonCode;
    @NotNull
    private final PsiElement place;

    DeclarationCacheKey(@Nullable String name, ClassHint hint, boolean nonCode, @NotNull PsiElement place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/DeclarationCacheKey", "<init>"));
        }
        this.name = name;
        this.kinds = DeclarationCacheKey.getResolveKinds(hint);
        this.nonCode = nonCode;
        this.place = place;
    }

    private static EnumSet<ClassHint.ResolveKind> getResolveKinds(ClassHint hint) {
        EnumSet<ClassHint.ResolveKind> set = EnumSet.noneOf(ClassHint.ResolveKind.class);
        for (ClassHint.ResolveKind kind : ClassHint.ResolveKind.values()) {
            if (!hint.shouldProcess(kind)) continue;
            set.add(kind);
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeclarationCacheKey)) {
            return false;
        }
        DeclarationCacheKey key = (DeclarationCacheKey)o;
        if (this.nonCode != key.nonCode) {
            return false;
        }
        if (!this.kinds.equals(key.kinds)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(key.name) : key.name != null) {
            return false;
        }
        return this.place == key.place;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.kinds.hashCode();
        result = 31 * result + (this.nonCode ? 1 : 0);
        result = 31 * result + this.place.hashCode();
        return result;
    }

    public String toString() {
        return "DeclarationCacheKey{name='" + this.name + '\'' + ", kinds=" + this.kinds + ", nonCode=" + this.nonCode + ", place=" + this.place.toString() + '}';
    }

    private List<DeclarationHolder> collectDeclarations(PsiElement place) {
        final List result = ContainerUtil.newSmartList();
        PsiTreeUtil.treeWalkUp((PsiElement)place, null, (PairProcessor)new PairProcessor<PsiElement, PsiElement>(){

            public boolean process(PsiElement scope, PsiElement lastParent) {
                result.add(DeclarationCacheKey.this.collectScopeDeclarations(scope, lastParent));
                return !DeclarationCacheKey.this.nonCode || !(scope instanceof GrClosableBlock);
            }
        });
        return result;
    }

    private DeclarationHolder collectScopeDeclarations(PsiElement scope, PsiElement lastParent) {
        MyCollectProcessor plainCollector = new MyCollectProcessor();
        MyCollectProcessor nonCodeCollector = new MyCollectProcessor();
        ResolveUtil.doProcessDeclarations(this.place, lastParent, scope, plainCollector, this.nonCode ? nonCodeCollector : null, ResolveState.initial());
        return new DeclarationHolder(scope, plainCollector.declarations, nonCodeCollector.declarations);
    }

    private List<DeclarationHolder> getAllDeclarations(PsiElement place) {
        ConcurrentMap cache = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)place, VALUE_PROVIDER);
        List<DeclarationHolder> declarations = (List<DeclarationHolder>)cache.get(this);
        if (declarations == null) {
            declarations = this.collectDeclarations(place);
            cache.putIfAbsent(this, declarations);
        }
        return declarations;
    }

    boolean processCachedDeclarations(PsiElement place, PsiScopeProcessor processor) {
        for (DeclarationHolder holder : this.getAllDeclarations(place)) {
            ProgressManager.checkCanceled();
            if (holder.processCachedDeclarations(processor)) continue;
            return false;
        }
        return true;
    }

    private class MyCollectProcessor
    extends GrScopeProcessorWithHints {
        final List<Pair<PsiElement, ResolveState>> declarations;

        public MyCollectProcessor() {
            super(DeclarationCacheKey.this.name, DeclarationCacheKey.this.kinds);
            this.declarations = ContainerUtil.newSmartList();
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/resolve/DeclarationCacheKey$MyCollectProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/resolve/DeclarationCacheKey$MyCollectProcessor", "execute"));
            }
            this.declarations.add((Pair<PsiElement, ResolveState>)Pair.create((Object)element, (Object)state));
            return true;
        }
    }

    private static class DeclarationHolder {
        final PsiElement scope;
        final List<Pair<PsiElement, ResolveState>> plainDeclarations;
        final List<Pair<PsiElement, ResolveState>> nonCodeDeclarations;

        private DeclarationHolder(PsiElement scope, List<Pair<PsiElement, ResolveState>> plainDeclarations, List<Pair<PsiElement, ResolveState>> nonCodeDeclarations) {
            this.scope = scope;
            this.plainDeclarations = plainDeclarations.isEmpty() ? null : plainDeclarations;
            this.nonCodeDeclarations = nonCodeDeclarations.isEmpty() ? null : nonCodeDeclarations;
        }

        boolean processCachedDeclarations(PsiScopeProcessor processor) {
            PsiScopeProcessor realProcessor = ResolveUtil.substituteProcessor(processor, this.scope);
            if (this.plainDeclarations != null) {
                for (Pair<PsiElement, ResolveState> pair : this.plainDeclarations) {
                    if (realProcessor.execute((PsiElement)pair.first, (ResolveState)pair.second)) continue;
                    return false;
                }
            }
            if (this.nonCodeDeclarations != null) {
                for (Pair<PsiElement, ResolveState> pair : this.nonCodeDeclarations) {
                    if (processor.execute((PsiElement)pair.first, (ResolveState)pair.second)) continue;
                    return false;
                }
            }
            ResolveUtil.issueLevelChangeEvents(processor, this.scope);
            return true;
        }

        public String toString() {
            return "[scope=" + this.scope.toString() + ", plain=" + this.plainDeclarations.size() + ", nonCode=" + this.nonCodeDeclarations.size();
        }
    }
}

