/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.completion.AbstractLookup;
import org.intellij.lang.xpath.completion.CompletionLists;
import org.intellij.lang.xpath.completion.Lookup;
import org.intellij.lang.xpath.completion.XPathInsertHandler;
import org.intellij.lang.xpath.context.NamespaceContext;
import org.intellij.lang.xpath.psi.PrefixedName;
import org.intellij.lang.xpath.psi.QNameElement;
import org.intellij.lang.xpath.psi.XPath2InstanceOf;
import org.intellij.lang.xpath.psi.XPath2TreatAs;
import org.intellij.lang.xpath.psi.XPath2Type;
import org.intellij.lang.xpath.psi.XPath2TypeElement;
import org.intellij.lang.xpath.psi.XPathAxisSpecifier;
import org.intellij.lang.xpath.psi.XPathElement;
import org.intellij.lang.xpath.psi.XPathFunctionCall;
import org.intellij.lang.xpath.psi.XPathNodeTest;
import org.intellij.lang.xpath.psi.XPathVariableReference;
import org.jetbrains.annotations.NotNull;

public class XPathCompletionContributor
extends CompletionContributor {
    public static final XPathInsertHandler INSERT_HANDLER = new XPathInsertHandler();

    public XPathCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(XPathNodeTest.class), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/intellij/lang/xpath/completion/XPathCompletionContributor$1", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/intellij/lang/xpath/completion/XPathCompletionContributor$1", "addCompletions"));
                }
                XPathNodeTest nodeTest = (XPathNodeTest)parameters.getPosition().getParent();
                XPathCompletionContributor.addResult(result, CompletionLists.getNodeTestCompletions(nodeTest), parameters.getPosition(), parameters.getOffset());
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(XPathNodeTest.class).with(XPathCompletionContributor.prefix())), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/intellij/lang/xpath/completion/XPathCompletionContributor$2", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/intellij/lang/xpath/completion/XPathCompletionContributor$2", "addCompletions"));
                }
                XPathNodeTest nodeTest = (XPathNodeTest)parameters.getPosition().getParent();
                XPathCompletionContributor.addResult(result, CompletionLists.getFunctionCompletions(nodeTest), parameters.getPosition(), parameters.getOffset());
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(XPathAxisSpecifier.class), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/intellij/lang/xpath/completion/XPathCompletionContributor$3", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/intellij/lang/xpath/completion/XPathCompletionContributor$3", "addCompletions"));
                }
                XPathCompletionContributor.addResult(result, CompletionLists.getAxisCompletions(), parameters.getPosition(), parameters.getOffset());
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(XPathFunctionCall.class), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/intellij/lang/xpath/completion/XPathCompletionContributor$4", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/intellij/lang/xpath/completion/XPathCompletionContributor$4", "addCompletions"));
                }
                XPathFunctionCall call = (XPathFunctionCall)parameters.getPosition().getParent();
                XPathCompletionContributor.addResult(result, CompletionLists.getFunctionCompletions(call), parameters.getPosition(), parameters.getOffset());
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(XPathFunctionCall.class).without(XPathCompletionContributor.prefix())), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/intellij/lang/xpath/completion/XPathCompletionContributor$5", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/intellij/lang/xpath/completion/XPathCompletionContributor$5", "addCompletions"));
                }
                XPathFunctionCall call = (XPathFunctionCall)parameters.getPosition().getParent();
                XPathCompletionContributor.addResult(result, CompletionLists.getNodeTypeCompletions(call), parameters.getPosition(), parameters.getOffset());
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(XPathVariableReference.class), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/intellij/lang/xpath/completion/XPathCompletionContributor$6", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/intellij/lang/xpath/completion/XPathCompletionContributor$6", "addCompletions"));
                }
                XPathCompletionContributor.addResult(result, CompletionLists.getVariableCompletions((XPathVariableReference)parameters.getPosition().getParent()), parameters.getPosition(), parameters.getOffset());
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(XPath2TypeElement.class).without(XPathCompletionContributor.prefix())), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                String prefixForURI;
                NamespaceContext namespaceContext;
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/intellij/lang/xpath/completion/XPathCompletionContributor$7", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/intellij/lang/xpath/completion/XPathCompletionContributor$7", "addCompletions"));
                }
                XPathElement parent = (XPathElement)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), XPathElement.class);
                assert (parent != null);
                if (parent.getParent() instanceof XPath2TreatAs || parent.getParent() instanceof XPath2InstanceOf) {
                    XPathCompletionContributor.addResult(result, CompletionLists.getNodeTypeCompletions(parent), parameters.getPosition(), parameters.getOffset());
                }
                if ((namespaceContext = parent.getXPathContext().getNamespaceContext()) != null && (prefixForURI = namespaceContext.getPrefixForURI("http://www.w3.org/2001/XMLSchema", parent.getXPathContext().getContextElement())) != null && prefixForURI.length() > 0) {
                    XPathCompletionContributor.addResult(result, ContainerUtil.map(XPath2Type.SchemaType.listSchemaTypes(), (Function)new Function<XPath2Type, Lookup>(){

                        public Lookup fun(XPath2Type type) {
                            return new MyLookup(prefixForURI + ":" + type.getQName().getLocalPart());
                        }
                    }), parameters.getPosition(), parameters.getOffset());
                }
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(XPath2TypeElement.class).with(XPathCompletionContributor.prefix())), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/intellij/lang/xpath/completion/XPathCompletionContributor$8", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/intellij/lang/xpath/completion/XPathCompletionContributor$8", "addCompletions"));
                }
                XPath2TypeElement parent = (XPath2TypeElement)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), XPath2TypeElement.class);
                assert (parent != null);
                QName qName = parent.getXPathContext().getQName(parent);
                if (qName != null && qName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                    XPathCompletionContributor.addResult(result, ContainerUtil.map(XPath2Type.SchemaType.listSchemaTypes(), (Function)new Function<XPath2Type, Lookup>(){

                        public Lookup fun(XPath2Type type) {
                            return new MyLookup(type.getQName().getLocalPart());
                        }
                    }), parameters.getPosition(), parameters.getOffset());
                }
            }
        });
    }

    private static PatternCondition<QNameElement> prefix() {
        return new PatternCondition<QNameElement>("hasPrefix"){

            public boolean accepts(@NotNull QNameElement qnameElement, ProcessingContext context) {
                if (qnameElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qnameElement", "org/intellij/lang/xpath/completion/XPathCompletionContributor$9", "accepts"));
                }
                PrefixedName qname = qnameElement.getQName();
                return qname != null && qname.getPrefix() != null;
            }
        };
    }

    private static void addResult(CompletionResultSet result, Collection<Lookup> collection, PsiElement position, int offset) {
        result = result.withPrefixMatcher(XPathCompletionContributor.findPrefixStatic(position, offset));
        for (Lookup lookup : collection) {
            LookupItem item = new LookupItem((Object)lookup, lookup.toString());
            item.setInsertHandler((InsertHandler)INSERT_HANDLER);
            if (lookup.isKeyword()) {
                item.setBold();
            }
            result.addElement((LookupElement)item);
        }
    }

    private static String findPrefixStatic(PsiElement element, int i) {
        XPathNodeTest nodeTest;
        String prefix = CompletionData.findPrefixStatic((PsiElement)element, (int)i);
        if (element.getParent() instanceof XPathVariableReference) {
            prefix = "$" + prefix;
        }
        if (element.getParent() instanceof XPathNodeTest && (nodeTest = (XPathNodeTest)element.getParent()).isNameTest()) {
            PrefixedName prefixedName = nodeTest.getQName();
            assert (prefixedName != null);
            String p = prefixedName.getPrefix();
            int endIndex = prefixedName.getLocalName().indexOf("IntellijIdeaRulezzz");
            if (endIndex != -1) {
                prefix = prefixedName.getLocalName().substring(0, endIndex);
            } else if (p != null && (endIndex = p.indexOf("IntellijIdeaRulezzz")) != -1) {
                prefix = p.substring(0, endIndex);
            }
        }
        return prefix;
    }

    private static class MyLookup
    extends AbstractLookup {
        public MyLookup(String name) {
            super(name, name);
        }
    }
}

