/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.util.IncorrectOperationException;

public class MissingSwitchBodyFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (!(psiElement instanceof PsiSwitchStatement)) {
            return;
        }
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)psiElement;
        Document doc = editor.getDocument();
        PsiCodeBlock body = switchStatement.getBody();
        if (body != null) {
            return;
        }
        PsiJavaToken rParenth = switchStatement.getRParenth();
        assert (rParenth != null);
        doc.insertString(rParenth.getTextRange().getEndOffset(), (CharSequence)"{}");
    }
}

