/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.inheritance.search;

import com.intellij.codeInspection.inheritance.search.InheritorsCountData;
import com.intellij.codeInspection.inheritance.search.InheritorsStatisticsSearchResult;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class InheritorsStatisticalDataSearch {
    public static List<InheritorsStatisticsSearchResult> search(@NotNull PsiClass superClass, @NotNull PsiClass aClass, @NotNull GlobalSearchScope scope, int minPercentRatio) {
        int percent;
        InheritorsCountData data;
        int inheritorsCount;
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/codeInspection/inheritance/search/InheritorsStatisticalDataSearch", "search"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInspection/inheritance/search/InheritorsStatisticalDataSearch", "search"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/inheritance/search/InheritorsStatisticalDataSearch", "search"));
        }
        String superClassName = superClass.getName();
        String aClassName = aClass.getName();
        HashSet<String> disabledNames = new HashSet<String>();
        disabledNames.add(aClassName);
        disabledNames.add(superClassName);
        TreeSet<InheritorsCountData> collector = new TreeSet<InheritorsCountData>();
        Couple<Integer> collectingResult = InheritorsStatisticalDataSearch.collectInheritorsInfo(superClass, collector, disabledNames);
        int allAnonymousInheritors = (Integer)collectingResult.getSecond();
        int allInheritors = (Integer)collectingResult.getFirst() + allAnonymousInheritors - 1;
        ArrayList<InheritorsStatisticsSearchResult> result2 = new ArrayList<InheritorsStatisticsSearchResult>();
        Integer firstPercent = null;
        Iterator iterator = collector.iterator();
        while (iterator.hasNext() && (inheritorsCount = (data = (InheritorsCountData)iterator.next()).getInheritorsCount()) >= allAnonymousInheritors && (percent = inheritorsCount * 100 / allInheritors) >= 1) {
            PsiClass psiClass;
            VirtualFile file;
            if (firstPercent == null) {
                firstPercent = percent;
            } else if (percent * minPercentRatio < firstPercent) break;
            if ((file = (psiClass = data.getPsiClass()).getContainingFile().getVirtualFile()) == null || !scope.contains(file)) continue;
            result2.add(new InheritorsStatisticsSearchResult(psiClass, percent));
        }
        return result2;
    }

    private static Couple<Integer> collectInheritorsInfo(PsiClass superClass, Set<InheritorsCountData> collector, Set<String> disabledNames) {
        return InheritorsStatisticalDataSearch.collectInheritorsInfo(superClass, collector, disabledNames, new HashSet<String>(), new HashSet<String>());
    }

    private static Couple<Integer> collectInheritorsInfo(PsiClass aClass, Set<InheritorsCountData> collector, Set<String> disabledNames, Set<String> processedElements, Set<String> allNotAnonymousInheritors) {
        String className = aClass.getName();
        if (!processedElements.add(className)) {
            return Couple.of((Object)0, (Object)0);
        }
        MyInheritorsInfoProcessor processor2 = new MyInheritorsInfoProcessor(collector, disabledNames, processedElements);
        DirectClassInheritorsSearch.search((PsiClass)aClass).forEach((Processor)processor2);
        allNotAnonymousInheritors.addAll(processor2.getAllNotAnonymousInheritors());
        int allInheritorsCount = processor2.getAllNotAnonymousInheritors().size() + processor2.getAnonymousInheritorsCount();
        if (!aClass.isInterface() && allInheritorsCount != 0 && !disabledNames.contains(className)) {
            collector.add(new InheritorsCountData(aClass, allInheritorsCount));
        }
        return Couple.of((Object)allNotAnonymousInheritors.size(), (Object)processor2.getAnonymousInheritorsCount());
    }

    private static class MyInheritorsInfoProcessor
    implements Processor<PsiClass> {
        private final Set<InheritorsCountData> myCollector;
        private final Set<String> myDisabledNames;
        private final Set<String> myProcessedElements;
        private final Set<String> myAllNotAnonymousInheritors;
        private int myAnonymousInheritorsCount = 0;

        private MyInheritorsInfoProcessor(Set<InheritorsCountData> collector, Set<String> disabledNames, Set<String> processedElements) {
            this.myCollector = collector;
            this.myDisabledNames = disabledNames;
            this.myProcessedElements = processedElements;
            this.myAllNotAnonymousInheritors = new HashSet<String>();
        }

        private Set<String> getAllNotAnonymousInheritors() {
            return this.myAllNotAnonymousInheritors;
        }

        private int getAnonymousInheritorsCount() {
            return this.myAnonymousInheritorsCount;
        }

        public boolean process(PsiClass psiClass) {
            String inheritorName = psiClass.getName();
            if (inheritorName == null) {
                ++this.myAnonymousInheritorsCount;
            } else {
                Couple res = InheritorsStatisticalDataSearch.collectInheritorsInfo(psiClass, this.myCollector, this.myDisabledNames, this.myProcessedElements, this.myAllNotAnonymousInheritors);
                this.myAnonymousInheritorsCount += ((Integer)res.getSecond()).intValue();
                if (!psiClass.isInterface()) {
                    this.myAllNotAnonymousInheritors.add(inheritorName);
                }
            }
            return true;
        }
    }
}

