/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch;

import com.intellij.compiler.classFilesIndex.chainsSearch.MethodsChain;
import com.intellij.compiler.classFilesIndex.chainsSearch.context.ChainCompletionContext;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public final class ParametersMatcher {
    private static final MatchResult EMPTY = new MatchResult(0, 0, false);

    private ParametersMatcher() {
    }

    public static MatchResult matchParameters(MethodsChain chain, ChainCompletionContext context) {
        MatchResult overallResult = EMPTY;
        for (PsiMethod[] methods : chain.getPath()) {
            TreeSet<MatchResult> matchResults = new TreeSet<MatchResult>();
            for (PsiMethod method : methods) {
                matchResults.add(ParametersMatcher.matchParameters(method, context, chain.getExcludedQNames()));
            }
            MatchResult best = (MatchResult)matchResults.first();
            overallResult = overallResult.add(best);
        }
        return overallResult;
    }

    private static MatchResult matchParameters(PsiMethod method, ChainCompletionContext context, Set<String> additionalExcludedNames) {
        int matched = 0;
        int unMatched = 0;
        boolean hasTarget = false;
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            PsiType type = parameter.getType();
            String canonicalText = type.getCanonicalText();
            if (context.contains(canonicalText) || type instanceof PsiPrimitiveType) {
                ++matched;
            } else {
                ++unMatched;
            }
            if (!context.getTarget().getClassQName().equals(canonicalText) && !additionalExcludedNames.contains(canonicalText)) continue;
            hasTarget = true;
        }
        return new MatchResult(matched, unMatched, hasTarget);
    }

    public static class MatchResult
    implements Comparable<MatchResult> {
        private final int myMatched;
        private final int myUnMatched;
        private final boolean myHasTarget;

        private MatchResult(int matched, int unMatched, boolean hasTarget) {
            this.myMatched = matched;
            this.myUnMatched = unMatched;
            this.myHasTarget = hasTarget;
        }

        public int getMatched() {
            return this.myMatched;
        }

        public int getUnMatched() {
            return this.myUnMatched;
        }

        public boolean hasTarget() {
            return this.myHasTarget;
        }

        public MatchResult add(MatchResult other) {
            return new MatchResult(this.getMatched() + other.getMatched(), this.getUnMatched() + other.getUnMatched(), other.myHasTarget || this.myHasTarget);
        }

        public boolean noUnmatchedAndHasMatched() {
            return this.myUnMatched == 0 && this.myMatched != 0;
        }

        @Override
        public int compareTo(@NotNull MatchResult other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/compiler/classFilesIndex/chainsSearch/ParametersMatcher$MatchResult", "compareTo"));
            }
            int sub = this.getUnMatched() - other.getUnMatched();
            if (sub != 0) {
                return sub;
            }
            return this.getMatched() - other.getMatched();
        }
    }
}

