/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch.context;

import com.intellij.compiler.classFilesIndex.impl.MethodIncompleteSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.classFilesIndex.AsmUtil;

final class MethodIncompleteSignatureResolver {
    private final Map<MethodIncompleteSignature, PsiMethod[]> myResolvedCache;

    public MethodIncompleteSignatureResolver(final JavaPsiFacade javaPsiFacade, final GlobalSearchScope scope) {
        this.myResolvedCache = new FactoryMap<MethodIncompleteSignature, PsiMethod[]>(){

            @Nullable
            protected PsiMethod[] create(MethodIncompleteSignature signature) {
                return MethodIncompleteSignatureResolver.resolveNotDeprecated(signature, javaPsiFacade, scope);
            }
        };
    }

    @NotNull
    public PsiMethod[] get(MethodIncompleteSignature signature) {
        PsiMethod[] psiMethodArray = this.myResolvedCache.get(signature);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/context/MethodIncompleteSignatureResolver", "get"));
        }
        return psiMethodArray;
    }

    private static PsiMethod[] resolveNotDeprecated(MethodIncompleteSignature signature, JavaPsiFacade javaPsiFacade, GlobalSearchScope scope) {
        if ("<init>".equals(signature.getName())) {
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiClass aClass = javaPsiFacade.findClass(AsmUtil.getQualifiedClassName((String)signature.getOwner()), scope);
        if (aClass == null) {
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] methods = aClass.findMethodsByName(signature.getName(), true);
        ArrayList<PsiMethod> filtered = new ArrayList<PsiMethod>(methods.length);
        for (PsiMethod method : methods) {
            PsiType returnType;
            if (method.hasModifierProperty("static") != signature.isStatic() || (returnType = method.getReturnType()) == null) continue;
            if (returnType instanceof PsiClassType) {
                String qualifiedName;
                PsiClass resolved = ((PsiClassType)returnType).resolve();
                if (resolved == null || (qualifiedName = resolved.getQualifiedName()) == null || !qualifiedName.equals(signature.getReturnType())) continue;
                filtered.add(method);
                continue;
            }
            if (!returnType.equalsToText(signature.getReturnType())) continue;
            filtered.add(method);
        }
        if (filtered.size() > 1) {
            Collections.sort(filtered, new Comparator<PsiMethod>(){

                @Override
                public int compare(PsiMethod o1, PsiMethod o2) {
                    return o1.getParameterList().getParametersCount() - o2.getParameterList().getParametersCount();
                }
            });
        }
        return filtered.toArray(new PsiMethod[filtered.size()]);
    }
}

