/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.sm.FileUrlProvider;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testIntegration.TestLocationProvider;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeTestLocationProvider
implements SMTestLocator {
    private final TestLocationProvider myPrimaryLocator;
    private final TestLocationProvider[] myLocators;

    public CompositeTestLocationProvider(@Nullable TestLocationProvider primaryLocator) {
        this.myPrimaryLocator = primaryLocator;
        this.myLocators = (TestLocationProvider[])Extensions.getExtensions(TestLocationProvider.EP_NAME);
    }

    @Override
    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        List<Location> locations;
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/execution/testframework/sm/CompositeTestLocationProvider", "getLocation"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/execution/testframework/sm/CompositeTestLocationProvider", "getLocation"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/sm/CompositeTestLocationProvider", "getLocation"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/execution/testframework/sm/CompositeTestLocationProvider", "getLocation"));
        }
        boolean isDumbMode = DumbService.isDumb((Project)project);
        if (!(this.myPrimaryLocator == null || isDumbMode && !(this.myPrimaryLocator instanceof DumbAware) || (locations = this.myPrimaryLocator.getLocation(protocol, path, project)).isEmpty())) {
            List<Location> list = locations;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/CompositeTestLocationProvider", "getLocation"));
            }
            return list;
        }
        if ("file".equals(protocol) && !(locations = FileUrlProvider.INSTANCE.getLocation(protocol, path, project, scope)).isEmpty()) {
            List<Location> list = locations;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/CompositeTestLocationProvider", "getLocation"));
            }
            return list;
        }
        for (TestLocationProvider provider : this.myLocators) {
            List<Location> locations2;
            if (isDumbMode && !(provider instanceof DumbAware) || (locations2 = provider.getLocation(protocol, path, project)).isEmpty()) continue;
            List<Location> list = locations2;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/CompositeTestLocationProvider", "getLocation"));
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/CompositeTestLocationProvider", "getLocation"));
        }
        return list;
    }
}

