/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.apply;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatch;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ApplyFilePatchBase<T extends FilePatch>
implements ApplyFilePatch {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase");
    protected final T myPatch;

    public ApplyFilePatchBase(T patch) {
        this.myPatch = patch;
    }

    public T getPatch() {
        return this.myPatch;
    }

    @Override
    public ApplyFilePatch.Result apply(VirtualFile fileToPatch, ApplyPatchContext context, Project project, FilePath pathBeforeRename, Getter<CharSequence> baseContents, CommitContext commitContext) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("apply patch called for : " + fileToPatch.getPath());
        }
        if (this.myPatch.isNewFile()) {
            this.applyCreate(project, fileToPatch, commitContext);
        } else if (this.myPatch.isDeletedFile()) {
            FileEditorManager.getInstance((Project)project).closeFile(fileToPatch);
            fileToPatch.delete((Object)this);
        } else {
            return this.applyChange(project, fileToPatch, pathBeforeRename, baseContents);
        }
        return SUCCESS;
    }

    protected abstract void applyCreate(Project var1, VirtualFile var2, CommitContext var3) throws IOException;

    protected abstract ApplyFilePatch.Result applyChange(Project var1, VirtualFile var2, FilePath var3, Getter<CharSequence> var4) throws IOException;

    @Nullable
    public static VirtualFile findPatchTarget(ApplyPatchContext context, String beforeName, String afterName, boolean isNewFile) throws IOException {
        VirtualFile file = null;
        if (beforeName != null) {
            file = ApplyFilePatchBase.findFileToPatchByName(context, beforeName, isNewFile);
        }
        if (file == null) {
            file = ApplyFilePatchBase.findFileToPatchByName(context, afterName, isNewFile);
        } else if (context.isAllowRename() && afterName != null && !beforeName.equals(afterName)) {
            boolean needMove;
            String[] afterNameComponents;
            String[] beforeNameComponents = beforeName.split("/");
            if (!beforeNameComponents[beforeNameComponents.length - 1].equals((afterNameComponents = afterName.split("/"))[afterNameComponents.length - 1])) {
                context.registerBeforeRename(file);
                file.rename(FilePatch.class, afterNameComponents[afterNameComponents.length - 1]);
            }
            boolean bl = needMove = beforeNameComponents.length != afterNameComponents.length;
            if (!needMove) {
                needMove = ApplyFilePatchBase.checkPackageRename(context, beforeNameComponents, afterNameComponents);
            }
            if (needMove) {
                VirtualFile moveTarget = ApplyFilePatchBase.findFileToPatchByComponents(context, afterNameComponents, afterNameComponents.length - 1);
                if (moveTarget == null) {
                    return null;
                }
                context.registerBeforeRename(file);
                file.move(FilePatch.class, moveTarget);
            }
        }
        return file;
    }

    private static boolean checkPackageRename(ApplyPatchContext context, String[] beforeNameComponents, String[] afterNameComponents) {
        int changedIndex = -1;
        for (int i = context.getSkipTopDirs(); i < afterNameComponents.length - 1; ++i) {
            if (beforeNameComponents[i].equals(afterNameComponents[i])) continue;
            if (changedIndex != -1) {
                return true;
            }
            changedIndex = i;
        }
        if (changedIndex == -1) {
            return false;
        }
        VirtualFile oldDir = ApplyFilePatchBase.findFileToPatchByComponents(context, beforeNameComponents, changedIndex + 1);
        VirtualFile newDir = ApplyFilePatchBase.findFileToPatchByComponents(context.getPrepareContext(), afterNameComponents, changedIndex + 1);
        return oldDir == null || newDir != null;
    }

    @Nullable
    private static VirtualFile findFileToPatchByName(@NotNull ApplyPatchContext context, String fileName, boolean isNewFile) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/diff/impl/patch/apply/ApplyFilePatchBase", "findFileToPatchByName"));
        }
        String[] pathNameComponents = fileName.split("/");
        int lastComponentToFind = isNewFile ? pathNameComponents.length - 1 : pathNameComponents.length;
        return ApplyFilePatchBase.findFileToPatchByComponents(context, pathNameComponents, lastComponentToFind);
    }

    @Nullable
    private static VirtualFile findFileToPatchByComponents(ApplyPatchContext context, String[] pathNameComponents, int lastComponentToFind) {
        VirtualFile patchedDir = context.getBaseDir();
        for (int i = context.getSkipTopDirs(); i < lastComponentToFind; ++i) {
            VirtualFile nextChild = pathNameComponents[i].equals("..") ? patchedDir.getParent() : patchedDir.findChild(pathNameComponents[i]);
            if (nextChild == null) {
                if (context.isCreateDirectories()) {
                    try {
                        nextChild = patchedDir.createChildDirectory(null, pathNameComponents[i]);
                    }
                    catch (IOException e) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            patchedDir = nextChild;
        }
        return patchedDir;
    }
}

