/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.indexing.IndexedRootsProvider;
import org.jetbrains.annotations.NotNull;

public class AdditionalIndexedRootsScope
extends GlobalSearchScope {
    private final GlobalSearchScope myBaseScope;
    private final IndexableFileSet myFileSet;

    public AdditionalIndexedRootsScope(GlobalSearchScope baseScope) {
        this(baseScope, new AdditionalIndexableFileSet());
    }

    public AdditionalIndexedRootsScope(GlobalSearchScope baseScope, Class<? extends IndexedRootsProvider> providerClass) {
        this(baseScope, new AdditionalIndexableFileSet((IndexedRootsProvider)IndexableSetContributor.EP_NAME.findExtension(providerClass)));
    }

    public AdditionalIndexedRootsScope(GlobalSearchScope baseScope, IndexableFileSet myFileSet) {
        super(baseScope.getProject());
        this.myBaseScope = baseScope;
        this.myFileSet = myFileSet;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/AdditionalIndexedRootsScope", "contains"));
        }
        return this.myBaseScope.contains(file) || this.myFileSet.isInSet(file);
    }

    public boolean isSearchOutsideRootModel() {
        return true;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/util/indexing/AdditionalIndexedRootsScope", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/util/indexing/AdditionalIndexedRootsScope", "compare"));
        }
        return this.myBaseScope.compare(file1, file2);
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/util/indexing/AdditionalIndexedRootsScope", "isSearchInModuleContent"));
        }
        return this.myBaseScope.isSearchInModuleContent(aModule);
    }

    public boolean isSearchInLibraries() {
        return this.myBaseScope.isSearchInLibraries();
    }
}

