/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifiableBooleanExpressionInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("simplifiable.boolean.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SimplifiableBooleanExpressionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)infos[0];
        String string = InspectionGadgetsBundle.message("boolean.expression.can.be.simplified.problem.descriptor", SimplifiableBooleanExpressionInspection.calculateReplacementExpression(prefixExpression));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SimplifiableBooleanExpressionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new SimplifiableBooleanExpressionFix();
    }

    @NonNls
    static String calculateReplacementExpression(PsiPrefixExpression expression) {
        PsiExpression operand = ParenthesesUtils.stripParentheses(expression.getOperand());
        if (!(operand instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)operand;
        PsiExpression lhs = ParenthesesUtils.stripParentheses(binaryExpression.getLOperand());
        PsiExpression rhs = ParenthesesUtils.stripParentheses(binaryExpression.getROperand());
        if (lhs == null || rhs == null) {
            return null;
        }
        return ParenthesesUtils.getText(lhs, 9) + "==" + ParenthesesUtils.getText(rhs, 9);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableBooleanExpressionVisitor();
    }

    private static class SimplifiableBooleanExpressionVisitor
    extends BaseInspectionVisitor {
        private SimplifiableBooleanExpressionVisitor() {
        }

        public void visitPrefixExpression(PsiPrefixExpression expression) {
            super.visitPrefixExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!JavaTokenType.EXCL.equals(tokenType)) {
                return;
            }
            PsiExpression operand = ParenthesesUtils.stripParentheses(expression.getOperand());
            if (!(operand instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)operand;
            IElementType binaryTokenType = binaryExpression.getOperationTokenType();
            if (!JavaTokenType.XOR.equals(binaryTokenType)) {
                return;
            }
            PsiExpression lhs = ParenthesesUtils.stripParentheses(binaryExpression.getLOperand());
            PsiExpression rhs = ParenthesesUtils.stripParentheses(binaryExpression.getROperand());
            if (lhs == null || rhs == null) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }
    }

    private static class SimplifiableBooleanExpressionFix
    extends InspectionGadgetsFix {
        private SimplifiableBooleanExpressionFix() {
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SimplifiableBooleanExpressionInspection$SimplifiableBooleanExpressionFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SimplifiableBooleanExpressionInspection$SimplifiableBooleanExpressionFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiPrefixExpression)) {
                return;
            }
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)element;
            String replacement = SimplifiableBooleanExpressionInspection.calculateReplacementExpression(prefixExpression);
            if (replacement == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)prefixExpression, replacement);
        }
    }
}

