/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifiableIfStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("simplifiable.if.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/SimplifiableIfStatementInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableIfStatementVisitor();
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiIfStatement statement = (PsiIfStatement)infos[0];
        String string = InspectionGadgetsBundle.message("simplifiable.if.statement.problem.descriptor", StringUtil.escapeXml((String)SimplifiableIfStatementInspection.calculateReplacementStatement(statement)));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/SimplifiableIfStatementInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    @NonNls
    static String calculateReplacementStatement(PsiIfStatement statement) {
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(statement.getThenBranch());
        if (thenBranch == null) {
            return null;
        }
        PsiStatement elseBranch = statement.getElseBranch();
        if (elseBranch == null) {
            PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)statement, (Class[])new Class[]{PsiWhiteSpace.class});
            if (nextStatement instanceof PsiStatement) {
                elseBranch = (PsiStatement)nextStatement;
            }
        } else {
            elseBranch = ControlFlowUtils.stripBraces(elseBranch);
        }
        if (elseBranch == null) {
            return null;
        }
        PsiExpression condition = statement.getCondition();
        if (condition == null) {
            return null;
        }
        if (thenBranch instanceof PsiReturnStatement && elseBranch instanceof PsiReturnStatement) {
            return SimplifiableIfStatementInspection.calculateReplacementReturnStatement(thenBranch, elseBranch, condition);
        }
        if (thenBranch instanceof PsiExpressionStatement && elseBranch instanceof PsiExpressionStatement) {
            PsiExpressionStatement thenStatement = (PsiExpressionStatement)thenBranch;
            PsiExpressionStatement elseStatement = (PsiExpressionStatement)elseBranch;
            PsiExpression thenExpression = thenStatement.getExpression();
            PsiExpression elseExpression = elseStatement.getExpression();
            if (!(thenExpression instanceof PsiAssignmentExpression) || !(elseExpression instanceof PsiAssignmentExpression)) {
                return null;
            }
            PsiAssignmentExpression thenAssignment = (PsiAssignmentExpression)thenExpression;
            PsiAssignmentExpression elseAssignment = (PsiAssignmentExpression)elseExpression;
            return SimplifiableIfStatementInspection.calculateReplacementAssignmentStatement(thenAssignment, elseAssignment, condition);
        }
        return null;
    }

    private static String calculateReplacementAssignmentStatement(PsiAssignmentExpression thenAssignment, PsiAssignmentExpression elseAssignment, PsiExpression condition) {
        PsiExpression lhs = thenAssignment.getLExpression();
        PsiExpression thenRhs = thenAssignment.getRExpression();
        if (thenRhs == null) {
            return "";
        }
        PsiExpression elseRhs = elseAssignment.getRExpression();
        if (elseRhs == null) {
            return "";
        }
        PsiJavaToken token = elseAssignment.getOperationSign();
        if (BoolUtils.isTrue(thenRhs)) {
            return lhs.getText() + ' ' + token.getText() + ' ' + SimplifiableIfStatementInspection.buildExpressionText(condition, 14) + " || " + SimplifiableIfStatementInspection.buildExpressionText(elseRhs, 14) + ';';
        }
        if (BoolUtils.isFalse(thenRhs)) {
            return lhs.getText() + ' ' + token.getText() + ' ' + BoolUtils.getNegatedExpressionText(condition, 13) + " && " + SimplifiableIfStatementInspection.buildExpressionText(elseRhs, 13) + ';';
        }
        if (BoolUtils.isTrue(elseRhs)) {
            return lhs.getText() + ' ' + token.getText() + ' ' + BoolUtils.getNegatedExpressionText(condition, 14) + " || " + SimplifiableIfStatementInspection.buildExpressionText(thenRhs, 14) + ';';
        }
        return lhs.getText() + ' ' + token.getText() + ' ' + SimplifiableIfStatementInspection.buildExpressionText(condition, 13) + " && " + SimplifiableIfStatementInspection.buildExpressionText(thenRhs, 13) + ';';
    }

    @NonNls
    private static String calculateReplacementReturnStatement(PsiStatement thenBranch, PsiStatement elseBranch, PsiExpression condition) {
        PsiReturnStatement thenReturnStatement = (PsiReturnStatement)thenBranch;
        PsiExpression thenReturnValue = thenReturnStatement.getReturnValue();
        if (thenReturnValue == null) {
            return "";
        }
        PsiReturnStatement elseReturnStatement = (PsiReturnStatement)elseBranch;
        PsiExpression elseReturnValue = elseReturnStatement.getReturnValue();
        if (elseReturnValue == null) {
            return "";
        }
        if (BoolUtils.isTrue(thenReturnValue)) {
            return "return " + SimplifiableIfStatementInspection.buildExpressionText(condition, 14) + " || " + SimplifiableIfStatementInspection.buildExpressionText(elseReturnValue, 14) + ';';
        }
        if (BoolUtils.isFalse(thenReturnValue)) {
            return "return " + BoolUtils.getNegatedExpressionText(condition, 13) + " && " + SimplifiableIfStatementInspection.buildExpressionText(elseReturnValue, 13) + ';';
        }
        if (BoolUtils.isTrue(elseReturnValue)) {
            return "return " + BoolUtils.getNegatedExpressionText(condition, 14) + " || " + SimplifiableIfStatementInspection.buildExpressionText(thenReturnValue, 14) + ';';
        }
        return "return " + SimplifiableIfStatementInspection.buildExpressionText(condition, 13) + " && " + SimplifiableIfStatementInspection.buildExpressionText(thenReturnValue, 13) + ';';
    }

    private static String buildExpressionText(PsiExpression expression, int precedence) {
        StringBuilder builder = new StringBuilder();
        if (ParenthesesUtils.getPrecedence(expression) > precedence) {
            builder.append('(');
            SimplifiableIfStatementInspection.appendPresentableText((PsiElement)expression, builder);
            builder.append(')');
        } else {
            SimplifiableIfStatementInspection.appendPresentableText((PsiElement)expression, builder);
        }
        return builder.toString();
    }

    private static void appendPresentableText(@Nullable PsiElement element, StringBuilder builder) {
        if (element == null) {
            return;
        }
        if (element instanceof PsiWhiteSpace) {
            PsiComment comment;
            PsiElement prevSibling = element.getPrevSibling();
            if (prevSibling instanceof PsiComment && JavaTokenType.END_OF_LINE_COMMENT.equals((comment = (PsiComment)prevSibling).getTokenType())) {
                builder.append('\n');
                return;
            }
            builder.append(' ');
            return;
        }
        PsiElement[] children2 = element.getChildren();
        if (children2.length == 0) {
            builder.append(element.getText());
        } else {
            for (PsiElement child : children2) {
                SimplifiableIfStatementInspection.appendPresentableText(child, builder);
            }
        }
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SimplifiableIfStatementFix();
    }

    private static class SimplifiableIfStatementVisitor
    extends BaseInspectionVisitor {
        private SimplifiableIfStatementVisitor() {
        }

        public void visitIfStatement(PsiIfStatement statement) {
            super.visitIfStatement(statement);
            if (statement.getCondition() == null) {
                return;
            }
            if (!SimplifiableIfStatementVisitor.isReplaceableAssignment(statement) && !SimplifiableIfStatementVisitor.isReplaceableReturn(statement)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, statement);
        }

        public static boolean isReplaceableReturn(PsiIfStatement ifStatement) {
            PsiElement nextStatement;
            PsiStatement thenBranch = ifStatement.getThenBranch();
            thenBranch = ControlFlowUtils.stripBraces(thenBranch);
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if ((elseBranch = ControlFlowUtils.stripBraces(elseBranch)) == null && (nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class})) instanceof PsiStatement) {
                elseBranch = (PsiStatement)nextStatement;
            }
            if (!(thenBranch instanceof PsiReturnStatement) || !(elseBranch instanceof PsiReturnStatement)) {
                return false;
            }
            PsiExpression thenReturn = ((PsiReturnStatement)thenBranch).getReturnValue();
            if (thenReturn == null) {
                return false;
            }
            PsiType thenType = thenReturn.getType();
            if (!PsiType.BOOLEAN.equals((Object)thenType)) {
                return false;
            }
            PsiExpression elseReturn = ((PsiReturnStatement)elseBranch).getReturnValue();
            if (elseReturn == null) {
                return false;
            }
            PsiType elseType = elseReturn.getType();
            if (!PsiType.BOOLEAN.equals((Object)elseType)) {
                return false;
            }
            boolean thenConstant = BoolUtils.isFalse(thenReturn) || BoolUtils.isTrue(thenReturn);
            boolean elseConstant = BoolUtils.isFalse(elseReturn) || BoolUtils.isTrue(elseReturn);
            return thenConstant != elseConstant;
        }

        public static boolean isReplaceableAssignment(PsiIfStatement ifStatement) {
            boolean elseConstant;
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch == null) {
                return false;
            }
            if ((thenBranch = ControlFlowUtils.stripBraces(thenBranch)) == null || !SimplifiableIfStatementVisitor.isAssignment(thenBranch)) {
                return false;
            }
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch == null) {
                return false;
            }
            if ((elseBranch = ControlFlowUtils.stripBraces(elseBranch)) == null || !SimplifiableIfStatementVisitor.isAssignment(elseBranch)) {
                return false;
            }
            PsiExpressionStatement thenStatement = (PsiExpressionStatement)thenBranch;
            PsiAssignmentExpression thenExpression = (PsiAssignmentExpression)thenStatement.getExpression();
            PsiExpressionStatement elseStatement = (PsiExpressionStatement)elseBranch;
            PsiAssignmentExpression elseExpression = (PsiAssignmentExpression)elseStatement.getExpression();
            IElementType elseTokenType = elseExpression.getOperationTokenType();
            if (!thenExpression.getOperationTokenType().equals(elseTokenType)) {
                return false;
            }
            PsiExpression thenRhs = thenExpression.getRExpression();
            if (thenRhs == null) {
                return false;
            }
            PsiType thenRhsType = thenRhs.getType();
            if (!PsiType.BOOLEAN.equals((Object)thenRhsType)) {
                return false;
            }
            PsiExpression elseRhs = elseExpression.getRExpression();
            if (elseRhs == null) {
                return false;
            }
            PsiType elseRhsType = elseRhs.getType();
            if (!PsiType.BOOLEAN.equals((Object)elseRhsType)) {
                return false;
            }
            boolean thenConstant = BoolUtils.isFalse(thenRhs) || BoolUtils.isTrue(thenRhs);
            boolean bl = elseConstant = BoolUtils.isFalse(elseRhs) || BoolUtils.isTrue(elseRhs);
            if (thenConstant == elseConstant) {
                return false;
            }
            PsiExpression thenLhs = thenExpression.getLExpression();
            PsiExpression elseLhs = elseExpression.getLExpression();
            return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
        }

        public static boolean isAssignment(@Nullable PsiStatement statement) {
            if (!(statement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            return expression instanceof PsiAssignmentExpression;
        }
    }

    private static class SimplifiableIfStatementFix
    extends InspectionGadgetsFix {
        private SimplifiableIfStatementFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/SimplifiableIfStatementInspection$SimplifiableIfStatementFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/SimplifiableIfStatementInspection$SimplifiableIfStatementFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement nextStatement;
            PsiElement element = descriptor.getPsiElement();
            PsiIfStatement ifStatement = (PsiIfStatement)element.getParent();
            ArrayList<PsiComment> before = new ArrayList<PsiComment>();
            ArrayList<PsiComment> after = new ArrayList<PsiComment>();
            SimplifiableIfStatementFix.collectComments((PsiElement)ifStatement, true, before, after);
            String newStatementText = SimplifiableIfStatementInspection.calculateReplacementStatement(ifStatement);
            if (newStatementText == null) {
                return;
            }
            StringBuilder codeBlockText = new StringBuilder("{\n");
            for (PsiComment comment : before) {
                codeBlockText.append(comment.getText()).append('\n');
            }
            codeBlockText.append(newStatementText).append('\n');
            for (PsiComment comment : after) {
                codeBlockText.append(comment.getText()).append('\n');
            }
            codeBlockText.append('}');
            if (ifStatement.getElseBranch() == null && (nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)ifStatement, (Class[])new Class[]{PsiWhiteSpace.class})) != null) {
                nextStatement.delete();
            }
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiCodeBlock codeBlock = psiFacade.getElementFactory().createCodeBlockFromText(codeBlockText.toString(), (PsiElement)ifStatement);
            PsiElement parent = ifStatement.getParent();
            PsiElement child = codeBlock.getFirstBodyElement();
            PsiElement end = codeBlock.getLastBodyElement();
            while (true) {
                parent.addBefore(child, (PsiElement)ifStatement);
                if (child == end) break;
                child = child.getNextSibling();
            }
            ifStatement.delete();
            CodeStyleManager.getInstance((Project)project).reformat(parent);
        }

        private static void collectComments(PsiElement element, boolean first, List<PsiComment> before, List<PsiComment> after) {
            if (element instanceof PsiComment) {
                if (first) {
                    before.add((PsiComment)element);
                } else {
                    after.add((PsiComment)element);
                }
                return;
            }
            for (PsiElement child : element.getChildren()) {
                if (child instanceof PsiKeyword) {
                    PsiKeyword keyword = (PsiKeyword)child;
                    if (keyword.getTokenType() != JavaTokenType.ELSE_KEYWORD) continue;
                    first = false;
                    continue;
                }
                SimplifiableIfStatementFix.collectComments(child, first, before, after);
            }
        }
    }
}

