/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.wizard;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectPathField;
import com.intellij.openapi.externalSystem.service.ui.SelectExternalProjectDialog;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleModuleWizardStep;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleParentProjectForm {
    private static final String EMPTY_PARENT = "<none>";
    @Nullable
    private Project myProjectOrNull;
    @Nullable
    private ProjectData myParent;
    @NotNull
    private final Consumer<ProjectData> myConsumer;
    private final boolean myIsVisible;
    private JPanel myPanel;
    private JButton mySelectParent;
    private EditorTextField myParentPathField;

    public GradleParentProjectForm(WizardContext context, @Nullable NullableConsumer<ProjectData> consumer) {
        this.$$$setupUI$$$();
        this.myProjectOrNull = context.getProject();
        this.myConsumer = consumer == null ? EmptyConsumer.getInstance() : consumer;
        this.myIsVisible = !context.isCreatingNewProject() && this.myProjectOrNull != null && GradleModuleWizardStep.isGradleModuleExist(context);
        this.initComponents();
    }

    private void createUIComponents() {
        this.myParentPathField = new TextViewer("", this.getProject());
    }

    private void initComponents() {
        this.myPanel.setVisible(this.myIsVisible);
        if (!this.myIsVisible) {
            return;
        }
        this.mySelectParent.setIcon(AllIcons.Actions.Module);
        this.mySelectParent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GradleParentProjectForm.this.myParent = GradleParentProjectForm.this.doSelectProject(GradleParentProjectForm.this.myParent);
                GradleParentProjectForm.this.myConsumer.consume((Object)GradleParentProjectForm.this.myParent);
            }
        });
    }

    public JPanel getComponent() {
        return this.myPanel;
    }

    @Nullable
    public ProjectData getParentProject() {
        return this.myParent;
    }

    public boolean isVisible() {
        return this.myIsVisible;
    }

    public void updateComponents() {
        this.myParentPathField.setText(this.myParent == null ? EMPTY_PARENT : this.myParent.getLinkedExternalProjectPath());
        GradleParentProjectForm.collapseIfPossible(this.myParentPathField, GradleConstants.SYSTEM_ID, this.getProject());
    }

    private ProjectData doSelectProject(ProjectData current) {
        assert (this.myProjectOrNull != null) : "must not be called when creating a new project";
        SelectExternalProjectDialog d = new SelectExternalProjectDialog(GradleConstants.SYSTEM_ID, this.myProjectOrNull, current);
        if (!d.showAndGet()) {
            return current;
        }
        return d.getResult();
    }

    @NotNull
    private Project getProject() {
        Project project = this.myProjectOrNull != null ? this.myProjectOrNull : (Project)ArrayUtil.getFirstElement((Object[])ProjectManager.getInstance().getOpenProjects());
        Project project2 = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/wizard/GradleParentProjectForm", "getProject"));
        }
        return project2;
    }

    private static void collapseIfPossible(@NotNull EditorTextField editorTextField, @NotNull ProjectSystemId systemId, @NotNull Project project) {
        if (editorTextField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorTextField", "org/jetbrains/plugins/gradle/service/project/wizard/GradleParentProjectForm", "collapseIfPossible"));
        }
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "org/jetbrains/plugins/gradle/service/project/wizard/GradleParentProjectForm", "collapseIfPossible"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/wizard/GradleParentProjectForm", "collapseIfPossible"));
        }
        Editor editor = editorTextField.getEditor();
        if (editor != null) {
            String rawText = editor.getDocument().getText();
            if (StringUtil.isEmpty((String)rawText)) {
                return;
            }
            if (EMPTY_PARENT.equals(rawText)) {
                editorTextField.setEnabled(false);
                return;
            }
            Collection projectsData = ProjectDataManager.getInstance().getExternalProjectsData(project, systemId);
            for (ExternalProjectInfo projectInfo : projectsData) {
                if (projectInfo.getExternalProjectStructure() == null || !projectInfo.getExternalProjectPath().equals(rawText)) continue;
                editorTextField.setEnabled(true);
                ExternalProjectPathField.collapse((Editor)editorTextField.getEditor(), (String)((ProjectData)projectInfo.getExternalProjectStructure().getData()).getExternalName());
                return;
            }
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, true));
        jPanel.putClientProperty("BorderFactoryClass", "");
        JLabel jLabel = new JLabel();
        jLabel.setText("Add as module to");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myParentPathField;
        editorTextField.setText("");
        editorTextField.setEnabled(true);
        jPanel.add((Component)editorTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(150, -1), null));
        this.mySelectParent = jButton = new JButton();
        jButton.setHorizontalAlignment(2);
        jButton.setText("");
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel.setLabelFor((Component)editorTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class TextViewer
    extends EditorTextField {
        private final boolean myEmbeddedIntoDialogWrapper;
        private final boolean myUseSoftWraps;

        public TextViewer(@NotNull String initialText, @NotNull Project project) {
            if (initialText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialText", "org/jetbrains/plugins/gradle/service/project/wizard/GradleParentProjectForm$TextViewer", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/wizard/GradleParentProjectForm$TextViewer", "<init>"));
            }
            this(TextViewer.createDocument(initialText), project, true, true);
        }

        public TextViewer(@NotNull Document document, @NotNull Project project, boolean embeddedIntoDialogWrapper, boolean useSoftWraps) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/plugins/gradle/service/project/wizard/GradleParentProjectForm$TextViewer", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/wizard/GradleParentProjectForm$TextViewer", "<init>"));
            }
            super(document, project, (FileType)FileTypes.PLAIN_TEXT, true, false);
            this.myEmbeddedIntoDialogWrapper = embeddedIntoDialogWrapper;
            this.myUseSoftWraps = useSoftWraps;
            this.setFontInheritedFromLAF(false);
        }

        private static Document createDocument(@NotNull String initialText) {
            if (initialText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialText", "org/jetbrains/plugins/gradle/service/project/wizard/GradleParentProjectForm$TextViewer", "createDocument"));
            }
            return EditorFactory.getInstance().createDocument((CharSequence)initialText);
        }

        public void setText(@Nullable String text) {
            super.setText(text != null ? StringUtil.convertLineSeparators((String)text) : null);
        }

        protected EditorEx createEditor() {
            EditorEx editor = super.createEditor();
            editor.setHorizontalScrollbarVisible(true);
            editor.setCaretEnabled(this.isEnabled());
            editor.getScrollPane().setVerticalScrollBarPolicy(20);
            editor.setEmbeddedIntoDialogWrapper(this.myEmbeddedIntoDialogWrapper);
            editor.setBorder(UIUtil.getTextFieldBorder());
            editor.setOneLineMode(true);
            editor.getComponent().setPreferredSize(null);
            editor.getSettings().setUseSoftWraps(this.myUseSoftWraps);
            return editor;
        }

        protected void setViewerEnabled(boolean enabled) {
        }
    }
}

