/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy;

import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.ReflectionTypes;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.JavaResolverComponents;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.KotlinClassLookupResult;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaClassResolver;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.ResolversKt;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.TypeParameterResolver;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaPackageFragment;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaPackageScope;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaPackage;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNullable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LazyJavaPackageFragmentProvider
implements PackageFragmentProvider {
    private final LazyJavaResolverContext c;
    private final MemoizedFunctionToNullable<FqName, LazyJavaPackageFragment> packageFragments;

    private final LazyJavaPackageFragment getPackageFragment(FqName fqName2) {
        return (LazyJavaPackageFragment)this.packageFragments.invoke(fqName2);
    }

    @NotNull
    public List<LazyJavaPackageFragment> getPackageFragments(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.emptyOrSingletonList(this.getPackageFragment(fqName2));
    }

    @NotNull
    public List<FqName> getSubPackagesOf(@NotNull FqName fqName2, @NotNull Function1<? super Name, ? extends Boolean> nameFilter) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Intrinsics.checkParameterIsNotNull(nameFilter, "nameFilter");
        Object object = this.getPackageFragment(fqName2);
        return CollectionsKt.orEmpty(object != null && (object = ((LazyJavaPackageFragment)object).getMemberScope()) != null ? ((LazyJavaPackageScope)object).getSubPackages() : null);
    }

    @Nullable
    public final ClassDescriptor getClass(@NotNull JavaClass javaClass) {
        Intrinsics.checkParameterIsNotNull(javaClass, "javaClass");
        return this.c.getJavaClassResolver().resolveClass(javaClass);
    }

    public LazyJavaPackageFragmentProvider(@NotNull JavaResolverComponents components2, @NotNull ModuleDescriptor module, @NotNull ReflectionTypes reflectionTypes) {
        Intrinsics.checkParameterIsNotNull(components2, "components");
        Intrinsics.checkParameterIsNotNull(module, "module");
        Intrinsics.checkParameterIsNotNull(reflectionTypes, "reflectionTypes");
        this.c = new LazyJavaResolverContext(components2, this, new FragmentClassResolver(), module, reflectionTypes, TypeParameterResolver.EMPTY.INSTANCE);
        this.packageFragments = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<FqName, LazyJavaPackageFragment>(this){
            final /* synthetic */ LazyJavaPackageFragmentProvider this$0;

            @Nullable
            public final LazyJavaPackageFragment invoke(@NotNull FqName fqName2) {
                Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
                JavaPackage jPackage = LazyJavaPackageFragmentProvider.access$getC$p(this.this$0).getComponents().getFinder().findPackage(fqName2);
                return jPackage != null ? new LazyJavaPackageFragment(LazyJavaPackageFragmentProvider.access$getC$p(this.this$0), jPackage) : (LazyJavaPackageFragment)null;
            }
            {
                this.this$0 = lazyJavaPackageFragmentProvider;
                super(1);
            }
        });
    }

    private final class FragmentClassResolver
    implements LazyJavaClassResolver {
        @Override
        @Nullable
        public ClassDescriptor resolveClass(@NotNull JavaClass javaClass) {
            Intrinsics.checkParameterIsNotNull(javaClass, "javaClass");
            FqName fqName2 = javaClass.getFqName();
            if (fqName2 != null && Intrinsics.areEqual((Object)javaClass.getOriginKind(), (Object)JavaClass.OriginKind.KOTLIN_LIGHT_CLASS)) {
                return LazyJavaPackageFragmentProvider.this.c.getComponents().getJavaResolverCache().getClassResolvedFromSource(fqName2);
            }
            JavaClass javaClass2 = javaClass.getOuterClass();
            if (javaClass2 != null) {
                ClassifierDescriptor classifierDescriptor;
                ClassifierDescriptor classifierDescriptor2;
                MemberScope outerClassScope;
                JavaClass outerClass;
                JavaClass $receiver = javaClass2;
                JavaClass javaClass3 = outerClass = $receiver;
                Intrinsics.checkExpressionValueIsNotNull(javaClass3, "outerClass");
                ClassDescriptor classDescriptor = this.resolveClass(javaClass3);
                MemberScope memberScope2 = outerClassScope = classDescriptor != null ? classDescriptor.getUnsubstitutedInnerClassesScope() : null;
                if (memberScope2 != null) {
                    Name name = javaClass.getName();
                    Intrinsics.checkExpressionValueIsNotNull(name, "javaClass.name");
                    classifierDescriptor2 = memberScope2.getContributedClassifier(name, NoLookupLocation.FROM_JAVA_LOADER);
                } else {
                    classifierDescriptor2 = classifierDescriptor = null;
                }
                if (!(classifierDescriptor2 instanceof ClassDescriptor)) {
                    classifierDescriptor = null;
                }
                return (ClassDescriptor)classifierDescriptor;
            }
            KotlinClassLookupResult kotlinResult = ResolversKt.resolveKotlinBinaryClass(LazyJavaPackageFragmentProvider.this.c, LazyJavaPackageFragmentProvider.this.c.getComponents().getKotlinClassFinder().findKotlinClass(javaClass));
            if (kotlinResult instanceof KotlinClassLookupResult.Found) {
                return ((KotlinClassLookupResult.Found)kotlinResult).getDescriptor();
            }
            if (fqName2 == null) {
                return null;
            }
            FqName fqName3 = fqName2.parent();
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "fqName.parent()");
            LazyJavaPackageFragment lazyJavaPackageFragment = LazyJavaPackageFragmentProvider.this.getPackageFragment(fqName3);
            return lazyJavaPackageFragment != null ? lazyJavaPackageFragment.resolveTopLevelClass$kotlin_core(javaClass) : null;
        }
    }
}

