/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class StringLiteralManipulator
extends AbstractElementManipulator<PsiLiteralExpression> {
    @Override
    public PsiLiteralExpression handleContentChange(@NotNull PsiLiteralExpression expr, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/StringLiteralManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/StringLiteralManipulator", "handleContentChange"));
        }
        String oldText = expr.getText();
        if (oldText.startsWith("\"")) {
            newContent = StringUtil.escapeStringCharacters(newContent);
        } else if (oldText.startsWith("'") && newContent.length() <= 1) {
            newContent = newContent.length() == 1 && newContent.charAt(0) == '\'' ? "\\'" : newContent;
        } else {
            throw new IncorrectOperationException("cannot handle content change for: " + oldText + ", expr: " + expr);
        }
        String newText = oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
        PsiExpression newExpr = JavaPsiFacade.getInstance(expr.getProject()).getElementFactory().createExpressionFromText(newText, null);
        return (PsiLiteralExpression)expr.replace(newExpr);
    }

    @Override
    @NotNull
    public TextRange getRangeInElement(@NotNull PsiLiteralExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/StringLiteralManipulator", "getRangeInElement"));
        }
        TextRange textRange = StringLiteralManipulator.getValueRange(element);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/StringLiteralManipulator", "getRangeInElement"));
        }
        return textRange;
    }

    @NotNull
    public static TextRange getValueRange(@NotNull PsiLiteralExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/StringLiteralManipulator", "getValueRange"));
        }
        Object value2 = element.getValue();
        if (!(value2 instanceof String) && !(value2 instanceof Character)) {
            TextRange textRange = TextRange.from(0, element.getTextLength());
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/StringLiteralManipulator", "getValueRange"));
            }
            return textRange;
        }
        TextRange textRange = new TextRange(1, Math.max(1, element.getTextLength() - 1));
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/StringLiteralManipulator", "getValueRange"));
        }
        return textRange;
    }
}

