/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.optimization.common.MethodAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackContext;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"W\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001bB\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0003\u000b\u0005AA!B\u0001\u0005\u0007\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\t\u0006\u0003\u0011\u0015Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\f\u0015\tA1A\u0003\u0002\u0011\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\u0015A\u0001\u0001\u0007\u00013\u0011I!!C\u0001\u0019\u0003a\u0005Q\u0014A\u000b\"\u001e%\u0019\u00012A\u0007\u00021\tI1\u0001#\u0002\u000e\u0003a\u0019\u0011b\u0001E\u0004\u001b\u0005AB!U\u0002\u0002\u0011\u0013)\u0003\u0002B\u0001\t\u001a5\t\u0001TB\r\u0004\u00115i\u0011\u0001'\u0006&\u001f\u0011Q\u00012D\u0007\u0005\u0013\tI\u0011\u0001G\u0001\u0019\u001de\u0019\u0001RD\u0007\u00021\u001bI2\u0001C\b\u000e\u0003a5Q\u0005\u0004\u0003\u000b\u0011?i\u0011\u0001\u0007\t\u001a\u0007!\u0005R\"\u0001M\u00073\rA\u0011#D\u0001\u0019\u000e\u0015^A!\u0001E\u0012\u001b\u0005A\"#F\u0001\u0019&e%\u0001\u0012E\u0007\u00021+\u00016\u0011AS\f\t\u0005A1#D\u0001\u0019%U\t\u0001TEM\u0005\u0011Ci\u0011\u0001'\u0006Q\u0007\u0003);\u0002B\u0001\t(5\t\u0001DE\u000b\u00021KIJ\u0001#\t\u000e\u0003aU\u0001k!\u0001&\u0018\u0011\t\u0001\u0002F\u0007\u00021I)\u0012\u0001'\n\u001a\n!\u0005R\"\u0001M\u000b!\u000e\u0005Qu\u0003\u0003\u0002\u0011Si\u0011\u0001\u0007\n\u0016\u0003a\u0015\u0012\u0014\u0002E\u0011\u001b\u0005A*\u0002UB\u0001S)!1\t\u0003E\u0004\u001b\u0005AB!U\u0002\u0005\u000b\u0001i!\u0001B\u0003\t\f%\u0012Ba\u0011\u000f\t\u000f5\t\u0001TB\r\u0004\u0011\u0019i\u0011\u0001'\u0004!CE\u001bq!\u0002\u0001\u000e\u0005\u0011=\u0001\u0002C\t\u0003\t#A\u0011\"K\n\u0005\u0007\"A\u0019\"\u0004\u0006\n\u0005%\t\u0001TC\u0005\u0006\u0013\u0011I!!C\u0001\u0019\u0003aY\u0001DC)\u0004\t\u0015\u0001QB\u0001C\f\u00111\u0001"}, strings={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer;", "Lorg/jetbrains/kotlin/codegen/optimization/common/MethodAnalyzer;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "owner", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "context", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;)V", "getContext", "()Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "<set-?>", "", "maxExtraStackSize", "getMaxExtraStackSize", "()I", "setMaxExtraStackSize", "(I)V", "savedStacks", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "", "getSavedStacks", "()Ljava/util/HashMap;", "indexOf", "node", "newFrame", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "nLocals", "nStack", "visitControlFlowEdge", "", "insn", "successor", "executeAfterInlineCallMarker", "", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$FixStackFrame;", "executeBeforeInlineCallMarker", "executeRestoreStackInTryCatch", "executeSaveStackBeforeTry", "saveStackAndClear", "FixStackFrame"}, moduleName="kotlin-compiler")
public final class FixStackAnalyzer
extends MethodAnalyzer<BasicValue> {
    @NotNull
    private final HashMap<AbstractInsnNode, List<? extends BasicValue>> savedStacks;
    private int maxExtraStackSize;
    @NotNull
    private final FixStackContext context;

    @NotNull
    public final HashMap<AbstractInsnNode, List<? extends BasicValue>> getSavedStacks() {
        return this.savedStacks;
    }

    public final int getMaxExtraStackSize() {
        return this.maxExtraStackSize;
    }

    @Override
    protected boolean visitControlFlowEdge(int insn, int successor) {
        AbstractInsnNode insnNode = this.getInstructions().get(insn);
        return !(insnNode instanceof JumpInsnNode) || !this.context.getBreakContinueGotoNodes().contains(insnNode);
    }

    @Override
    @NotNull
    protected Frame<BasicValue> newFrame(int nLocals, int nStack) {
        return new FixStackFrame(nLocals, nStack);
    }

    private final int indexOf(AbstractInsnNode node) {
        return this.getMethod().instructions.indexOf(node);
    }

    private final void executeBeforeInlineCallMarker(FixStackFrame $receiver, AbstractInsnNode insn) {
        this.saveStackAndClear($receiver, insn);
    }

    private final void saveStackAndClear(FixStackFrame $receiver, AbstractInsnNode insn) {
        List<BasicValue> savedValues = $receiver.getStackContent();
        MapsKt.set(this.savedStacks, insn, savedValues);
        $receiver.clearStack();
    }

    private final void executeAfterInlineCallMarker(FixStackFrame $receiver, AbstractInsnNode insn) {
        AbstractInsnNode beforeInlineMarker = this.context.getOpeningInlineMethodMarker().get(insn);
        if ($receiver.getStackSize() > 0) {
            List savedValues;
            BasicValue returnValue = $receiver.pop();
            $receiver.clearStack();
            List list = savedValues = (List)CollectionsKt.get((Map)this.savedStacks, beforeInlineMarker);
            if (list == null) {
                Intrinsics.throwNpe();
            }
            $receiver.pushAll(list);
            $receiver.push(returnValue);
        } else {
            List savedValues;
            List list = savedValues = (List)CollectionsKt.get((Map)this.savedStacks, beforeInlineMarker);
            if (list == null) {
                Intrinsics.throwNpe();
            }
            $receiver.pushAll(list);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void executeRestoreStackInTryCatch(FixStackFrame $receiver, AbstractInsnNode insn) {
        void key;
        void $receiver2;
        AbstractInsnNode saveNode = this.context.getSaveStackMarkerForRestoreMarker().get(insn);
        Map map2 = this.savedStacks;
        AbstractInsnNode abstractInsnNode = saveNode;
        if (abstractInsnNode == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "saveNode!!");
        AbstractInsnNode abstractInsnNode2 = abstractInsnNode;
        Object value2 = $receiver2.get(key);
        if (value2 == null && !$receiver2.containsKey(key)) {
            throw (Throwable)((Object)new AssertionError((Object)(this.indexOf(insn) + ": Restore stack is unavailable for " + this.indexOf(saveNode))));
        }
        List savedValues = (List)value2;
        $receiver.pushAll(savedValues);
    }

    private final void executeSaveStackBeforeTry(FixStackFrame $receiver, AbstractInsnNode insn) {
        this.saveStackAndClear($receiver, insn);
    }

    @NotNull
    public final FixStackContext getContext() {
        return this.context;
    }

    public FixStackAnalyzer(@NotNull String owner, @NotNull MethodNode methodNode, @NotNull FixStackContext context) {
        Intrinsics.checkParameterIsNotNull(owner, "owner");
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(context, "context");
        super(owner, methodNode, new OptimizationBasicInterpreter());
        this.context = context;
        this.savedStacks = MapsKt.hashMapOf(new Pair[0]);
    }

    public static final /* synthetic */ int access$getMaxExtraStackSize$p(FixStackAnalyzer $this) {
        return $this.maxExtraStackSize;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"A\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0002B\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0005\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t!\u0015\tAqA\u0003\u0002\u0011=!1I\u0001\u0007\u00013\u0011I!!C\u0001\u0019\u0003a\u0005\u00115DE\u0005\u0011\u0007i\u0011\u0001\u0007\u0002Q\u0007\u0003II\u0001#\u0002\u000e\u0003a\u0011\u0001kA\u0001R\u0007\u0005A1!\n\u0003\u0005\u0017!-Q\"\u0001\r\u0007K=!1\u0002#\u0004\u000e\u0003a1\u0011d\u0001\u0005\b\u001b\u0005Az!\u0007\u0004\t\u00115!\u0011BA\u0005\u00021\u0005A\n\"\n\u0005\u0005\u0017!IQ\"\u0001\r\u00023\rA\u0019\"D\u0001\u0019\u0005\u00152\u0001BC\u0007\u0005\u0013\tI\u0011\u0001G\u0001\u0019\u0016\u0015zAa\u0003\u0005\f\u001b\u0011I!!C\u0001\u0019\u0003a\u0005\u0011d\u0002E\f\u001b\u0015I1\u0001\"\u0001\n\u0003a\t\u0001\u0014A\u0013\u0005\t-AA\"D\u0001\u0019\u0003\u0015BAa\u0003E\r\u001b\u0005Ab!G\u0002\t\u001b5\t\u0001$A\u0013\u000b\u00117i\u0011\u0001\u0007\u0004\u001a\r!qQ\u0002B\u0005\u0003\u0013\u0005A\u0012\u0001'\b*\u001b\u0011\u0019\u0005\u0002c\u0002\u000e\t%\u0011\u0011\"\u0001\r\u00021\u0011\t6\u0001B\u0003\u0001\u001b\t!I\u0001C\u0003"}, strings={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer$FixStackFrame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "nLocals", "", "nStack", "(Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer;II)V", "extraStack", "Lcom/intellij/util/containers/Stack;", "getExtraStack", "()Lcom/intellij/util/containers/Stack;", "clearStack", "", "execute", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "interpreter", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "getStack", "i", "getStackContent", "", "init", "src", "pop", "push", "value", "pushAll", "values", ""}, moduleName="kotlin-compiler")
    public final class FixStackFrame
    extends Frame<BasicValue> {
        @NotNull
        private final Stack<BasicValue> extraStack;

        @NotNull
        public final Stack<BasicValue> getExtraStack() {
            return this.extraStack;
        }

        @Override
        @NotNull
        public Frame<BasicValue> init(@NotNull Frame<? extends BasicValue> src) {
            Intrinsics.checkParameterIsNotNull(src, "src");
            this.extraStack.clear();
            Frame<? extends BasicValue> frame = src;
            if (frame == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackAnalyzer.FixStackFrame");
            }
            this.extraStack.addAll((Collection)((FixStackFrame)frame).extraStack);
            Frame<BasicValue> frame2 = super.init(src);
            Intrinsics.checkExpressionValueIsNotNull(frame2, "super.init(src)");
            return frame2;
        }

        @Override
        public void clearStack() {
            this.extraStack.clear();
            super.clearStack();
        }

        @Override
        public void execute(@NotNull AbstractInsnNode insn, @NotNull Interpreter<BasicValue> interpreter) {
            Intrinsics.checkParameterIsNotNull(insn, "insn");
            Intrinsics.checkParameterIsNotNull(interpreter, "interpreter");
            if (PseudoInsn.SAVE_STACK_BEFORE_TRY.isa(insn)) {
                FixStackAnalyzer.this.executeSaveStackBeforeTry(this, insn);
            } else if (PseudoInsn.RESTORE_STACK_IN_TRY_CATCH.isa(insn)) {
                FixStackAnalyzer.this.executeRestoreStackInTryCatch(this, insn);
            } else if (InlineCodegenUtil.isBeforeInlineMarker(insn)) {
                FixStackAnalyzer.this.executeBeforeInlineCallMarker(this, insn);
            } else if (InlineCodegenUtil.isAfterInlineMarker(insn)) {
                FixStackAnalyzer.this.executeAfterInlineCallMarker(this, insn);
            } else if (InlineCodegenUtil.isMarkedReturn(insn) && insn.getOpcode() == 177) {
                return;
            }
            super.execute(insn, interpreter);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<BasicValue> getStackContent() {
            ArrayList<BasicValue> savedStack = CollectionsKt.arrayListOf(new BasicValue[0]);
            Iterable $receiver = new IntRange(0, super.getStackSize() - 1);
            for (Object item : $receiver) {
                BasicValue basicValue;
                void it;
                int n = ((Number)item).intValue();
                Collection collection = savedStack;
                Intrinsics.checkExpressionValueIsNotNull((BasicValue)FixStackFrame.super.getStack((int)it), "super.getStack(it)");
                collection.add(basicValue);
            }
            savedStack.addAll((Collection<BasicValue>)this.extraStack);
            return savedStack;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void push(@NotNull BasicValue value2) {
            Intrinsics.checkParameterIsNotNull(value2, "value");
            if (super.getStackSize() < this.getMaxStackSize()) {
                super.push((Value)value2);
            } else {
                void $receiver;
                this.extraStack.add(value2);
                Collection collection = this.extraStack;
                int n = FixStackAnalyzer.this.getMaxExtraStackSize();
                FixStackAnalyzer fixStackAnalyzer = FixStackAnalyzer.this;
                int n2 = $receiver.size();
                fixStackAnalyzer.maxExtraStackSize = Math.max(n, n2);
            }
        }

        public final void pushAll(@NotNull Collection<? extends BasicValue> values) {
            Intrinsics.checkParameterIsNotNull(values, "values");
            Iterable $receiver = values;
            for (Object element : $receiver) {
                BasicValue it = (BasicValue)element;
                this.push(it);
            }
        }

        @Override
        @NotNull
        public BasicValue pop() {
            if (CollectionsKt.isNotEmpty((Collection)this.extraStack)) {
                BasicValue basicValue = this.extraStack.pop();
                Intrinsics.checkExpressionValueIsNotNull(basicValue, "extraStack.pop()");
                return basicValue;
            }
            BasicValue basicValue = (BasicValue)super.pop();
            Intrinsics.checkExpressionValueIsNotNull(basicValue, "super.pop()");
            return basicValue;
        }

        @Override
        @NotNull
        public BasicValue getStack(int i) {
            if (i < super.getMaxStackSize()) {
                BasicValue basicValue = (BasicValue)super.getStack(i);
                Intrinsics.checkExpressionValueIsNotNull(basicValue, "super.getStack(i)");
                return basicValue;
            }
            BasicValue basicValue = (BasicValue)this.extraStack.get(i - this.getMaxStackSize());
            Intrinsics.checkExpressionValueIsNotNull(basicValue, "extraStack[i - getMaxStackSize()]");
            return basicValue;
        }

        public FixStackFrame(int nLocals, int nStack) {
            super(nLocals, nStack);
            this.extraStack = new Stack();
        }
    }
}

