/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.kotlinSignature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.load.java.components.TypeUsage;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtSelfType;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.jvm.JavaDescriptorResolverKt;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.AlternativeSignatureMismatchException;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;

public class TypeTransformingVisitor
extends KtVisitor<KotlinType, Void> {
    private static boolean strictMode = false;
    private final KotlinType originalType;
    private final Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameters;
    private final TypeUsage typeUsage;

    private TypeTransformingVisitor(KotlinType originalType, Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameters, TypeUsage typeUsage) {
        this.originalType = originalType;
        this.typeUsage = typeUsage;
        this.originalToAltTypeParameters = Collections.unmodifiableMap(originalToAltTypeParameters);
    }

    @NotNull
    public static KotlinType computeType(@NotNull KtTypeElement alternativeTypeElement, @NotNull KotlinType originalType, @NotNull Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameters, @NotNull TypeUsage typeUsage) {
        if (alternativeTypeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alternativeTypeElement", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "computeType"));
        }
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "computeType"));
        }
        if (originalToAltTypeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalToAltTypeParameters", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "computeType"));
        }
        if (typeUsage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeUsage", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "computeType"));
        }
        KotlinType computedType = alternativeTypeElement.accept(new TypeTransformingVisitor(originalType, originalToAltTypeParameters, typeUsage), null);
        assert (computedType != null);
        KotlinType kotlinType = computedType;
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "computeType"));
        }
        return kotlinType;
    }

    @Override
    public KotlinType visitNullableType(@NotNull KtNullableType nullableType, Void aVoid) {
        if (nullableType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullableType", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitNullableType"));
        }
        if (!TypeUtils.isNullableType(this.originalType) && this.typeUsage != TypeUsage.TYPE_ARGUMENT) {
            throw new AlternativeSignatureMismatchException("Auto type '%s' is not-null, while type in alternative signature is nullable: '%s'", DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(this.originalType), nullableType.getText());
        }
        KtTypeElement innerType = nullableType.getInnerType();
        assert (innerType != null) : "Syntax error: " + nullableType.getText();
        return TypeUtils.makeNullable(TypeTransformingVisitor.computeType(innerType, this.originalType, this.originalToAltTypeParameters, this.typeUsage));
    }

    @Override
    public KotlinType visitFunctionType(@NotNull KtFunctionType type2, Void data) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitFunctionType"));
        }
        KotlinBuiltIns builtIns = JvmPlatform.INSTANCE$.getBuiltIns();
        return this.visitCommonType(type2.getReceiverTypeReference() == null ? builtIns.getFunction(type2.getParameters().size()) : builtIns.getExtensionFunction(type2.getParameters().size()), (KtTypeElement)type2);
    }

    @Override
    public KotlinType visitUserType(@NotNull KtUserType type2, Void data) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitUserType"));
        }
        KtUserType qualifier2 = type2.getQualifier();
        String shortName = type2.getReferenceExpression().getReferencedName();
        String longName = (qualifier2 == null ? "" : qualifier2.getText() + ".") + shortName;
        return this.visitCommonType(longName, (KtTypeElement)type2);
    }

    private KotlinType visitCommonType(@NotNull ClassDescriptor classDescriptor, @NotNull KtTypeElement type2) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitCommonType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitCommonType"));
        }
        return this.visitCommonType(DescriptorUtils.getFqNameSafe(classDescriptor).asString(), type2);
    }

    @NotNull
    private KotlinType visitCommonType(@NotNull String qualifiedName, @NotNull KtTypeElement type2) {
        MemberScope memberScope2;
        List<TypeProjection> arguments2;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitCommonType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitCommonType"));
        }
        if (this.originalType.isError()) {
            KotlinType kotlinType = this.originalType;
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitCommonType"));
            }
            return kotlinType;
        }
        TypeConstructor originalTypeConstructor = this.originalType.getConstructor();
        ClassifierDescriptor declarationDescriptor = originalTypeConstructor.getDeclarationDescriptor();
        assert (declarationDescriptor != null);
        FqNameUnsafe originalClassFqName = DescriptorUtils.getFqName(declarationDescriptor);
        ClassDescriptor classFromLibrary = TypeTransformingVisitor.getAutoTypeAnalogWithinBuiltins(originalClassFqName, qualifiedName);
        if (!TypeTransformingVisitor.isSameName(qualifiedName, originalClassFqName.asString()) && classFromLibrary == null) {
            throw new AlternativeSignatureMismatchException("Alternative signature type mismatch, expected: %s, actual: %s", qualifiedName, originalClassFqName);
        }
        TypeConstructor typeConstructor2 = classFromLibrary != null ? classFromLibrary.getTypeConstructor() : originalTypeConstructor;
        ClassifierDescriptor typeConstructorClassifier = typeConstructor2.getDeclarationDescriptor();
        if (typeConstructorClassifier instanceof TypeParameterDescriptor && this.originalToAltTypeParameters.containsKey(typeConstructorClassifier)) {
            typeConstructor2 = this.originalToAltTypeParameters.get(typeConstructorClassifier).getTypeConstructor();
        }
        if ((arguments2 = this.originalType.getArguments()).size() != type2.getTypeArgumentsAsTypes().size()) {
            if (JavaDescriptorResolverKt.getPLATFORM_TYPES()) {
                KotlinType kotlinType = this.originalType;
                if (kotlinType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitCommonType"));
                }
                return kotlinType;
            }
            throw new AlternativeSignatureMismatchException("'%s' type in method signature has %d type arguments, while '%s' in alternative signature has %d of them", DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(this.originalType), arguments2.size(), type2.getText(), type2.getTypeArgumentsAsTypes().size());
        }
        ArrayList<TypeProjection> altArguments = new ArrayList<TypeProjection>();
        int size = arguments2.size();
        for (int i = 0; i < size; ++i) {
            altArguments.add(this.getAltArgument(type2, typeConstructor2, i, arguments2.get(i)));
        }
        if (typeConstructorClassifier instanceof TypeParameterDescriptor) {
            memberScope2 = typeConstructorClassifier.getDefaultType().getMemberScope();
        } else if (typeConstructorClassifier instanceof ClassDescriptor) {
            memberScope2 = ((ClassDescriptor)typeConstructorClassifier).getMemberScope(altArguments);
        } else {
            throw new AssertionError((Object)("Unexpected class of type constructor classifier " + (typeConstructorClassifier == null ? "null" : typeConstructorClassifier.getClass().getName())));
        }
        KotlinTypeImpl kotlinTypeImpl = KotlinTypeImpl.create(this.originalType.getAnnotations(), typeConstructor2, false, altArguments, memberScope2);
        if (kotlinTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitCommonType"));
        }
        return kotlinTypeImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private TypeProjection getAltArgument(@NotNull KtTypeElement type2, @NotNull TypeConstructor typeConstructor2, int i, @NotNull TypeProjection originalArgument) {
        Variance altProjectionKind;
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "getAltArgument"));
        }
        if (typeConstructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "getAltArgument"));
        }
        if (originalArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalArgument", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "getAltArgument"));
        }
        KtTypeReference typeReference = type2.getTypeArgumentsAsTypes().get(i);
        if (typeReference == null) {
            assert (type2 instanceof KtUserType && ((KtUserType)type2).getTypeArguments().get(i).getProjectionKind() == KtProjectionKind.STAR);
            TypeProjection typeProjection = originalArgument;
            if (typeProjection != null) return typeProjection;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "getAltArgument"));
        }
        KtTypeElement argumentAlternativeTypeElement = typeReference.getTypeElement();
        assert (argumentAlternativeTypeElement != null);
        TypeParameterDescriptor parameter = typeConstructor2.getParameters().get(i);
        KotlinType alternativeArgumentType = TypeTransformingVisitor.computeType(argumentAlternativeTypeElement, originalArgument.getType(), this.originalToAltTypeParameters, TypeUsage.TYPE_ARGUMENT);
        Variance projectionKind = originalArgument.getProjectionKind();
        if (type2 instanceof KtUserType) {
            KtTypeProjection typeProjection = ((KtUserType)type2).getTypeArguments().get(i);
            altProjectionKind = TypeResolver.resolveProjectionKind(typeProjection.getProjectionKind());
            if (altProjectionKind != projectionKind && projectionKind != Variance.INVARIANT && !JavaDescriptorResolverKt.getPLATFORM_TYPES()) {
                throw new AlternativeSignatureMismatchException("Projection kind mismatch, actual: %s, in alternative signature: %s", new Object[]{projectionKind, altProjectionKind});
            }
            if (altProjectionKind != Variance.INVARIANT && parameter.getVariance() != Variance.INVARIANT) {
                if (altProjectionKind != parameter.getVariance()) throw new AlternativeSignatureMismatchException("Projection kind '%s' is conflicting with variance of %s", new Object[]{altProjectionKind, DescriptorUtils.getFqName(typeConstructor2.getDeclarationDescriptor())});
                if (strictMode) {
                    throw new AlternativeSignatureMismatchException("Projection kind '%s' is redundant", new Object[]{altProjectionKind, DescriptorUtils.getFqName(typeConstructor2.getDeclarationDescriptor())});
                }
                altProjectionKind = projectionKind;
            }
        } else {
            altProjectionKind = projectionKind;
        }
        TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(altProjectionKind, alternativeArgumentType);
        if (typeProjectionImpl != null) return typeProjectionImpl;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "getAltArgument"));
    }

    @Nullable
    private static ClassDescriptor getAutoTypeAnalogWithinBuiltins(@NotNull FqNameUnsafe originalClassFqName, @NotNull String qualifiedName) {
        if (originalClassFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalClassFqName", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "getAutoTypeAnalogWithinBuiltins"));
        }
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "getAutoTypeAnalogWithinBuiltins"));
        }
        ClassId javaClassId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(originalClassFqName);
        if (javaClassId == null) {
            return null;
        }
        Collection<ClassDescriptor> descriptors = JavaToKotlinClassMap.INSTANCE.mapPlatformClass(javaClassId.asSingleFqName());
        for (ClassDescriptor descriptor2 : descriptors) {
            String fqName2 = DescriptorUtils.getFqName(descriptor2).asString();
            if (!TypeTransformingVisitor.isSameName(qualifiedName, fqName2)) continue;
            return descriptor2;
        }
        return null;
    }

    @Override
    public KotlinType visitSelfType(@NotNull KtSelfType type2, Void data) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/TypeTransformingVisitor", "visitSelfType"));
        }
        throw new UnsupportedOperationException("Self-types are not supported yet");
    }

    private static boolean isSameName(String qualifiedName, String fullyQualifiedName) {
        return fullyQualifiedName.equals(qualifiedName) || fullyQualifiedName.endsWith("." + qualifiedName);
    }

    public static void setStrictMode(boolean strictMode) {
        TypeTransformingVisitor.strictMode = strictMode;
    }
}

