/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import org.gradle.api.Nullable;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.core.ModelMapGroovyDecorator;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.cache.ModelSchemaCache;
import org.gradle.model.internal.manage.schema.extract.ManagedCollectionProxyClassGenerator;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionResult;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecializedMapStrategy
implements ModelSchemaExtractionStrategy {
    private final ManagedCollectionProxyClassGenerator generator = new ManagedCollectionProxyClassGenerator();

    @Override
    @Nullable
    public <T> ModelSchemaExtractionResult<T> extract(ModelSchemaExtractionContext<T> extractionContext, ModelSchemaCache cache) {
        Type type = extractionContext.getType().getType();
        if (!(type instanceof Class)) {
            return null;
        }
        Class contractType = (Class)type;
        if (!contractType.isInterface()) {
            return null;
        }
        if (contractType.getGenericInterfaces().length != 1) {
            return null;
        }
        Type superType = contractType.getGenericInterfaces()[0];
        if (!(superType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedSuperType = (ParameterizedType)superType;
        if (!parameterizedSuperType.getRawType().equals(ModelMap.class)) {
            return null;
        }
        ModelType<?> elementType = ModelType.of(parameterizedSuperType.getActualTypeArguments()[0]);
        Class<?> proxyImpl = this.generator.generate(ModelMapGroovyDecorator.class, contractType);
        return new ModelSchemaExtractionResult<T>(ModelSchema.specializedMap(extractionContext.getType(), elementType, proxyImpl));
    }

    @Override
    public Iterable<String> getSupportedManagedTypes() {
        return Collections.emptySet();
    }
}

