/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.SchemeManagerFactoryImplKt;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.ide.actions.ExportSettingsActionKt;
import com.intellij.ide.actions.ExportableItem;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManager;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"5\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\b\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!9Q!\u0001\u0003\u0002\u000b\u0005a\u0011!d\u0005\t\u00015\t\u0001\u0014A\r\u0005\t\u0005A\u0011!D\u0001\u0019\u0004Q\u001b!!$\u0007\u0005\u0003!\u0015Q\"\u0001\r\u00043\u0019A9!\u0004\u0003\n\u0005%\t\u0001\u0014\u0002\r\u0005)\u000e\u0011Q2\u0006\u0003\u0002\u0011\u0015i\u0011\u0001'\u0001\u001a\u0007!-Q\"\u0001\r\u00073\rAi!D\u0001\u0019\u000fe\u0019\u0001rB\u0007\u00021\rI2\u0001\u0003\u0005\u000e\u0003aEAk\u0001\u0002"}, strings={"copyLocalConfig", "", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "CopyAppSettingsToRepositoryKt", "getRoamingType", "Lcom/intellij/openapi/components/RoamingType;", "components", "", "Lcom/intellij/ide/actions/ExportableItem;", "saveDirectory", "parent", "Ljava/io/File;", "parentFileSpec", "", "roamingType", "streamProvider", "Lorg/jetbrains/settingsRepository/IcsManager$IcsStreamProvider;"}, moduleName="settings-repository")
public final class CopyAppSettingsToRepositoryKt {
    public static final void copyLocalConfig(@NotNull StateStorageManagerImpl storageManager) {
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        StreamProvider streamProvider = storageManager.getStreamProvider();
        if (streamProvider == null) {
            Intrinsics.throwNpe();
        }
        if (streamProvider == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.settingsRepository.IcsManager.IcsStreamProvider");
        }
        IcsManager.IcsStreamProvider streamProvider2 = (IcsManager.IcsStreamProvider)streamProvider;
        Map fileToComponents = ExportSettingsActionKt.getExportableComponentsMap$default((boolean)true, (boolean)false, (StateStorageManager)((StateStorageManager)storageManager), null, (int)8);
        for (File file : fileToComponents.keySet()) {
            String canonicalPath;
            String absolutePath;
            String string = absolutePath = FileUtilRt.toSystemIndependentName((String)file.getAbsolutePath());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"absolutePath");
            String fileSpec = StateStorageManagerImplKt.removeMacroIfStartsWith((String)storageManager.collapseMacros(string), (String)SchemeManagerFactoryImplKt.getROOT_CONFIG());
            if (Intrinsics.areEqual((Object)fileSpec, (Object)absolutePath) && Intrinsics.areEqual((Object)(canonicalPath = FileUtilRt.toSystemIndependentName((String)file.getCanonicalPath())), (Object)absolutePath) ^ true) {
                String string2 = canonicalPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"canonicalPath");
                fileSpec = StateStorageManagerImplKt.removeMacroIfStartsWith((String)storageManager.collapseMacros(string2), (String)SchemeManagerFactoryImplKt.getROOT_CONFIG());
            }
            Object v = fileToComponents.get(file);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            RoamingType roamingType = CopyAppSettingsToRepositoryKt.getRoamingType((Collection)v);
            if (file.isFile()) {
                byte[] fileBytes = FileUtil.loadFileBytes((File)file);
                Intrinsics.checkExpressionValueIsNotNull((Object)fileBytes, (String)"fileBytes");
                streamProvider2.doSave(fileSpec, fileBytes, fileBytes.length, roamingType);
                continue;
            }
            CopyAppSettingsToRepositoryKt.saveDirectory(file, fileSpec, roamingType, streamProvider2);
        }
    }

    public static /* bridge */ /* synthetic */ void copyLocalConfig$default(StateStorageManagerImpl stateStorageManagerImpl, int n) {
        if ((n & 1) != 0) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                Intrinsics.throwNpe();
            }
            StateStorageManager stateStorageManager = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application)).getStateStorageManager();
            if (stateStorageManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.StateStorageManagerImpl");
            }
            stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
        }
        CopyAppSettingsToRepositoryKt.copyLocalConfig(stateStorageManagerImpl);
    }

    /*
     * WARNING - void declaration
     */
    private static final void saveDirectory(File parent, String parentFileSpec, RoamingType roamingType, IcsManager.IcsStreamProvider streamProvider) {
        Unit unit;
        File[] fileArray = parent.listFiles();
        if (fileArray != null) {
            void $receiver;
            File[] fileArray2 = fileArray;
            File[] it = (File[])$receiver;
            for (int i = 0; i < it.length; ++i) {
                File file = it[i];
                String childFileSpec = parentFileSpec + "/" + file.getName();
                if (file.isFile()) {
                    byte[] fileBytes = FileUtil.loadFileBytes((File)file);
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileBytes, (String)"fileBytes");
                    streamProvider.doSave(childFileSpec, fileBytes, fileBytes.length, roamingType);
                    continue;
                }
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                CopyAppSettingsToRepositoryKt.saveDirectory(file2, childFileSpec, roamingType, streamProvider);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    private static final RoamingType getRoamingType(Collection<? extends ExportableItem> components) {
        for (ExportableItem exportableItem : components) {
            if (!(exportableItem instanceof ExportableItem)) continue;
            return exportableItem.getRoamingType();
        }
        return RoamingType.DEFAULT;
    }
}

