/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.execution.Location;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.testAssistant.TestLocationDataRule;

public class TestCaseAsRelatedFileProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/devkit/testAssistant/TestCaseAsRelatedFileProvider", "getItems"));
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
        if (editor == null || file == null || project == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestCaseAsRelatedFileProvider", "getItems"));
            }
            return list;
        }
        List<Location> locations = TestLocationDataRule.collectRelativeLocations(project, file);
        if (locations.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestCaseAsRelatedFileProvider", "getItems"));
            }
            return list;
        }
        List list = ContainerUtil.map(locations, (Function)new Function<Location, GotoRelatedItem>(){

            public GotoRelatedItem fun(Location location) {
                return new GotoRelatedItem(location.getPsiElement());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestCaseAsRelatedFileProvider", "getItems"));
        }
        return list;
    }
}

